/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.AbstractDebugListSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class SelectLaunchModesDialog
extends AbstractDebugListSelectionDialog {
    private List<Set<String>> fValidModes = null;

    public SelectLaunchModesDialog(Shell parentShell, String mode, ILaunchConfiguration configuration) throws CoreException {
        super(parentShell);
        super.setTitle(LaunchConfigurationsMessages.SelectLaunchOptionsDialog_3);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fValidModes = new ArrayList<Set<String>>();
        Set modes = configuration.getType().getSupportedModeCombinations();
        for (Set modeset : modes) {
            if (!modeset.contains(mode)) continue;
            this.fValidModes.add(modeset);
        }
    }

    @Override
    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.SELECT_LAUNCH_MODES_DIALOG";
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new OptionsLabelProvider();
    }

    @Override
    protected Object getViewerInput() {
        return this.fValidModes.toArray();
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_launch_modes_dialog";
    }

    @Override
    protected String getViewerLabel() {
        return LaunchConfigurationsMessages.SelectLaunchOptionsDialog_4;
    }

    class OptionsLabelProvider
    implements ILabelProvider {
        OptionsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            Set vals = (Set)element;
            HashSet<String> modes = new HashSet<String>(vals.size());
            for (Object o : vals) {
                modes.add((String)o);
            }
            List<String> names = LaunchConfigurationPresentationManager.getDefault().getLaunchModeNames(modes);
            return names.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

