/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.variables.details;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DetailPaneMaxLengthDialog
extends TrayDialog {
    private static final String SETTINGS_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MAX_DETAILS_LENGTH_DIALOG";
    private Text fTextWidget;
    private Text fErrorTextWidget;
    private String fErrorMessage;
    private String fValue;
    private IInputValidator fValidator;

    public DetailPaneMaxLengthDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fValue = Integer.toString(DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length"));
        this.fValidator = newText -> {
            try {
                int num = Integer.parseInt(newText);
                if (num < 0) {
                    return VariablesViewMessages.DetailPaneMaxLengthDialog_2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return VariablesViewMessages.DetailPaneMaxLengthDialog_3;
            }
            return null;
        };
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(VariablesViewMessages.DetailPaneMaxLengthDialog_0);
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getDialogArea(), "org.eclipse.debug.ui.detail_pane_max_length_action_context");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(VariablesViewMessages.DetailPaneMaxLengthDialog_1);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.fTextWidget = new Text(composite, 2052);
        this.fTextWidget.setLayoutData((Object)new GridData(768));
        this.fTextWidget.setText(this.fValue);
        this.fTextWidget.addModifyListener(e -> {
            this.validateInput();
            this.fValue = this.fTextWidget.getText();
        });
        this.fErrorTextWidget = new Text(composite, 8);
        this.fErrorTextWidget.setLayoutData((Object)new GridData(768));
        this.fErrorTextWidget.setBackground(this.fErrorTextWidget.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.fErrorMessage);
        DetailPaneMaxLengthDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        String text = this.getValue();
        try {
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.max_detail_length", Integer.parseInt(text));
        }
        catch (NumberFormatException e) {
            DebugUIPlugin.log(e);
        }
        super.okPressed();
    }

    public String getValue() {
        return this.fValue;
    }

    private void validateInput() {
        String errorMessage = null;
        if (this.fValidator != null) {
            errorMessage = this.fValidator.isValid(this.fTextWidget.getText());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
        if (this.fErrorTextWidget != null && !this.fErrorTextWidget.isDisposed()) {
            this.fErrorTextWidget.setText(errorMessage == null ? "" : errorMessage);
            this.fErrorTextWidget.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }
}

