/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.internal.core.RemoteCorePlugin;

public class LocalConnectionPropertyService
implements IRemoteConnectionPropertyService {
    private final IRemoteConnection connection;

    public LocalConnectionPropertyService(IRemoteConnection connection) {
        this.connection = connection;
    }

    @Override
    public IRemoteConnection getRemoteConnection() {
        return this.connection;
    }

    @Override
    public String getProperty(String key) {
        switch (key) {
            case "os.name": {
                return RemoteCorePlugin.getDefault().getBundle().getBundleContext().getProperty("osgi.os");
            }
            case "os.arch": {
                return RemoteCorePlugin.getDefault().getBundle().getBundleContext().getProperty("osgi.arch");
            }
            case "locale.charmap": {
                return System.getProperty("file.encoding");
            }
        }
        return System.getProperty(key);
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        @Override
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (service.equals(IRemoteConnectionPropertyService.class)) {
                return (T)new LocalConnectionPropertyService(remoteConnection);
            }
            return null;
        }
    }
}

