/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;

public class NonExistingFileEditorInput
implements IEditorInput,
ILocationProvider {
    private static int fgNonExisting = 0;
    private IFileStore fFileStore;
    private String fName;

    public NonExistingFileEditorInput(IFileStore fileStore, String namePrefix) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fName = String.valueOf(namePrefix) + " " + ++fgNonExisting;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fName);
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ILocationProvider.class.equals(adapter)) {
            return (T)this;
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IPath getPath(Object element) {
        if (element instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput input = (NonExistingFileEditorInput)element;
            return new Path(input.fFileStore.toURI().getPath());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput input = (NonExistingFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }
}

