/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.HashSet;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.ConvertLineDelimitersOperation;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.FileBufferOperationAction;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.SelectResourcesDialog;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class ConvertLineDelimitersAction
extends FileBufferOperationAction {
    private String fLabel;
    private boolean fStrictCheckIfTextLocation;

    protected ConvertLineDelimitersAction(String lineDelimiter, String label) {
        super((IFileBufferOperation)new ConvertLineDelimitersOperation(lineDelimiter));
        this.setText(ConvertLineDelimitersAction.constructLabel(label, lineDelimiter, System.lineSeparator()));
        this.fLabel = Action.removeMnemonics((String)label);
    }

    private static String constructLabel(String label, String lineDelimiter, String platformLineDelimiter) {
        if (lineDelimiter.equals(platformLineDelimiter)) {
            return String.valueOf(label) + TextEditorMessages.ConvertLineDelimitersAction_default_label;
        }
        return label;
    }

    @Override
    protected boolean isAcceptableLocation(IPath location) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return location != null && manager.isTextFileLocation(location, this.fStrictCheckIfTextLocation);
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.fStrictCheckIfTextLocation = !(selection instanceof ITextSelection);
    }

    @Override
    protected IFile[] collectFiles(IResource[] resources) {
        boolean bl = this.fStrictCheckIfTextLocation = this.fStrictCheckIfTextLocation || resources.length != 1 || resources[0].getType() != 1;
        if (this.containsOnlyFiles(resources)) {
            IFile[] files = super.collectFiles(resources);
            return this.filterUnacceptableFiles(files);
        }
        SelectResourcesDialog.IFilter filter = resource -> resource != null && this.isAcceptableLocation(resource.getFullPath());
        SelectResourcesDialog dialog = new SelectResourcesDialog(this.getShell(), this.getDialogTitle(), TextEditorMessages.ConvertLineDelimitersAction_dialog_description, filter){

            @Override
            protected Composite createSelectionButtonGroup(Composite parent) {
                Composite buttonGroup = super.createSelectionButtonGroup(parent);
                final Button button = new Button(buttonGroup, 32);
                ++((GridLayout)buttonGroup.getLayout()).numColumns;
                button.setText(TextEditorMessages.ConvertLineDelimitersAction_show_only_text_files);
                button.setFont(JFaceResources.getDialogFont());
                button.setSelection(ConvertLineDelimitersAction.this.fStrictCheckIfTextLocation);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        ConvertLineDelimitersAction.this.fStrictCheckIfTextLocation = button.getSelection();
                        this.refresh();
                    }
                });
                return buttonGroup;
            }
        };
        dialog.setInput(resources);
        int result = dialog.open();
        if (result == 0) {
            IResource[] selectedResources = dialog.getSelectedResources();
            return super.collectFiles(selectedResources);
        }
        return null;
    }

    private String getDialogTitle() {
        return NLSUtility.format(TextEditorMessages.ConvertLineDelimitersAction_dialog_title, this.fLabel);
    }

    private boolean containsOnlyFiles(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if ((1 & resource.getType()) == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private IFile[] filterUnacceptableFiles(IFile[] files) {
        boolean askForBinary = true;
        HashSet<IFile> filtered = new HashSet<IFile>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (this.isAcceptableLocation(file.getFullPath())) {
                filtered.add(file);
            } else if (askForBinary) {
                int result = new MessageDialog(this.getShell(), this.getDialogTitle(), null, TextEditorMessages.ConvertLineDelimitersAction_nontext_selection, 4, new String[]{TextEditorMessages.ConvertLineDelimitersAction_convert_all, TextEditorMessages.ConvertLineDelimitersAction_convert_text, IDialogConstants.CANCEL_LABEL}, 1).open();
                if (result == 0) {
                    this.fStrictCheckIfTextLocation = false;
                    filtered.add(file);
                } else if (result == 1) {
                    askForBinary = false;
                } else {
                    return null;
                }
            }
            ++n2;
        }
        return filtered.toArray(new IFile[filtered.size()]);
    }
}

