/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableKernelEvents;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlContentProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlLabelProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class EnableKernelEventComposite
extends Composite
implements IEnableKernelEvents {
    private Button fAllActivateButton;
    private Button fTracepointsActivateButton;
    private CheckboxTreeViewer fTracepointsViewer;
    private CheckboxTreeViewer fSyscallsViewer;
    private Button fSyscallsActivateButton;
    private Text fSpecificEventText;
    private Button fProbeActivateButton;
    private Text fProbeEventNameText;
    private Text fProbeText;
    private Button fFunctionActivateButton;
    private Text fFunctionEventNameText;
    private Text fFunctionText;
    private Text fFilterText;
    private final TraceProviderGroup fProviderGroup;
    private boolean fIsAllTracepointsAndSyscalls;
    private boolean fIsTracepoints;
    private boolean fIsAllTracepoints;
    private boolean fIsSyscalls;
    private boolean fIsAllSyscalls;
    private List<String> fSelectedEvents;
    private boolean fIsDynamicProbe;
    private String fProbeEventName;
    private String fProbeString;
    private boolean fIsDynamicFunctionProbe;
    private String fFunctionEventName;
    private String fFunctionString;
    private String fFilterExpression;

    public EnableKernelEventComposite(Composite parent, int style, TraceProviderGroup providerGroup) {
        super(parent, style);
        this.fProviderGroup = providerGroup;
    }

    @Override
    public boolean isAllEvents() {
        return this.fIsAllTracepointsAndSyscalls;
    }

    @Override
    public boolean isTracepoints() {
        return this.fIsTracepoints;
    }

    @Override
    public boolean isAllTracePoints() {
        return this.fIsAllTracepoints;
    }

    @Override
    public boolean isSyscalls() {
        return this.fIsSyscalls;
    }

    @Override
    public boolean isAllSyscalls() {
        return this.fIsAllSyscalls;
    }

    @Override
    public List<String> getEventNames() {
        return new ArrayList<String>(this.fSelectedEvents);
    }

    @Override
    public boolean isDynamicProbe() {
        return this.fIsDynamicProbe;
    }

    @Override
    public String getProbeName() {
        return this.fProbeString;
    }

    @Override
    public String getProbeEventName() {
        return this.fProbeEventName;
    }

    @Override
    public boolean isDynamicFunctionProbe() {
        return this.fIsDynamicFunctionProbe;
    }

    @Override
    public String getFunctionEventName() {
        return this.fFunctionEventName;
    }

    @Override
    public String getFunction() {
        return this.fFunctionString;
    }

    @Override
    public String getFilterExpression() {
        return this.fFilterExpression;
    }

    public void createContent() {
        this.createAllTracepointsSyscallGroup();
        this.createTracepointsGroup();
        this.createSyscallsGroup();
        this.createDynamicProbeGroup();
        this.createDynamicFunctionPropeGroup();
        this.createFilterGroup();
        this.setKernelEnablements(KernelGroupEnum.ALL);
    }

    public boolean isValid() {
        String tempFilter;
        int n;
        int n2;
        ITraceControlComponent[] iTraceControlComponentArray;
        List<ITraceControlComponent> comps;
        ITraceControlComponent component;
        int i;
        Object[] checkedElements;
        this.fIsAllTracepointsAndSyscalls = this.fAllActivateButton.getSelection();
        this.fIsTracepoints = this.fTracepointsActivateButton.getSelection();
        this.fIsSyscalls = this.fSyscallsActivateButton.getSelection();
        this.fIsDynamicProbe = this.fProbeActivateButton.getSelection();
        this.fIsDynamicFunctionProbe = this.fFunctionActivateButton.getSelection();
        this.fIsAllTracepoints = false;
        this.fSelectedEvents = new ArrayList<String>();
        if (this.fIsTracepoints) {
            checkedElements = this.fTracepointsViewer.getCheckedElements();
            i = 0;
            while (i < checkedElements.length) {
                component = (ITraceControlComponent)checkedElements[i];
                if (component instanceof BaseEventComponent) {
                    this.fSelectedEvents.add(component.getName());
                }
                ++i;
            }
            int nbEvents = 0;
            comps = this.fProviderGroup.getChildren(KernelProviderComponent.class);
            for (ITraceControlComponent comp : comps) {
                iTraceControlComponentArray = comp.getChildren();
                n2 = iTraceControlComponentArray.length;
                n = 0;
                while (n < n2) {
                    ITraceControlComponent event = iTraceControlComponentArray[n];
                    if (event instanceof BaseEventComponent && ((BaseEventComponent)event).getEventType() == TraceEventType.TRACEPOINT) {
                        ++nbEvents;
                    }
                    ++n;
                }
            }
            this.fIsAllTracepoints = nbEvents == this.fSelectedEvents.size();
            String tmpSpecificEvent = this.fSpecificEventText.getText();
            if (!this.fIsAllTracepoints && !tmpSpecificEvent.trim().isEmpty()) {
                tmpSpecificEvent = tmpSpecificEvent.replaceAll("\\s", "");
                List<String> list = Arrays.asList(tmpSpecificEvent.split(","));
                this.fSelectedEvents.addAll(list);
                this.fSelectedEvents = this.fSelectedEvents.stream().distinct().collect(Collectors.toList());
            }
        }
        this.fIsAllSyscalls = false;
        if (this.fIsSyscalls) {
            if (this.fSyscallsViewer != null) {
                checkedElements = this.fSyscallsViewer.getCheckedElements();
                i = 0;
                while (i < checkedElements.length) {
                    component = (ITraceControlComponent)checkedElements[i];
                    if (component instanceof BaseEventComponent) {
                        this.fSelectedEvents.add(component.getName());
                    }
                    ++i;
                }
                int nbSyscalls = 0;
                comps = this.fProviderGroup.getChildren(KernelProviderComponent.class);
                for (ITraceControlComponent comp : comps) {
                    iTraceControlComponentArray = comp.getChildren();
                    n2 = iTraceControlComponentArray.length;
                    n = 0;
                    while (n < n2) {
                        ITraceControlComponent syscall = iTraceControlComponentArray[n];
                        if (syscall instanceof BaseEventComponent && ((BaseEventComponent)syscall).getEventType() == TraceEventType.SYSCALL) {
                            ++nbSyscalls;
                        }
                        ++n;
                    }
                }
                boolean bl = this.fIsAllSyscalls = nbSyscalls == this.fSelectedEvents.size();
                if (!this.fIsAllSyscalls) {
                    this.fSelectedEvents = this.fSelectedEvents.stream().distinct().collect(Collectors.toList());
                }
            } else {
                this.fIsAllSyscalls = true;
            }
        }
        if (this.fIsDynamicProbe) {
            String temp = this.fProbeEventNameText.getText();
            if (temp.trim().isEmpty() || !temp.matches("^[\\s]{0,}$") && !temp.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidProbeNameError) + " (" + temp + ") \n"));
                return false;
            }
            this.fProbeEventName = temp;
            this.fProbeString = this.fProbeText.getText();
        }
        this.fFunctionEventName = null;
        this.fFunctionString = null;
        if (this.fIsDynamicFunctionProbe) {
            String functionTemp = this.fFunctionEventNameText.getText();
            if (functionTemp.trim().isEmpty() || !functionTemp.matches("^[\\s]{0,}$") && !functionTemp.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidProbeNameError) + " (" + functionTemp + ") \n"));
                return false;
            }
            this.fFunctionEventName = functionTemp;
            this.fFunctionString = this.fFunctionText.getText();
        }
        this.fFilterExpression = null;
        if (this.fProviderGroup.isEventFilteringSupported(TraceDomainType.KERNEL) && !(tempFilter = this.fFilterText.getText()).trim().isEmpty()) {
            this.fFilterExpression = tempFilter;
        }
        return true;
    }

    private void createAllTracepointsSyscallGroup() {
        Group tpMainGroup = new Group((Composite)this, 32);
        tpMainGroup.setText(Messages.TraceControl_EnableEventsAllEventsLabel);
        GridLayout layout = new GridLayout(2, false);
        tpMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        tpMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)tpMainGroup, 0);
        layout = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fAllActivateButton = new Button(buttonComposite, 16);
        this.fAllActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fAllActivateButton.setToolTipText(Messages.TraceControl_EnableEventsAllEventsTooltip);
        data = new GridData(768);
        this.fAllActivateButton.setLayoutData((Object)data);
        this.fAllActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.ALL);
            }
        });
    }

    private void createTracepointsGroup() {
        Group tpMainGroup = new Group((Composite)this, 32);
        tpMainGroup.setText(Messages.TraceControl_EnableEventsTracepointGroupName);
        GridLayout layout = new GridLayout(2, false);
        tpMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        tpMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)tpMainGroup, 0);
        layout = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fTracepointsActivateButton = new Button(buttonComposite, 16);
        this.fTracepointsActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        data = new GridData(768);
        this.fTracepointsActivateButton.setLayoutData((Object)data);
        this.fTracepointsActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.TRACEPOINTS);
            }
        });
        Group tracepointsGroup = new Group((Composite)tpMainGroup, 32);
        layout = new GridLayout(1, true);
        tracepointsGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        tracepointsGroup.setLayoutData((Object)data);
        new FilteredTree((Composite)tracepointsGroup, 2818, new PatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite aparent, int style) {
                EnableKernelEventComposite.this.fTracepointsViewer = new CheckboxTreeViewer(aparent, 770);
                EnableKernelEventComposite.this.fTracepointsViewer.getTree().setToolTipText(Messages.TraceControl_EnableEventsTracepointTreeTooltip);
                EnableKernelEventComposite.this.fTracepointsViewer.setContentProvider((IContentProvider)new KernelContentProvider(TraceEventType.TRACEPOINT));
                EnableKernelEventComposite.this.fTracepointsViewer.setLabelProvider((IBaseLabelProvider)new KernelLabelProvider());
                EnableKernelEventComposite.this.fTracepointsViewer.addCheckStateListener((ICheckStateListener)new KernelCheckListener(EnableKernelEventComposite.this.fTracepointsViewer));
                EnableKernelEventComposite.this.fTracepointsViewer.setInput((Object)EnableKernelEventComposite.this.fProviderGroup);
                EnableKernelEventComposite.this.fTracepointsViewer.getTree().setLayoutData((Object)new GridData(1808));
                return EnableKernelEventComposite.this.fTracepointsViewer;
            }

            protected void updateToolbar(boolean visible) {
                super.updateToolbar(visible);
                this.treeViewer.expandAll();
            }
        };
        Group specificEventGroup = new Group((Composite)tracepointsGroup, 32);
        specificEventGroup.setText(Messages.TraceControl_EnableEventsSpecificEventGroupName);
        layout = new GridLayout(4, true);
        specificEventGroup.setLayout((Layout)layout);
        specificEventGroup.setLayoutData((Object)new GridData(768));
        Label specificEventLabel = new Label((Composite)specificEventGroup, 16384);
        specificEventLabel.setText(Messages.TraceControl_EnableEventsNameLabel);
        data = new GridData(768);
        data.horizontalSpan = 1;
        specificEventLabel.setLayoutData((Object)data);
        this.fSpecificEventText = new Text((Composite)specificEventGroup, 16384);
        this.fSpecificEventText.setToolTipText(Messages.TraceControl_EnableEventsSpecificEventTooltip);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSpecificEventText.setLayoutData((Object)data);
    }

    private void createSyscallsGroup() {
        Group syscallMainGroup = new Group((Composite)this, 32);
        syscallMainGroup.setText(Messages.TraceControl_EnableEventsSyscallName);
        GridLayout layout = new GridLayout(2, false);
        syscallMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        syscallMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)syscallMainGroup, 0);
        layout = new GridLayout(1, true);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fSyscallsActivateButton = new Button(buttonComposite, 16);
        this.fSyscallsActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fSyscallsActivateButton.setSelection(false);
        data = new GridData(768);
        this.fSyscallsActivateButton.setLayoutData((Object)data);
        this.fSyscallsActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.SYSCALLS);
            }
        });
        if (this.fProviderGroup.isPerSyscallEventsSupported()) {
            Group syscallGroup = new Group((Composite)syscallMainGroup, 32);
            layout = new GridLayout(1, true);
            syscallGroup.setLayout((Layout)layout);
            data = new GridData(1808);
            syscallGroup.setLayoutData((Object)data);
            new FilteredTree((Composite)syscallGroup, 2818, new PatternFilter(), true){

                protected TreeViewer doCreateTreeViewer(Composite aparent, int style) {
                    EnableKernelEventComposite.this.fSyscallsViewer = new CheckboxTreeViewer(aparent, 770);
                    EnableKernelEventComposite.this.fSyscallsViewer.getTree().setToolTipText(Messages.TraceControl_EnableEventsSyscallTooltip);
                    EnableKernelEventComposite.this.fSyscallsViewer.setContentProvider((IContentProvider)new KernelContentProvider(TraceEventType.SYSCALL));
                    EnableKernelEventComposite.this.fSyscallsViewer.setLabelProvider((IBaseLabelProvider)new KernelLabelProvider());
                    EnableKernelEventComposite.this.fSyscallsViewer.addCheckStateListener((ICheckStateListener)new KernelCheckListener(EnableKernelEventComposite.this.fSyscallsViewer));
                    EnableKernelEventComposite.this.fSyscallsViewer.setInput((Object)EnableKernelEventComposite.this.fProviderGroup);
                    EnableKernelEventComposite.this.fSyscallsViewer.getTree().setLayoutData((Object)new GridData(1808));
                    return EnableKernelEventComposite.this.fSyscallsViewer;
                }

                protected void updateToolbar(boolean visible) {
                    super.updateToolbar(visible);
                    this.treeViewer.expandAll();
                }
            };
        }
    }

    private void createDynamicProbeGroup() {
        Group probeMainGroup = new Group((Composite)this, 32);
        probeMainGroup.setText(Messages.TraceControl_EnableEventsProbeGroupName);
        GridLayout layout = new GridLayout(2, false);
        probeMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        probeMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)probeMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fProbeActivateButton = new Button(buttonComposite, 16);
        this.fProbeActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fProbeActivateButton.setSelection(false);
        data = new GridData(768);
        this.fProbeActivateButton.setLayoutData((Object)data);
        this.fProbeActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.PROBE);
            }
        });
        Group probeGroup = new Group((Composite)probeMainGroup, 32);
        layout = new GridLayout(4, true);
        probeGroup.setLayout((Layout)layout);
        probeGroup.setLayoutData((Object)new GridData(768));
        Label probeNameLabel = new Label((Composite)probeGroup, 16384);
        probeNameLabel.setText(Messages.TraceControl_EnableEventsNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        probeNameLabel.setLayoutData((Object)data);
        this.fProbeEventNameText = new Text((Composite)probeGroup, 16384);
        this.fProbeEventNameText.setToolTipText(Messages.TraceControl_EnableEventsProbeEventNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fProbeEventNameText.setLayoutData((Object)data);
        Label probeLabel = new Label((Composite)probeGroup, 16384);
        probeLabel.setText(Messages.TraceControl_EnableEventsProbeNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        probeLabel.setLayoutData((Object)data);
        this.fProbeText = new Text((Composite)probeGroup, 16384);
        this.fProbeText.setToolTipText(Messages.TraceControl_EnableEventsProbeNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fProbeText.setLayoutData((Object)data);
    }

    private void createDynamicFunctionPropeGroup() {
        Group functionMainGroup = new Group((Composite)this, 32);
        functionMainGroup.setText(Messages.TraceControl_EnableEventsFucntionGroupName);
        GridLayout layout = new GridLayout(2, false);
        functionMainGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        functionMainGroup.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)functionMainGroup, 0);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(1, 0x1000000, false, true);
        buttonComposite.setLayoutData((Object)data);
        this.fFunctionActivateButton = new Button(buttonComposite, 16);
        this.fFunctionActivateButton.setText(Messages.TraceControl_EnableGroupSelectionName);
        this.fFunctionActivateButton.setSelection(false);
        data = new GridData(768);
        this.fFunctionActivateButton.setLayoutData((Object)data);
        this.fFunctionActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnableKernelEventComposite.this.setKernelEnablements(KernelGroupEnum.FUNCTION);
            }
        });
        Group functionGroup = new Group((Composite)functionMainGroup, 32);
        layout = new GridLayout(4, true);
        functionGroup.setLayout((Layout)layout);
        functionGroup.setLayoutData((Object)new GridData(768));
        Label functionNameLabel = new Label((Composite)functionGroup, 16384);
        functionNameLabel.setText(Messages.TraceControl_EnableEventsNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        functionNameLabel.setLayoutData((Object)data);
        this.fFunctionEventNameText = new Text((Composite)functionGroup, 16384);
        this.fFunctionEventNameText.setToolTipText(Messages.TraceControl_EnableEventsFunctionEventNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fFunctionEventNameText.setLayoutData((Object)data);
        Label functionLabel = new Label((Composite)functionGroup, 16384);
        functionLabel.setText(Messages.TraceControl_EnableEventsFunctionNameLabel);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        functionLabel.setLayoutData((Object)data);
        this.fFunctionText = new Text((Composite)functionGroup, 16384);
        this.fFunctionText.setToolTipText(Messages.TraceControl_EnableEventsProbeNameTooltip);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.fFunctionText.setLayoutData((Object)data);
    }

    private void setKernelEnablements(KernelGroupEnum group) {
        this.fAllActivateButton.setSelection(group == KernelGroupEnum.ALL);
        this.fTracepointsActivateButton.setSelection(group == KernelGroupEnum.TRACEPOINTS);
        this.fTracepointsViewer.getTree().setEnabled(group == KernelGroupEnum.TRACEPOINTS);
        this.fSpecificEventText.setEnabled(group == KernelGroupEnum.TRACEPOINTS);
        this.fSyscallsActivateButton.setSelection(group == KernelGroupEnum.SYSCALLS);
        if (this.fProviderGroup.isPerSyscallEventsSupported()) {
            this.fSyscallsViewer.getTree().setEnabled(group == KernelGroupEnum.SYSCALLS);
        }
        this.fProbeActivateButton.setSelection(group == KernelGroupEnum.PROBE);
        this.fProbeEventNameText.setEnabled(group == KernelGroupEnum.PROBE);
        this.fProbeText.setEnabled(group == KernelGroupEnum.PROBE);
        this.fFunctionActivateButton.setSelection(group == KernelGroupEnum.FUNCTION);
        this.fFunctionEventNameText.setEnabled(group == KernelGroupEnum.FUNCTION);
        this.fFunctionText.setEnabled(group == KernelGroupEnum.FUNCTION);
    }

    private void createFilterGroup() {
        if (this.fProviderGroup.isEventFilteringSupported(TraceDomainType.KERNEL)) {
            Group filterMainGroup = new Group((Composite)this, 32);
            filterMainGroup.setText(Messages.TraceControl_EnableEventsFilterGroupName);
            GridLayout layout = new GridLayout(3, false);
            filterMainGroup.setLayout((Layout)layout);
            GridData data = new GridData(768);
            filterMainGroup.setLayoutData((Object)data);
            this.fFilterText = new Text((Composite)filterMainGroup, 16384);
            this.fFilterText.setToolTipText(Messages.TraceControl_EnableEventsFilterTooltip);
            data = new GridData(768);
            this.fFilterText.setLayoutData((Object)data);
        }
    }

    public final class KernelCheckListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer fCheckBoxTreeViewer;

        public KernelCheckListener(CheckboxTreeViewer checkBoxTreeViewer) {
            this.fCheckBoxTreeViewer = checkBoxTreeViewer;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                if (event.getElement() instanceof KernelProviderComponent) {
                    this.fCheckBoxTreeViewer.setSubtreeChecked(event.getElement(), true);
                }
            } else if (event.getElement() instanceof KernelProviderComponent) {
                this.fCheckBoxTreeViewer.setSubtreeChecked(event.getElement(), false);
            } else {
                ITraceControlComponent component = (ITraceControlComponent)event.getElement();
                this.fCheckBoxTreeViewer.setChecked((Object)component.getParent(), false);
            }
        }
    }

    public static final class KernelContentProvider
    extends TraceControlContentProvider {
        private final TraceEventType fEventType;

        public KernelContentProvider(TraceEventType eventType) {
            this.fEventType = eventType;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TraceProviderGroup) {
                List<ITraceControlComponent> children = ((ITraceControlComponent)parentElement).getChildren(KernelProviderComponent.class);
                return children.toArray(new ITraceControlComponent[children.size()]);
            }
            if (parentElement instanceof ITraceControlComponent) {
                ArrayList<ITraceControlComponent> events = new ArrayList<ITraceControlComponent>();
                ITraceControlComponent[] iTraceControlComponentArray = ((ITraceControlComponent)parentElement).getChildren();
                int n = iTraceControlComponentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITraceControlComponent event = iTraceControlComponentArray[n2];
                    if (event instanceof BaseEventComponent && ((BaseEventComponent)event).getEventType() == this.fEventType) {
                        events.add(event);
                    }
                    ++n2;
                }
                return events.toArray(new ITraceControlComponent[events.size()]);
            }
            return new Object[0];
        }
    }

    private static enum KernelGroupEnum {
        ALL,
        TRACEPOINTS,
        SYSCALLS,
        PROBE,
        FUNCTION;

    }

    public static final class KernelLabelProvider
    extends TraceControlLabelProvider {
        @Override
        public Image getImage(Object element) {
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element != null && element instanceof KernelProviderComponent) {
                return Messages.TraceControl_EnableEventsTreeAllLabel;
            }
            return super.getText(element);
        }
    }
}

