/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.UnitPropagationListener;

public final class MaxWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    public static final int LIMIT_FOR_MAP = 100;
    private BigInteger watchCumul = BigInteger.ZERO;
    private final Map<Integer, BigInteger> litToCoeffs;

    private MaxWatchPb(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, BigInteger>(this.coefs.length);
            int i = 0;
            while (i < this.coefs.length) {
                this.litToCoeffs.put(this.lits[i], this.coefs[i]);
                ++i;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPb(ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree, BigInteger sumCoefs) {
        super(lits, coefs, degree, sumCoefs);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        if (coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, BigInteger>(this.coefs.length);
            int i = 0;
            while (i < this.coefs.length) {
                this.litToCoeffs.put(this.lits[i], this.coefs[i]);
                ++i;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.equals(BigInteger.ZERO));
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[i] ^ 1).push((Object)this);
                    this.voc.watch(this.lits[i] ^ 1, (Propagatable)this);
                }
            } else {
                this.voc.watch(this.lits[i] ^ 1, (Propagatable)this);
                this.watchCumul = this.watchCumul.add(this.coefs[i]);
            }
            ++i;
        }
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        int ind = 0;
        while (ind < this.coefs.length && this.watchCumul.subtract(this.coefs[ind]).compareTo(this.degree) < 0) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], (Constr)this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++ind;
        }
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        BigInteger coefP;
        this.voc.watch(p, (Propagatable)this);
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0) : this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt;
        if (this.litToCoeffs == null) {
            int indiceP = 0;
            while ((this.lits[indiceP] ^ 1) != p) {
                ++indiceP;
            }
            coefP = this.coefs[indiceP];
        } else {
            coefP = this.litToCoeffs.get(p ^ 1);
        }
        BigInteger newcumul = this.watchCumul.subtract(coefP);
        if (newcumul.compareTo(this.degree) < 0) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(p).push((Object)this);
        this.watchCumul = newcumul;
        int ind = 0;
        BigInteger limit = this.watchCumul.subtract(this.degree);
        while (ind < this.coefs.length && limit.compareTo(this.coefs[ind]) < 0) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], (Constr)this)) {
                assert (!this.isSatisfiable());
                return false;
            }
            ++ind;
        }
        assert (this.learnt || this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        return true;
    }

    public void remove(UnitPropagationListener upl) {
        int i = 0;
        while (i < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[i])) {
                this.voc.watches(this.lits[i] ^ 1).remove((Object)this);
            }
            ++i;
        }
    }

    public void undo(int p) {
        BigInteger coefP;
        if (this.litToCoeffs == null) {
            int indiceP = 0;
            while ((this.lits[indiceP] ^ 1) != p) {
                ++indiceP;
            }
            coefP = this.coefs[indiceP];
        } else {
            coefP = this.litToCoeffs.get(p ^ 1);
        }
        this.watchCumul = this.watchCumul.add(coefP);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener s, ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree, BigInteger sumCoefs) throws ContradictionException {
        MaxWatchPb outclause = new MaxWatchPb(voc, lits, coefs, degree, sumCoefs);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static WatchPb normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new MaxWatchPb(voc, mpb);
    }
}

