/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.preferences;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.remote.internal.core.preferences.Preferences;

public class PreferencesAdapter
implements IPreferenceStore {
    private final ListenerList fListeners = new ListenerList(1);
    private final PreferenceChangeListener fListener = new PreferenceChangeListener();
    private boolean fSilent;
    private boolean fNeedsSaving = false;

    public PreferencesAdapter() {
        Preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fListener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public boolean contains(String name) {
        return Preferences.contains((String)name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.fNeedsSaving = true;
        if (!this.fSilent) {
            Object[] listeners;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] objectArray = listeners = this.fListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPropertyChangeListener)listener).propertyChange(event);
                ++n2;
            }
        }
    }

    public boolean getBoolean(String name) {
        return Preferences.getBoolean((String)name);
    }

    public boolean getDefaultBoolean(String name) {
        return Preferences.getDefaultBoolean((String)name, (boolean)false);
    }

    public double getDefaultDouble(String name) {
        return Preferences.getDefaultDouble((String)name, (double)0.0);
    }

    public float getDefaultFloat(String name) {
        return Preferences.getDefaultFloat((String)name, (float)0.0f);
    }

    public int getDefaultInt(String name) {
        return Preferences.getDefaultInt((String)name, (int)0);
    }

    public long getDefaultLong(String name) {
        return Preferences.getDefaultLong((String)name, (long)0L);
    }

    public String getDefaultString(String name) {
        return Preferences.getDefaultString((String)name, (String)"");
    }

    public double getDouble(String name) {
        return Preferences.getDouble((String)name);
    }

    public float getFloat(String name) {
        return Preferences.getFloat((String)name);
    }

    public int getInt(String name) {
        return Preferences.getInt((String)name);
    }

    public long getLong(String name) {
        return Preferences.getLong((String)name);
    }

    public String getString(String name) {
        return Preferences.getString((String)name);
    }

    public boolean isDefault(String name) {
        return Preferences.isDefault((String)name);
    }

    public boolean needsSaving() {
        return this.fNeedsSaving;
    }

    public void putValue(String name, String value) {
        try {
            this.fSilent = true;
            Preferences.setString((String)name, (String)value);
        }
        finally {
            this.fSilent = false;
        }
    }

    public void setDefault(String name, double value) {
        Preferences.setDefaultDouble((String)name, (double)value);
    }

    public void setDefault(String name, float value) {
        Preferences.setDefaultFloat((String)name, (float)value);
    }

    public void setDefault(String name, int value) {
        Preferences.setDefaultInt((String)name, (int)value);
    }

    public void setDefault(String name, long value) {
        Preferences.setDefaultLong((String)name, (long)value);
    }

    public void setDefault(String name, String defaultObject) {
        Preferences.setDefaultString((String)name, (String)defaultObject);
    }

    public void setDefault(String name, boolean value) {
        Preferences.setDefaultBoolean((String)name, (boolean)value);
    }

    public void setToDefault(String name) {
        Preferences.setToDefault((String)name);
    }

    public void setValue(String name, double value) {
        Preferences.setDouble((String)name, (double)value);
    }

    public void setValue(String name, float value) {
        Preferences.setFloat((String)name, (float)value);
    }

    public void setValue(String name, int value) {
        Preferences.setInt((String)name, (int)value);
    }

    public void setValue(String name, long value) {
        Preferences.setLong((String)name, (long)value);
    }

    public void setValue(String name, String value) {
        Preferences.setString((String)name, (String)value);
    }

    public void setValue(String name, boolean value) {
        Preferences.setBoolean((String)name, (boolean)value);
    }

    private class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
        }
    }
}

