/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor;

import java.util.EnumSet;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartDurationDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartNumericalDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartStringDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartTimestampDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDescriptorVisitor;

public class DescriptorTypeVisitor
implements IDescriptorVisitor {
    private final EnumSet<DescriptorType> fType = EnumSet.noneOf(DescriptorType.class);

    @Override
    public void visit(DataChartStringDescriptor<?> desc) {
        this.fType.add(DescriptorType.STRING);
    }

    @Override
    public void visit(DataChartNumericalDescriptor<?, ? extends Number> desc) {
        this.fType.add(DescriptorType.NUMERICAL);
    }

    @Override
    public void visit(DataChartDurationDescriptor<?, ? extends Number> desc) {
        this.fType.add(DescriptorType.DURATION);
    }

    @Override
    public void visit(DataChartTimestampDescriptor<?> desc) {
        this.fType.add(DescriptorType.TIMESTAMP);
    }

    public boolean isEmpty() {
        return this.fType.isEmpty();
    }

    public boolean isMixed() {
        return this.fType.size() > 1;
    }

    public boolean isIndividualType(DescriptorType type) {
        if (this.isEmpty() || this.isMixed()) {
            return false;
        }
        DescriptorType actual = (DescriptorType)((Object)this.fType.iterator().next());
        if (type == DescriptorType.NUMERICAL) {
            return actual.isNumerical();
        }
        return this.fType.contains((Object)type);
    }

    public static enum DescriptorType {
        NUMERICAL,
        DURATION,
        TIMESTAMP,
        STRING;


        public boolean isNumerical() {
            return this == NUMERICAL || this == DURATION || this == TIMESTAMP;
        }
    }
}

