/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.AbstractCommentActionXMLDelegate;

public class AddBlockCommentActionXMLDelegate
extends AbstractCommentActionXMLDelegate {
    public void init(IAction action) {
        if (action != null) {
            action.setText(XMLUIMessages.AddBlockComment_label);
            action.setToolTipText(XMLUIMessages.AddBlockComment_tooltip);
            action.setDescription(XMLUIMessages.AddBlockComment_description);
        }
    }

    @Override
    void processAction(IDocument document, ITextSelection textSelection) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            try {
                IndexedRegion selectionStartIndexedRegion = model.getIndexedRegion(textSelection.getOffset());
                IndexedRegion selectionEndIndexedRegion = model.getIndexedRegion(textSelection.getOffset() + textSelection.getLength());
                if (selectionStartIndexedRegion == null) {
                    return;
                }
                if (selectionEndIndexedRegion == null && textSelection.getLength() > 0) {
                    selectionEndIndexedRegion = model.getIndexedRegion(textSelection.getOffset() + textSelection.getLength() - 1);
                }
                if (selectionEndIndexedRegion == null) {
                    return;
                }
                int openCommentOffset = selectionStartIndexedRegion.getStartOffset();
                int closeCommentOffset = selectionEndIndexedRegion.getEndOffset() + "<!--".length();
                if (textSelection.getLength() == 0 && selectionStartIndexedRegion instanceof CommentImpl) {
                    return;
                }
                model.beginRecording((Object)this, XMLUIMessages.AddBlockComment_tooltip);
                model.aboutToChangeModel();
                try {
                    try {
                        document.replace(openCommentOffset, 0, "<!--");
                        document.replace(closeCommentOffset, 0, "-->");
                        this.removeOpenCloseComments(document, openCommentOffset + "<!--".length(), closeCommentOffset - openCommentOffset - "-->".length());
                    }
                    catch (BadLocationException e) {
                        Logger.log(202, e.getMessage(), e);
                        model.changedModel();
                        model.endRecording((Object)this);
                    }
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                }
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }
}

