/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class SysEntryHandler
extends KernelEventHandler {
    public SysEntryHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        IKernelAnalysisEventLayout layout;
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        int currentThreadNode = KernelEventHandlerUtils.getCurrentThreadNode(cpu, ss);
        int quark = ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        String syscallName = event.getName();
        if (syscallName.startsWith((layout = this.getLayout()).eventCompatSyscallEntryPrefix())) {
            syscallName = syscallName.substring(layout.eventCompatSyscallEntryPrefix().length());
        } else if (syscallName.startsWith(layout.eventSyscallEntryPrefix())) {
            syscallName = syscallName.substring(layout.eventSyscallEntryPrefix().length());
        }
        ss.modifyAttribute(timestamp, (Object)syscallName, quark);
        ss.modifyAttribute(timestamp, ProcessStatus.RUN_SYTEMCALL.getStateValue().unboxValue(), currentThreadNode);
        int currentCPUNode = KernelEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        ss.modifyAttribute(timestamp, StateValues.CPU_STATUS_RUN_SYSCALL_VALUE.unboxValue(), currentCPUNode);
    }
}

