/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.utils.envvar.StorableEnvVar;

public class StorableEnvironment {
    public static final String ENVIRONMENT_ELEMENT_NAME = "environment";
    static final String ATTRIBUTE_APPEND = "append";
    static final String ATTRIBUTE_APPEND_CONTRIBUTED = "appendContributed";
    static final boolean DEFAULT_APPEND = true;
    Map<String, IEnvironmentVariable> fVariables;
    private boolean fIsDirty = false;
    boolean fIsChanged = false;
    final boolean fIsReadOnly;
    boolean fAppend = true;
    boolean fAppendContributedEnv = true;

    Map<String, IEnvironmentVariable> getMap() {
        if (this.fVariables == null) {
            this.fVariables = new HashMap<String, IEnvironmentVariable>();
        }
        return this.fVariables;
    }

    public StorableEnvironment(IEnvironmentVariable[] variables, boolean isReadOnly) {
        this.setVariales(variables);
        this.fIsReadOnly = isReadOnly;
    }

    public StorableEnvironment(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public StorableEnvironment(StorableEnvironment env, boolean isReadOnly) {
        if (env.fVariables != null) {
            this.fVariables = env.getAllVariablesMap();
        }
        this.fAppend = env.fAppend;
        this.fAppendContributedEnv = env.fAppendContributedEnv;
        this.fIsReadOnly = isReadOnly;
        this.fIsDirty = env.isDirty();
    }

    public StorableEnvironment(ICStorageElement element, boolean isReadOnly) {
        this.load(element);
        this.fIsReadOnly = isReadOnly;
    }

    private void load(ICStorageElement element) {
        ICStorageElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement node = children[i];
            if (node.getName().equals("variable")) {
                this.addVariable(this.getMap(), new StorableEnvVar(node));
            }
            ++i;
        }
        String append = element.getAttribute(ATTRIBUTE_APPEND);
        this.fAppend = append != null ? Boolean.valueOf(append) : true;
        append = element.getAttribute(ATTRIBUTE_APPEND_CONTRIBUTED);
        this.fAppendContributedEnv = append != null ? Boolean.valueOf(append) : true;
        this.fIsDirty = false;
        this.fIsChanged = false;
    }

    public void serialize(ICStorageElement element) {
        element.setAttribute(ATTRIBUTE_APPEND, String.valueOf(this.fAppend));
        element.setAttribute(ATTRIBUTE_APPEND_CONTRIBUTED, String.valueOf(this.fAppendContributedEnv));
        if (this.fVariables != null) {
            for (StorableEnvVar storableEnvVar : this.fVariables.values()) {
                ICStorageElement varEl = element.createChild("variable");
                storableEnvVar.serialize(varEl);
            }
        }
        this.fIsDirty = false;
    }

    void addVariable(Map<String, IEnvironmentVariable> map, IEnvironmentVariable var) {
        String name = this.getNameForMap(var.getName());
        if (name == null) {
            return;
        }
        map.put(name, var);
    }

    public IEnvironmentVariable createVariable(String name, String value, int op, String delimiter) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        IEnvironmentVariable var = this.checkVariable(name, value, op, delimiter);
        if (var == null) {
            var = new StorableEnvVar(name, value, op, delimiter);
            this.addVariable(this.getMap(), var);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return var;
    }

    public IEnvironmentVariable createVariable(String name) {
        return this.createVariable(name, null, 1, null);
    }

    public IEnvironmentVariable createVariable(String name, String value) {
        return this.createVariable(name, value, 1, null);
    }

    public IEnvironmentVariable createVariable(String name, String value, String delimiter) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        return this.createVariable(name, value, 1, delimiter);
    }

    public IEnvironmentVariable checkVariable(String name, String value, int op, String delimiter) {
        IEnvironmentVariable var = this.getVariable(name);
        if (var != null && this.checkStrings(var.getValue(), value) && var.getOperation() == op && this.checkStrings(var.getDelimiter(), delimiter)) {
            return var;
        }
        return null;
    }

    private boolean checkStrings(String str1, String str2) {
        if (str1 != null && str1.equals(str2)) {
            return true;
        }
        return str1 == str2;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    public boolean isChanged() {
        return this.fIsChanged;
    }

    public void setChanged(boolean changed) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsChanged = changed;
    }

    public IEnvironmentVariable getVariable(String name) {
        if ((name = this.getNameForMap(name)) == null) {
            return null;
        }
        return this.getMap().get(name);
    }

    public void setVariales(IEnvironmentVariable[] vars) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (vars == null || vars.length == 0) {
            this.deleteAll();
        } else {
            if (this.getMap().size() != 0) {
                for (IEnvironmentVariable v : this.getMap().values()) {
                    int i = 0;
                    while (i < vars.length) {
                        if (v.getName().equals(vars[i].getName())) break;
                        ++i;
                    }
                    if (i != vars.length) continue;
                    this.deleteVariable(v.getName());
                }
            }
            this.createVriables(vars);
        }
    }

    public void createVriables(IEnvironmentVariable[] vars) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        int i = 0;
        while (i < vars.length) {
            this.createVariable(vars[i].getName(), vars[i].getValue(), vars[i].getOperation(), vars[i].getDelimiter());
            ++i;
        }
    }

    Map<String, IEnvironmentVariable> getAllVariablesMap() {
        HashMap<String, IEnvironmentVariable> vars = new HashMap<String, IEnvironmentVariable>();
        vars.putAll(this.getMap());
        return vars;
    }

    public IEnvironmentVariable[] getVariables() {
        Map<String, IEnvironmentVariable> vars = this.getAllVariablesMap();
        return vars.values().toArray(new IEnvironmentVariable[vars.size()]);
    }

    String getNameForMap(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }

    public IEnvironmentVariable deleteVariable(String name) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if ((name = this.getNameForMap(name)) == null) {
            return null;
        }
        IEnvironmentVariable var = this.getMap().remove(name);
        if (var != null) {
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return var;
    }

    public boolean deleteAll() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        Map<String, IEnvironmentVariable> map = this.getMap();
        if (map.size() > 0) {
            this.fIsDirty = true;
            this.fIsChanged = true;
            map.clear();
            return true;
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    public boolean appendEnvironment() {
        return this.fAppend;
    }

    public void setAppendEnvironment(boolean append) {
        if (this.fAppend == append) {
            return;
        }
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fAppend = append;
        this.fIsDirty = true;
    }

    public boolean appendContributedEnvironment() {
        return this.fAppendContributedEnv;
    }

    public void setAppendContributedEnvironment(boolean append) {
        if (this.fAppendContributedEnv == append) {
            return;
        }
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fAppendContributedEnv = append;
        this.fIsDirty = true;
    }

    public void restoreDefaults() {
        this.deleteAll();
        this.fAppend = true;
        this.fAppendContributedEnv = true;
    }
}

