/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PathUtil {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public static boolean isWindowsFileSystem() {
        return WINDOWS;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            return workspace.getRoot();
        }
        return null;
    }

    public static IPath getCanonicalPath(IPath fullPath) {
        if (!fullPath.isAbsolute()) {
            return fullPath;
        }
        File file = fullPath.toFile();
        try {
            String canonPath = file.getCanonicalPath();
            Path canonicalPath = new Path(canonPath);
            if (fullPath.getDevice() == null) {
                canonicalPath = canonicalPath.setDevice(null);
            }
            return canonicalPath;
        }
        catch (IOException iOException) {
            return fullPath;
        }
    }

    public static IPath getCanonicalPathWindows(IPath fullPath) {
        if (!WINDOWS) {
            return fullPath;
        }
        return PathUtil.getCanonicalPath(fullPath);
    }

    public static IPath getWorkspaceRelativePath(IPath fullPath) {
        IPath workspaceLocation;
        IWorkspaceRoot workspaceRoot = PathUtil.getWorkspaceRoot();
        if (workspaceRoot != null && (workspaceLocation = workspaceRoot.getLocation()) != null && PathUtil.isPrefix(workspaceLocation, fullPath)) {
            int segments = PathUtil.matchingFirstSegments(fullPath, workspaceLocation);
            IPath relPath = fullPath.setDevice(null).removeFirstSegments(segments);
            return new Path("").addTrailingSeparator().append(relPath);
        }
        return fullPath;
    }

    public static IPath getProjectRelativePath(IPath fullPath, IProject project) {
        IPath projectPath = project.getFullPath();
        if (PathUtil.isPrefix(projectPath, fullPath)) {
            return fullPath.removeFirstSegments(projectPath.segmentCount());
        }
        projectPath = project.getLocation();
        if (PathUtil.isPrefix(projectPath, fullPath)) {
            return fullPath.removeFirstSegments(projectPath.segmentCount());
        }
        return PathUtil.getWorkspaceRelativePath(fullPath);
    }

    public static IPath getWorkspaceRelativePath(String fullPath) {
        return PathUtil.getWorkspaceRelativePath((IPath)new Path(fullPath));
    }

    public static IPath getRawLocation(IPath wsRelativePath) {
        IPath workspaceLocation;
        IWorkspaceRoot workspaceRoot = PathUtil.getWorkspaceRoot();
        if (workspaceRoot != null && wsRelativePath != null && (workspaceLocation = workspaceRoot.getLocation()) != null && !PathUtil.isPrefix(workspaceLocation, wsRelativePath)) {
            return workspaceLocation.append(wsRelativePath);
        }
        return wsRelativePath;
    }

    public static IPath makeRelativePath(IPath path, IPath relativeTo) {
        int segments = PathUtil.matchingFirstSegments(relativeTo, path);
        if (segments > 0) {
            IPath prefix = relativeTo.removeFirstSegments(segments);
            IPath suffix = path.removeFirstSegments(segments);
            Path relativePath = new Path("");
            int i = 0;
            while (i < prefix.segmentCount()) {
                relativePath = relativePath.append("../");
                ++i;
            }
            return relativePath.append(suffix);
        }
        return null;
    }

    public static IPath makeRelativePathToProjectIncludes(IPath fullPath, IProject project) {
        IScannerInfo info;
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (info = provider.getScannerInformation((IResource)project)) != null) {
            return PathUtil.makeRelativePathToIncludes(fullPath, info.getIncludePaths());
        }
        return null;
    }

    public static IPath makeRelativePathToIncludes(IPath fullPath, String[] includePaths) {
        IPath relativePath = null;
        int mostSegments = 0;
        int i = 0;
        while (i < includePaths.length) {
            int segments;
            Path includePath = new Path(includePaths[i]);
            if (PathUtil.isPrefix((IPath)includePath, fullPath) && (segments = includePath.segmentCount()) > mostSegments) {
                relativePath = fullPath.removeFirstSegments(segments).setDevice(null);
                mostSegments = segments;
            }
            ++i;
        }
        return relativePath;
    }

    public static IProject getEnclosingProject(IPath fullPath) {
        IWorkspaceRoot root = PathUtil.getWorkspaceRoot();
        if (root != null) {
            IPath path = PathUtil.getWorkspaceRelativePath(fullPath);
            while (path.segmentCount() > 0) {
                IResource res = root.findMember(path);
                if (res != null) {
                    return res.getProject();
                }
                path = path.removeLastSegments(1);
            }
        }
        return null;
    }

    public static IPath getValidEnclosingFolder(IPath fullPath) {
        IWorkspaceRoot root = PathUtil.getWorkspaceRoot();
        if (root != null) {
            IPath path = PathUtil.getWorkspaceRelativePath(fullPath);
            while (path.segmentCount() > 0) {
                IResource res = root.findMember(path);
                if (res != null && res.exists() && (res.getType() == 4 || res.getType() == 2)) {
                    return path;
                }
                path = path.removeLastSegments(1);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public boolean equal(IPath path1, IPath path2) {
        if (path1.isAbsolute() != path2.isAbsolute() || path1.isUNC() != path2.isUNC()) {
            return false;
        }
        i = path1.segmentCount();
        if (i == path2.segmentCount()) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (path1.segment(i).equals(path2.segment(i))) continue;
            return false;
lbl8:
            // 2 sources

            ** while (--i >= 0)
        }
lbl9:
        // 1 sources

        if (path1.getDevice() == null) {
            return path2.getDevice() == null;
        }
        return path1.getDevice().equalsIgnoreCase(path2.getDevice());
    }

    public static boolean equalPath(IPath path1, IPath path2) {
        if (path1.isAbsolute() != path2.isAbsolute() || path1.isUNC() != path2.isUNC()) {
            return false;
        }
        int i = path1.segmentCount();
        if (i != path2.segmentCount()) {
            return false;
        }
        boolean caseSensitive = !PathUtil.isWindowsFileSystem();
        while (--i >= 0) {
            if (!(caseSensitive ? !path1.segment(i).equals(path2.segment(i)) : !path1.segment(i).equalsIgnoreCase(path2.segment(i)))) continue;
            return false;
        }
        if (path1.getDevice() == null) {
            return path2.getDevice() == null;
        }
        return path1.getDevice().equalsIgnoreCase(path2.getDevice());
    }

    public static boolean isPrefix(IPath path1, IPath path2) {
        if (path1.getDevice() == null ? path2.getDevice() != null : !path1.getDevice().equalsIgnoreCase(path2.getDevice())) {
            return false;
        }
        if (path1.isEmpty() || path1.isRoot() && path2.isAbsolute()) {
            return true;
        }
        int len1 = path1.segmentCount();
        if (len1 > path2.segmentCount()) {
            return false;
        }
        boolean caseSensitive = !PathUtil.isWindowsFileSystem();
        int i = 0;
        while (i < len1) {
            if (caseSensitive ? !path1.segment(i).equals(path2.segment(i)) : !path1.segment(i).equalsIgnoreCase(path2.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int matchingFirstSegments(IPath path1, IPath path2) {
        Assert.isNotNull((Object)path1);
        Assert.isNotNull((Object)path2);
        int len1 = path1.segmentCount();
        int len2 = path2.segmentCount();
        int max = Math.min(len1, len2);
        int count = 0;
        boolean caseSensitive = !PathUtil.isWindowsFileSystem();
        int i = 0;
        while (i < max) {
            if (caseSensitive ? !path1.segment(i).equals(path2.segment(i)) : !path1.segment(i).equalsIgnoreCase(path2.segment(i))) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    public static IPath findProgramLocation(String prog, String pathsStr) {
        File file;
        Path dirLocation;
        String dir;
        int n;
        int n2;
        String[] stringArray;
        if (prog == null || prog.trim().isEmpty()) {
            return null;
        }
        if (pathsStr == null) {
            pathsStr = System.getenv("PATH");
        }
        if (pathsStr.trim().isEmpty()) {
            return null;
        }
        String locationStr = null;
        String[] dirs = pathsStr.split(File.pathSeparator);
        if (Platform.getOS().equals("win32")) {
            stringArray = dirs;
            n2 = dirs.length;
            n = 0;
            while (n < n2) {
                dir = stringArray[n];
                dirLocation = new Path(dir);
                file = null;
                file = dirLocation.append(String.valueOf(prog) + ".exe").toFile();
                if (file.isFile() && file.canRead()) {
                    locationStr = file.getAbsolutePath();
                    break;
                }
                file = dirLocation.append(String.valueOf(prog) + ".com").toFile();
                if (file.isFile() && file.canRead()) {
                    locationStr = file.getAbsolutePath();
                    break;
                }
                ++n;
            }
        }
        if (locationStr == null) {
            stringArray = dirs;
            n2 = dirs.length;
            n = 0;
            while (n < n2) {
                dir = stringArray[n];
                dirLocation = new Path(dir);
                file = null;
                file = dirLocation.append(prog).toFile();
                if (file.isFile() && file.canRead()) {
                    locationStr = file.getAbsolutePath();
                    break;
                }
                ++n;
            }
        }
        if (locationStr != null) {
            return new Path(locationStr);
        }
        return null;
    }

    public static IPath findProgramLocation(String prog) {
        return PathUtil.findProgramLocation(prog, null);
    }
}

