/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroExpansion;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroExpansionLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroReferenceName;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorName;
import org.eclipse.cdt.internal.core.parser.scanner.ImageLocationInfo;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxContainer;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;

class LocationCtxMacroExpansion
extends LocationCtx {
    private final LocationMap fLocationMap;
    private final int fLength;
    private final ImageLocationInfo[] fLocationInfos;
    private final ASTMacroReferenceName fExpansionName;

    public LocationCtxMacroExpansion(LocationMap map, LocationCtxContainer parent, int parentOffset, int parentEndOffset, int sequenceNumber, int length, ImageLocationInfo[] imageLocations, ASTMacroReferenceName expansionName) {
        super(parent, parentOffset, parentEndOffset, sequenceNumber);
        this.fLocationMap = map;
        this.fLength = length;
        this.fLocationInfos = imageLocations;
        this.fExpansionName = expansionName;
        if (!(expansionName.getParent() instanceof ASTMacroExpansion)) {
            throw new IllegalArgumentException(String.valueOf(expansionName.toString()) + " is not a macro expansion name");
        }
    }

    @Override
    public int getSequenceLength() {
        return this.fLength;
    }

    @Override
    public void collectLocations(int start, int length, ArrayList<IASTNodeLocation> locations) {
        int offset = start - this.fSequenceNumber;
        assert (offset >= 0 && length >= 0);
        if (offset + length <= this.fLength) {
            locations.add(new ASTMacroExpansionLocation(this, offset, length));
        } else {
            locations.add(new ASTMacroExpansionLocation(this, offset, this.fLength - offset));
        }
    }

    public ASTMacroExpansion getExpansion() {
        return (ASTMacroExpansion)this.fExpansionName.getParent();
    }

    public ASTMacroReferenceName getMacroReference() {
        return this.fExpansionName;
    }

    public IASTPreprocessorMacroDefinition getMacroDefinition() {
        return this.fLocationMap.getMacroDefinition((IMacroBinding)this.fExpansionName.getBinding());
    }

    @Override
    public LocationCtxMacroExpansion findEnclosingMacroExpansion(int sequenceNumber, int length) {
        return this;
    }

    public IASTImageLocation getImageLocation(int offset, int length) {
        if (length == 0) {
            return null;
        }
        int end = offset + length;
        int nextToCheck = offset;
        ImageLocationInfo firstInfo = null;
        ImageLocationInfo lastInfo = null;
        ImageLocationInfo[] imageLocationInfoArray = this.fLocationInfos;
        int n = this.fLocationInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ImageLocationInfo info = imageLocationInfoArray[n2];
            if (info.fTokenOffsetInExpansion == nextToCheck) {
                if (firstInfo == null || lastInfo == null) {
                    firstInfo = lastInfo = info;
                } else if (lastInfo.canConcatenate(info)) {
                    lastInfo = info;
                } else {
                    return null;
                }
                if (++nextToCheck == end) {
                    return firstInfo.createLocation(this.fLocationMap, lastInfo);
                }
            } else if (info.fTokenOffsetInExpansion > nextToCheck) {
                return null;
            }
            ++n2;
        }
        return null;
    }

    public ASTPreprocessorName[] getNestedMacroReferences() {
        return this.fLocationMap.getNestedMacroReferences((ASTMacroExpansion)this.fExpansionName.getParent());
    }

    public String toString() {
        return "Expansion of " + this.fExpansionName.toString();
    }
}

