/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

abstract class ASTPreprocessorNode
extends ASTNode {
    public ASTPreprocessorNode(IASTNode parent, ASTNodeProperty property, int startNumber, int endNumber) {
        this.setParent(parent);
        this.setPropertyInParent(property);
        this.setOffset(startNumber);
        this.setLength(endNumber - startNumber);
    }

    protected char[] getSource(int offset, int length) {
        IASTFileLocation loc;
        ILocationResolver lr;
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null && (loc = lr.getMappedFileLocation(offset, length)) != null) {
            return lr.getUnpreprocessedSignature(loc);
        }
        return CharArrayUtils.EMPTY;
    }

    void findNode(ASTNodeSpecification<?> nodeSpec) {
        nodeSpec.visit(this);
    }

    @Override
    public IASTNode copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTNode copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IToken getLeadingSyntax() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IToken getTrailingSyntax() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(this.getRawSignatureChars());
    }
}

