/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBreak;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecContinue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.core.runtime.CoreException;

public class ExecFor
implements ICPPExecution {
    private final ICPPExecution initializerExec;
    private final ICPPEvaluation conditionExprEval;
    private final ExecSimpleDeclaration conditionDeclExec;
    private final ICPPEvaluation iterationEval;
    private final ICPPExecution bodyExec;

    public ExecFor(ICPPExecution initializerExec, ICPPEvaluation conditionExprEval, ExecSimpleDeclaration conditionDeclExec, ICPPEvaluation iterationEval, ICPPExecution bodyExec) {
        this.initializerExec = initializerExec;
        this.conditionExprEval = conditionExprEval;
        this.conditionDeclExec = conditionDeclExec;
        this.iterationEval = iterationEval;
        this.bodyExec = bodyExec;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        this.evaluateInitializationStatement(record, context);
        while (this.conditionSatisfied(record, context)) {
            if (context.getStepsPerformed() >= 1024) {
                return ExecIncomplete.INSTANCE;
            }
            ICPPExecution result = EvalUtil.executeStatement(this.bodyExec, record, context);
            if (result instanceof ExecReturn) {
                return result;
            }
            if (result instanceof ExecBreak) break;
            if (result instanceof ExecContinue) {
                // empty if block
            }
            this.evaluateIterationExpression(record, context);
        }
        return null;
    }

    private void evaluateInitializationStatement(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.initializerExec != null) {
            EvalUtil.executeStatement(this.initializerExec, record, context);
        }
    }

    private boolean conditionSatisfied(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.conditionExprEval != null) {
            return EvalUtil.conditionExprSatisfied(this.conditionExprEval, record, context);
        }
        if (this.conditionDeclExec != null) {
            return EvalUtil.conditionDeclSatisfied(this.conditionDeclExec, record, context);
        }
        return true;
    }

    private void evaluateIterationExpression(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.iterationEval != null) {
            this.iterationEval.computeForFunctionCall(record, context);
        }
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPExecution newInitializerExec = this.initializerExec != null ? this.initializerExec.instantiate(context, maxDepth) : null;
        ICPPEvaluation newConditionExprEval = this.conditionExprEval != null ? this.conditionExprEval.instantiate(context, maxDepth) : null;
        ExecSimpleDeclaration newConditionDeclExec = this.conditionDeclExec != null ? (ExecSimpleDeclaration)this.conditionDeclExec.instantiate(context, maxDepth) : null;
        ICPPEvaluation newIterationEval = this.iterationEval != null ? this.iterationEval.instantiate(context, maxDepth) : null;
        ICPPExecution newBodyExec = this.bodyExec.instantiate(context, maxDepth);
        if (newInitializerExec == this.initializerExec && newConditionExprEval == this.conditionExprEval && newConditionDeclExec == this.conditionDeclExec && newIterationEval == this.iterationEval && newBodyExec == this.bodyExec) {
            return this;
        }
        return new ExecFor(newInitializerExec, newConditionExprEval, newConditionDeclExec, newIterationEval, newBodyExec);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)14);
        buffer.marshalExecution(this.initializerExec, includeValue);
        buffer.marshalEvaluation(this.conditionExprEval, includeValue);
        buffer.marshalExecution(this.conditionDeclExec, includeValue);
        buffer.marshalEvaluation(this.iterationEval, includeValue);
        buffer.marshalExecution(this.bodyExec, includeValue);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPExecution initializerExec = buffer.unmarshalExecution();
        ICPPEvaluation conditionExprEval = buffer.unmarshalEvaluation();
        ExecSimpleDeclaration conditionDeclExec = (ExecSimpleDeclaration)buffer.unmarshalExecution();
        ICPPEvaluation iterationEval = buffer.unmarshalEvaluation();
        ICPPExecution bodyExec = buffer.unmarshalExecution();
        return new ExecFor(initializerExec, conditionExprEval, conditionDeclExec, iterationEval, bodyExec);
    }
}

