/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.c.CArrayType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumeration;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.c.CExternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CField;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.c.CLabel;
import org.eclipse.cdt.internal.core.dom.parser.c.CParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.c.CStructure;
import org.eclipse.cdt.internal.core.dom.parser.c.CTypedef;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.PlatformObject;

public class CVisitor
extends ASTQueries {
    private static final CBasicType UNSIGNED_LONG_INT = new CBasicType(IBasicType.Kind.eInt, 9);
    public static final int ONLY_RETURN_TYPE = 1;
    protected static final ASTNodeProperty STRING_LOOKUP_PROPERTY = new ASTNodeProperty("CVisitor.STRING_LOOKUP_PROPERTY - STRING_LOOKUP");
    protected static final ASTNodeProperty STRING_LOOKUP_TAGS_PROPERTY = new ASTNodeProperty("CVisitor.STRING_LOOKUP_TAGS_PROPERTY - STRING_LOOKUP");
    private static final String SIZE_T = "size_t";
    private static final String PTRDIFF_T = "ptrdiff_t";
    public static final String EMPTY_STRING = "";
    protected static final int AT_BEGINNING = 1;
    protected static final int AT_NEXT = 2;

    protected static void createBinding(IASTName name) {
        IBinding binding = null;
        IASTNode parent = name.getParent();
        if (parent instanceof CASTIdExpression) {
            binding = CVisitor.resolveBinding(parent);
        } else if (parent instanceof ICASTTypedefNameSpecifier) {
            binding = CVisitor.resolveBinding(parent);
        } else if (parent instanceof IASTFieldReference) {
            binding = (IBinding)CVisitor.findBinding((IASTFieldReference)parent, false);
            if (binding == null) {
                binding = new ProblemBinding((IASTNode)name, 1, name.toCharArray());
            }
        } else if (parent instanceof IASTDeclarator) {
            binding = CVisitor.createBinding((IASTDeclarator)parent, name);
        } else if (parent instanceof ICASTCompositeTypeSpecifier) {
            binding = CVisitor.createBinding((ICASTCompositeTypeSpecifier)parent);
        } else if (parent instanceof ICASTElaboratedTypeSpecifier) {
            binding = CVisitor.createBinding((ICASTElaboratedTypeSpecifier)parent);
        } else if (parent instanceof IASTGotoStatement) {
            binding = CVisitor.resolveBinding((IASTGotoStatement)parent);
        } else if (parent instanceof IASTLabelStatement) {
            binding = CVisitor.createBinding((IASTLabelStatement)parent);
        } else if (parent instanceof ICASTEnumerationSpecifier) {
            binding = CVisitor.createBinding((ICASTEnumerationSpecifier)parent);
        } else if (parent instanceof IASTEnumerationSpecifier.IASTEnumerator) {
            binding = CVisitor.createBinding((IASTEnumerationSpecifier.IASTEnumerator)parent);
        } else if (parent instanceof ICASTFieldDesignator) {
            binding = CVisitor.resolveBinding(parent);
        }
        name.setBinding(binding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IBinding createBinding(ICASTEnumerationSpecifier enumeration) {
        IASTName name = enumeration.getName();
        IScope scope = CVisitor.getContainingScope(enumeration);
        IBinding binding = null;
        if (scope != null) {
            binding = scope.getBinding(name, false);
        }
        if (binding != null && !(binding instanceof IIndexBinding) && name.isActive()) {
            if (!(binding instanceof IEnumeration)) return new ProblemBinding((IASTNode)name, 2, name.toCharArray());
            if (!(binding instanceof CEnumeration)) return binding;
            ((CEnumeration)binding).addDefinition(name);
            return binding;
        } else {
            binding = new CEnumeration(name);
            ASTInternal.addName(scope, name);
        }
        return binding;
    }

    private static IBinding createBinding(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        CEnumerator binding = new CEnumerator(enumerator);
        try {
            ASTInternal.addName(binding.getScope(), enumerator.getName());
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return binding;
    }

    private static IBinding resolveBinding(IASTGotoStatement statement) {
        return CVisitor.resolveLabel(statement.getName());
    }

    private static IBinding createBinding(IASTLabelStatement statement) {
        IASTName name = statement.getName();
        CLabel binding = new CLabel(name);
        try {
            IScope scope = binding.getScope();
            if (scope instanceof ICFunctionScope) {
                ASTInternal.addName(binding.getScope(), name);
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return binding;
    }

    private static IBinding createBinding(ICASTElaboratedTypeSpecifier elabTypeSpec) {
        IASTNode parent = elabTypeSpec.getParent();
        IASTName name = elabTypeSpec.getName();
        if (parent instanceof IASTDeclaration) {
            IBinding binding = null;
            IScope insertIntoScope = null;
            if (parent instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)parent).getDeclarators().length == 0) {
                IScope scope = CVisitor.getContainingScope(elabTypeSpec);
                try {
                    while (scope instanceof ICCompositeTypeScope) {
                        scope = scope.getParent();
                    }
                    binding = scope.getBinding(name, false);
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
                if (binding != null && name.isActive()) {
                    if (binding instanceof CEnumeration) {
                        ((CEnumeration)binding).addDeclaration(name);
                    } else if (binding instanceof CStructure) {
                        ((CStructure)binding).addDeclaration(name);
                    }
                }
            } else {
                binding = CVisitor.resolveBinding(elabTypeSpec);
                if (binding == null && (binding = (insertIntoScope = elabTypeSpec.getTranslationUnit().getScope()).getBinding(name, false)) != null && name.isActive()) {
                    if (binding instanceof CEnumeration) {
                        ((CEnumeration)binding).addDeclaration(name);
                    } else if (binding instanceof CStructure) {
                        ((CStructure)binding).addDeclaration(name);
                    }
                }
            }
            if (binding == null) {
                binding = elabTypeSpec.getKind() == 0 ? new CEnumeration(name) : new CStructure(name);
                if (insertIntoScope != null) {
                    ASTInternal.addName(insertIntoScope, name);
                }
            }
            return binding;
        }
        if (parent instanceof IASTTypeId || parent instanceof IASTParameterDeclaration) {
            return CVisitor.resolveBinding(elabTypeSpec);
        }
        return null;
    }

    private static Object findBinding(IASTFieldReference fieldReference, boolean prefix) {
        IASTExpression fieldOwner = fieldReference.getFieldOwner();
        if (fieldOwner == null) {
            return null;
        }
        boolean isPointerDeref = fieldReference.isPointerDereference();
        IType type = fieldOwner.getExpressionType();
        while (type != null && type instanceof ITypeContainer) {
            if (type instanceof IPointerType) {
                if (isPointerDeref) {
                    isPointerDeref = false;
                } else {
                    return null;
                }
            }
            type = ((ITypeContainer)type).getType();
        }
        if (type != null && type instanceof ICompositeType) {
            ICompositeType ct = (ICompositeType)type;
            if (ct instanceof IIndexBinding) {
                ct = ((CASTTranslationUnit)fieldReference.getTranslationUnit()).mapToASTType(ct);
            }
            if (prefix) {
                char[] p = fieldReference.getFieldName().toCharArray();
                return CVisitor.findFieldsByPrefix(ct, p);
            }
            return ct.findField(fieldReference.getFieldName().toString());
        }
        return null;
    }

    public static IBinding[] findFieldsByPrefix(ICompositeType ct, char[] p) {
        IField[] fields;
        IBinding[] result = null;
        IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(p);
        IField[] iFieldArray = fields = ct.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (matcher.match(field.getNameCharArray())) {
                result = ArrayUtil.append(IBinding.class, result, field);
            }
            ++n2;
        }
        return ArrayUtil.trim(IBinding.class, result);
    }

    static IType getPtrDiffType(IASTBinaryExpression expr) {
        IBinding[] bs;
        IScope scope = CVisitor.getContainingScope(expr);
        IBinding[] iBindingArray = bs = scope.find(PTRDIFF_T, expr.getTranslationUnit());
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding b = iBindingArray[n2];
            if (b instanceof IType && (!(b instanceof ICInternalBinding) || CVisitor.declaredBefore(((ICInternalBinding)((Object)b)).getPhysicalNode(), expr))) {
                return (IType)((Object)b);
            }
            ++n2;
        }
        return new CBasicType(IBasicType.Kind.eInt, 1, expr);
    }

    static IType get_SIZE_T(IASTExpression expr) {
        IASTTranslationUnit tu = expr.getTranslationUnit();
        if (tu != null) {
            IBinding[] bs;
            IBinding[] iBindingArray = bs = tu.getScope().find(SIZE_T, expr.getTranslationUnit());
            int n = bs.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding b = iBindingArray[n2];
                if (b instanceof IType && (!(b instanceof ICInternalBinding) || CVisitor.declaredBefore(((ICInternalBinding)((Object)b)).getPhysicalNode(), expr))) {
                    return (IType)((Object)b);
                }
                ++n2;
            }
        }
        return UNSIGNED_LONG_INT;
    }

    static IType unwrapTypedefs(IType type) {
        while (type instanceof ITypedef) {
            type = ((ITypedef)type).getType();
        }
        return type;
    }

    static IType unwrapCV(IType type) {
        while (type instanceof IQualifierType) {
            type = ((IQualifierType)type).getType();
        }
        if (type instanceof IPointerType) {
            type = new CPointerType(((IPointerType)type).getType(), 0);
        }
        return type;
    }

    private static IBinding createBinding(IASTDeclarator declarator, IASTName name) {
        IBinding binding = null;
        if (declarator instanceof ICASTKnRFunctionDeclarator) {
            if (CharArrayUtils.equals(declarator.getName().toCharArray(), name.toCharArray())) {
                IScope scope = CVisitor.getContainingScope(declarator);
                binding = scope.getBinding(name, false);
                if (binding != null && !(binding instanceof IIndexBinding) && name.isActive()) {
                    if (binding instanceof ICInternalFunction) {
                        ((ICInternalFunction)((Object)binding)).addDeclarator(declarator);
                    } else {
                        binding = new ProblemBinding((IASTNode)name, 2, name.toCharArray());
                    }
                } else {
                    binding = CVisitor.createBinding(declarator);
                }
            } else {
                IBinding f = declarator.getName().resolveBinding();
                if (f instanceof CFunction) {
                    binding = ((CFunction)f).resolveParameter(name);
                }
            }
        } else {
            binding = CVisitor.createBinding(declarator);
        }
        return binding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IBinding createBinding(IASTDeclarator declarator) {
        IASTNode parent = ASTQueries.findOutermostDeclarator(declarator).getParent();
        declarator = ASTQueries.findInnermostDeclarator(declarator);
        IASTDeclarator typeRelevant = ASTQueries.findTypeRelevantDeclarator(declarator);
        IScope scope = CVisitor.getContainingScope(parent);
        ASTNodeProperty prop = parent.getPropertyInParent();
        if (prop == IASTDeclarationStatement.DECLARATION && (prop = parent.getParent().getPropertyInParent()) != IASTCompoundStatement.NESTED_STATEMENT) {
            scope = null;
        }
        IASTName name = declarator.getName();
        IBinding binding = scope != null ? scope.getBinding(name, false) : null;
        boolean isFunction = false;
        if (parent instanceof IASTParameterDeclaration || parent.getPropertyInParent() == ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER) {
            IASTDeclarator fdtor = (IASTDeclarator)parent.getParent();
            if (ASTQueries.findTypeRelevantDeclarator(fdtor) == fdtor) {
                IASTName n = ASTQueries.findInnermostDeclarator(fdtor).getName();
                IBinding temp = n.resolveBinding();
                if (temp != null && temp instanceof CFunction) {
                    return ((CFunction)temp).resolveParameter(name);
                }
                if (!(temp instanceof IFunction)) return binding;
                return new CParameter(name);
            }
        } else if (parent instanceof IASTFunctionDefinition) {
            isFunction = true;
        } else if (parent instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)parent;
            if (simpleDecl.getDeclSpecifier().getStorageClass() == 1) {
                binding = new CTypedef(name);
            } else {
                isFunction = typeRelevant instanceof IASTFunctionDeclarator;
                if (!isFunction) {
                    IType t1 = CVisitor.createType(declarator);
                    IType t2 = null;
                    if (CVisitor.unwrapTypedefs(t1) instanceof IFunctionType) {
                        isFunction = true;
                    } else if (binding != null && !(binding instanceof IIndexBinding) && name.isActive()) {
                        if (binding instanceof IParameter) {
                            return new ProblemBinding((IASTNode)name, 12, name.toCharArray());
                        }
                        if (binding instanceof IVariable) {
                            t2 = ((IVariable)binding).getType();
                            if (t1 == null) return new ProblemBinding((IASTNode)name, 12, name.toCharArray());
                            if (t2 == null) return new ProblemBinding((IASTNode)name, 12, name.toCharArray());
                            if (!CVisitor.areArraysOfTheSameElementType(t1, t2)) {
                                if (!t1.isSameType(t2)) return new ProblemBinding((IASTNode)name, 12, name.toCharArray());
                            }
                            if (binding instanceof CVariable) {
                                ((CVariable)binding).addDeclaration(name);
                            }
                        }
                    } else {
                        binding = simpleDecl.getParent() instanceof ICASTCompositeTypeSpecifier ? new CField(name) : new CVariable(name);
                    }
                }
            }
        }
        if (!isFunction) return binding;
        if (binding == null) return new CFunction(typeRelevant);
        if (binding instanceof IIndexBinding) return new CFunction(typeRelevant);
        if (!name.isActive()) return new CFunction(typeRelevant);
        if (!(binding instanceof IFunction)) return new ProblemBinding((IASTNode)name, 2, name.toCharArray());
        IFunction function = (IFunction)binding;
        if (!(function instanceof CFunction)) return function;
        ((CFunction)function).addDeclarator(typeRelevant);
        return function;
    }

    private static IBinding createBinding(ICASTCompositeTypeSpecifier compositeTypeSpec) {
        IScope scope = null;
        IBinding binding = null;
        IASTName name = compositeTypeSpec.getName();
        try {
            scope = CVisitor.getContainingScope(compositeTypeSpec);
            while (scope instanceof ICCompositeTypeScope) {
                scope = scope.getParent();
            }
            if (scope != null && (binding = scope.getBinding(name, false)) != null && !(binding instanceof IIndexBinding) && name.isActive()) {
                if (binding instanceof CStructure) {
                    ((CStructure)binding).addDefinition(compositeTypeSpec);
                }
                return binding;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return new CStructure(name);
    }

    protected static IBinding resolveBinding(IASTNode node) {
        IASTNode blockItem;
        if (node instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition functionDef = (IASTFunctionDefinition)node;
            IASTFunctionDeclarator functionDeclartor = functionDef.getDeclarator();
            IASTName name = CVisitor.findInnermostDeclarator(functionDeclartor).getName();
            IScope scope = CVisitor.getContainingScope(node);
            return CVisitor.lookup(scope, name);
        }
        if (node instanceof IASTIdExpression) {
            if (CVisitor.isLabelReference(node)) {
                return CVisitor.resolveLabel(((IASTIdExpression)node).getName());
            }
            IScope scope = CVisitor.getContainingScope(node);
            IBinding binding = CVisitor.lookup(scope, ((IASTIdExpression)node).getName());
            if (binding instanceof IType && !(binding instanceof IProblemBinding)) {
                return new ProblemBinding(node, 5, binding.getNameCharArray(), new IBinding[]{binding});
            }
            return binding;
        }
        if (node instanceof ICASTTypedefNameSpecifier) {
            IASTName name;
            IScope scope = CVisitor.getContainingScope(node);
            IBinding binding = CVisitor.lookup(scope, name = ((ICASTTypedefNameSpecifier)node).getName());
            if (binding == null) {
                return new ProblemBinding(node, 1, name.toCharArray());
            }
            if (binding instanceof IType) {
                return binding;
            }
            return new ProblemBinding(node, 5, binding.getNameCharArray(), new IBinding[]{binding});
        }
        if (node instanceof ICASTElaboratedTypeSpecifier) {
            IScope scope = CVisitor.getContainingScope(node);
            return CVisitor.lookup(scope, ((ICASTElaboratedTypeSpecifier)node).getName());
        }
        if (node instanceof ICASTCompositeTypeSpecifier) {
            IScope scope = CVisitor.getContainingScope(node);
            return CVisitor.lookup(scope, ((ICASTCompositeTypeSpecifier)node).getName());
        }
        if (node instanceof IASTTypeId) {
            IASTTypeId typeId = (IASTTypeId)node;
            IASTDeclSpecifier declSpec = typeId.getDeclSpecifier();
            IASTName name = null;
            if (declSpec instanceof ICASTElaboratedTypeSpecifier) {
                name = ((ICASTElaboratedTypeSpecifier)declSpec).getName();
            } else if (declSpec instanceof ICASTCompositeTypeSpecifier) {
                name = ((ICASTCompositeTypeSpecifier)declSpec).getName();
            } else if (declSpec instanceof ICASTTypedefNameSpecifier) {
                name = ((ICASTTypedefNameSpecifier)declSpec).getName();
            }
            if (name != null) {
                IBinding binding = name.resolveBinding();
                if (binding instanceof IType) {
                    return binding;
                }
                if (binding != null) {
                    return new ProblemBinding(node, 5, binding.getNameCharArray(), new IBinding[]{binding});
                }
                return null;
            }
        } else if (node instanceof ICASTFieldDesignator && ((blockItem = CVisitor.getContainingBlockItem(node)) instanceof IASTSimpleDeclaration || blockItem instanceof IASTDeclarationStatement && ((IASTDeclarationStatement)blockItem).getDeclaration() instanceof IASTSimpleDeclaration)) {
            IASTSimpleDeclaration simpleDecl = null;
            if (blockItem instanceof IASTDeclarationStatement && ((IASTDeclarationStatement)blockItem).getDeclaration() instanceof IASTSimpleDeclaration) {
                simpleDecl = (IASTSimpleDeclaration)((IASTDeclarationStatement)blockItem).getDeclaration();
            } else if (blockItem instanceof IASTSimpleDeclaration) {
                simpleDecl = (IASTSimpleDeclaration)blockItem;
            }
            if (simpleDecl != null) {
                IBinding struct = null;
                if (simpleDecl.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                    struct = ((IASTNamedTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
                } else if (simpleDecl.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
                    struct = ((IASTElaboratedTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
                } else if (simpleDecl.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                    struct = ((IASTCompositeTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
                }
                if (struct instanceof ICompositeType) {
                    return ((ICompositeType)struct).findField(((ICASTFieldDesignator)node).getName().toString());
                }
                if (struct instanceof ITypeContainer) {
                    IType type = ((ITypeContainer)((Object)struct)).getType();
                    while (type instanceof ITypeContainer && !(type instanceof CStructure)) {
                        type = ((ITypeContainer)type).getType();
                    }
                    if (type instanceof CStructure) {
                        return ((CStructure)type).findField(((ICASTFieldDesignator)node).getName().toString());
                    }
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IScope getContainingScope(IASTNode node) {
        if (node != null) ** GOTO lbl45
        return null;
lbl-1000:
        // 1 sources

        {
            if (node instanceof IASTDeclaration) {
                parent = node.getParent();
                if (parent instanceof IASTTranslationUnit) {
                    return ((IASTTranslationUnit)parent).getScope();
                }
                if (parent instanceof IASTDeclarationStatement) {
                    return CVisitor.getContainingScope((IASTStatement)parent);
                }
                if (parent instanceof IASTForStatement) {
                    return ((IASTForStatement)parent).getScope();
                }
                if (parent instanceof IASTCompositeTypeSpecifier) {
                    return ((IASTCompositeTypeSpecifier)parent).getScope();
                }
                if (parent instanceof ICASTKnRFunctionDeclarator && (parent = ((IASTDeclarator)parent).getParent()) instanceof IASTFunctionDefinition) {
                    return ((IASTCompoundStatement)((IASTFunctionDefinition)parent).getBody()).getScope();
                }
            } else {
                if (node instanceof IASTStatement) {
                    return CVisitor.getContainingScope((IASTStatement)node);
                }
                if (node instanceof IASTExpression) {
                    parent = node.getParent();
                    if (parent instanceof IASTForStatement) {
                        return ((IASTForStatement)parent).getScope();
                    }
                } else if (node instanceof IASTParameterDeclaration) {
                    parent = node.getParent();
                    if (parent instanceof IASTStandardFunctionDeclarator && ASTQueries.findTypeRelevantDeclarator(dtor = (IASTStandardFunctionDeclarator)parent) == dtor) {
                        parent = ASTQueries.findOutermostDeclarator(dtor);
                        prop = parent.getPropertyInParent();
                        if (prop == IASTSimpleDeclaration.DECLARATOR) {
                            return dtor.getFunctionScope();
                        }
                        if (prop == IASTFunctionDefinition.DECLARATOR) {
                            return ((IASTCompoundStatement)((IASTFunctionDefinition)parent.getParent()).getBody()).getScope();
                        }
                    }
                } else if (node instanceof IASTEnumerationSpecifier.IASTEnumerator) {
                    node = node.getParent();
                } else if (node instanceof IASTName && (prop = node.getPropertyInParent()) == IASTLabelStatement.NAME) {
                    for (scope = CVisitor.getContainingScope(node.getParent()); scope != null && !(scope instanceof ICFunctionScope); scope = scope.getParent()) {
                        try {
                            continue;
                        }
                        catch (DOMException e) {
                            scope = e.getProblem();
                            break;
                        }
                    }
                    return scope;
                }
            }
            node = node.getParent();
lbl45:
            // 2 sources

            ** while (node != null)
        }
lbl46:
        // 1 sources

        return null;
    }

    public static IScope getContainingScope(IASTStatement statement) {
        IASTNode parent = statement.getParent();
        IScope scope = null;
        if (parent instanceof IASTCompoundStatement) {
            IASTCompoundStatement compound = (IASTCompoundStatement)parent;
            scope = compound.getScope();
        } else if (parent instanceof IASTStatement) {
            scope = parent instanceof IASTForStatement ? ((IASTForStatement)parent).getScope() : CVisitor.getContainingScope((IASTStatement)parent);
        } else {
            if (parent instanceof IASTFunctionDefinition) {
                return ((IASTFunctionDefinition)parent).getScope();
            }
            return CVisitor.getContainingScope(parent);
        }
        if (statement instanceof IASTGotoStatement) {
            while (scope != null && !(scope instanceof ICFunctionScope)) {
                try {
                    scope = scope.getParent();
                }
                catch (DOMException e) {
                    scope = e.getProblem();
                    break;
                }
            }
        }
        return scope;
    }

    private static IASTNode getContainingBlockItem(IASTNode node) {
        IASTNode parent = node.getParent();
        while (parent != null) {
            if (parent instanceof IASTDeclaration) {
                IASTNode p = parent.getParent();
                if (p instanceof IASTDeclarationStatement) {
                    return p;
                }
                return parent;
            }
            if (parent instanceof IASTCompoundStatement || parent instanceof IASTTranslationUnit || parent instanceof IASTForStatement || parent instanceof IASTFunctionDeclarator) {
                return node;
            }
            node = parent;
            parent = parent.getParent();
        }
        return null;
    }

    protected static IBinding lookup(IScope scope, IASTName name) {
        IIndexFileSet fs;
        if (scope == null) {
            return null;
        }
        IIndexFileSet fileSet = IIndexFileSet.EMPTY;
        IASTTranslationUnit tu = name.getTranslationUnit();
        if (tu == null && scope instanceof IASTInternalScope) {
            tu = ((IASTInternalScope)scope).getPhysicalNode().getTranslationUnit();
        }
        if (tu != null && (fs = (IIndexFileSet)tu.getAdapter(IIndexFileSet.class)) != null) {
            fileSet = fs;
        }
        while (scope != null) {
            IBinding binding;
            if (!(scope instanceof ICCompositeTypeScope) && (binding = scope.getBinding(name, true, fileSet)) != null) {
                return binding;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException e) {
                scope = null;
            }
        }
        return CVisitor.externalBinding(tu, name);
    }

    protected static IBinding[] lookupPrefix(IScope scope, IASTName name) throws DOMException {
        if (scope == null) {
            return null;
        }
        IBinding[] result = null;
        CharArraySet handled = new CharArraySet(1);
        while (scope != null) {
            if (!(scope instanceof ICCompositeTypeScope)) {
                char[] n;
                IBinding b;
                IBinding[] bindings;
                IBinding[] iBindingArray = bindings = scope.getBindings(new IScope.ScopeLookupData(name, true, true));
                int n2 = bindings.length;
                int n3 = 0;
                while (n3 < n2) {
                    b = iBindingArray[n3];
                    n = b.getNameCharArray();
                    if (!handled.containsKey(n)) {
                        result = ArrayUtil.append(IBinding.class, result, b);
                    }
                    ++n3;
                }
                iBindingArray = bindings;
                n2 = bindings.length;
                n3 = 0;
                while (n3 < n2) {
                    b = iBindingArray[n3];
                    n = b.getNameCharArray();
                    handled.put(n);
                    ++n3;
                }
            }
            scope = scope.getParent();
        }
        return ArrayUtil.trim(IBinding.class, result);
    }

    private static IBinding externalBinding(IASTTranslationUnit tu, IASTName name) {
        IASTNode parent = name.getParent();
        PlatformObject external = null;
        if (parent instanceof IASTIdExpression) {
            if (parent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                external = new CExternalFunction(tu, name);
                ASTInternal.addName(tu.getScope(), name);
            } else {
                external = new ProblemBinding((IASTNode)name, 1, name.toCharArray());
            }
        }
        return external;
    }

    protected static IASTDeclarator findDefinition(IASTDeclarator declarator, int beginAtLoc) {
        return (IASTDeclarator)CVisitor.findDefinition(declarator, declarator.getName().toCharArray(), beginAtLoc);
    }

    protected static IASTFunctionDeclarator findDefinition(IASTFunctionDeclarator declarator) {
        return (IASTFunctionDeclarator)CVisitor.findDefinition(declarator, declarator.getName().toCharArray(), 2);
    }

    protected static IASTDeclSpecifier findDefinition(ICASTElaboratedTypeSpecifier declSpec) {
        return (IASTDeclSpecifier)CVisitor.findDefinition(declSpec, declSpec.getName().toCharArray(), 1);
    }

    private static IASTNode findDefinition(IASTNode decl, char[] declName, int beginAtLoc) {
        boolean begun;
        IASTNode blockItem = CVisitor.getContainingBlockItem(decl);
        IASTNode parent = blockItem.getParent();
        if (parent instanceof IASTCompositeTypeSpecifier && (parent = parent.getParent()) != null) {
            parent = parent.getParent();
        }
        IASTNode[] list = null;
        if (parent instanceof IASTCompoundStatement) {
            IASTCompoundStatement compound = (IASTCompoundStatement)parent;
            list = compound.getStatements();
        } else if (parent instanceof IASTTranslationUnit) {
            IASTTranslationUnit translation = (IASTTranslationUnit)parent;
            list = translation.getDeclarations();
        }
        boolean bl = begun = beginAtLoc == 1;
        if (list != null) {
            IASTNode[] iASTNodeArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode node = iASTNodeArray[n2];
                if (node == blockItem) {
                    begun = true;
                } else if (begun) {
                    IASTSimpleDeclaration simpleDecl;
                    if (node instanceof IASTDeclarationStatement) {
                        node = ((IASTDeclarationStatement)node).getDeclaration();
                    }
                    if (node instanceof IASTFunctionDefinition && decl instanceof IASTFunctionDeclarator) {
                        IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)node).getDeclarator();
                        IASTName name = ASTQueries.findInnermostDeclarator(dtor).getName();
                        if (name.toString().equals(declName)) {
                            return dtor;
                        }
                    } else if (node instanceof IASTSimpleDeclaration && decl instanceof ICASTElaboratedTypeSpecifier) {
                        simpleDecl = (IASTSimpleDeclaration)node;
                        IASTDeclSpecifier declSpec = simpleDecl.getDeclSpecifier();
                        IASTName name = null;
                        if (declSpec instanceof ICASTCompositeTypeSpecifier) {
                            name = ((ICASTCompositeTypeSpecifier)declSpec).getName();
                        } else if (declSpec instanceof ICASTEnumerationSpecifier) {
                            name = ((ICASTEnumerationSpecifier)declSpec).getName();
                        }
                        if (name != null && CharArrayUtils.equals(name.toCharArray(), declName)) {
                            return declSpec;
                        }
                    } else if (node instanceof IASTSimpleDeclaration && decl instanceof IASTDeclarator) {
                        simpleDecl = (IASTSimpleDeclaration)node;
                        IASTDeclarator[] dtors = simpleDecl.getDeclarators();
                        int j = 0;
                        while (dtors != null && j < dtors.length) {
                            if (CharArrayUtils.equals(dtors[j].getName().toCharArray(), declName)) {
                                return dtors[j];
                            }
                            ++j;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static IType createType(IASTDeclarator declarator) {
        return CVisitor.createType(declarator, 0);
    }

    public static IType createType(IASTDeclarator declarator, int flags) {
        IASTDeclSpecifier declSpec = null;
        IASTNode node = declarator.getParent();
        while (node instanceof IASTDeclarator) {
            declarator = (IASTDeclarator)node;
            node = node.getParent();
        }
        if (node instanceof IASTSimpleDeclaration) {
            declSpec = ((IASTSimpleDeclaration)node).getDeclSpecifier();
        } else if (node instanceof IASTParameterDeclaration) {
            declSpec = ((IASTParameterDeclaration)node).getDeclSpecifier();
        } else if (node instanceof IASTFunctionDefinition) {
            declSpec = ((IASTFunctionDefinition)node).getDeclSpecifier();
        } else if (node instanceof IASTTypeId) {
            declSpec = ((IASTTypeId)node).getDeclSpecifier();
        }
        boolean isParameter = node instanceof IASTParameterDeclaration || node.getParent() instanceof ICASTKnRFunctionDeclarator;
        IType type = CVisitor.createType((ICASTDeclSpecifier)declSpec);
        type = CVisitor.createType(type, declarator, flags);
        if (isParameter) {
            IType paramType = type;
            while (paramType instanceof ITypedef) {
                paramType = ((ITypedef)paramType).getType();
            }
            if (paramType instanceof IArrayType) {
                IArrayType at = (IArrayType)paramType;
                int q = 0;
                if (at instanceof ICArrayType) {
                    ICArrayType cat = (ICArrayType)at;
                    if (cat.isConst()) {
                        q |= 1;
                    }
                    if (cat.isVolatile()) {
                        q |= 4;
                    }
                    if (cat.isRestrict()) {
                        q |= 2;
                    }
                }
                type = new CPointerType(at.getType(), q);
            } else if (paramType instanceof IFunctionType) {
                type = new CPointerType(paramType, 0);
            }
        }
        return type;
    }

    private static IType createType(IASTTypeId typeId) {
        return CVisitor.createType(typeId.getAbstractDeclarator());
    }

    public static IType createType(IType baseType, IASTDeclarator declarator, int flags) {
        if ((flags & 1) == 0 && declarator instanceof IASTFunctionDeclarator) {
            return CVisitor.createType(baseType, (IASTFunctionDeclarator)declarator);
        }
        IType type = baseType;
        type = CVisitor.applyAttributes(type, declarator);
        type = CVisitor.setupPointerChain(declarator.getPointerOperators(), type);
        type = CVisitor.setupArrayChain(declarator, type);
        IASTDeclarator nested = declarator.getNestedDeclarator();
        if (nested != null) {
            return CVisitor.createType(type, nested, flags);
        }
        return type;
    }

    private static IType applyAttributes(IType type, IASTDeclarator declarator) {
        IBasicType basicType;
        if (type instanceof IBasicType && (basicType = (IBasicType)type).getKind() == IBasicType.Kind.eInt) {
            IASTAttribute[] attributes;
            IASTAttribute[] iASTAttributeArray = attributes = declarator.getAttributes();
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                IASTAttribute attribute = iASTAttributeArray[n2];
                char[] name = attribute.getName();
                if (CharArrayUtils.equals(name, "__mode__") || CharArrayUtils.equals(name, "mode")) {
                    char[] mode = AttributeUtil.getSimpleArgument(attribute);
                    if (CharArrayUtils.equals(mode, "__QI__") || CharArrayUtils.equals(mode, "QI")) {
                        type = new CBasicType(IBasicType.Kind.eChar, basicType.isUnsigned() ? 8 : 4);
                    } else if (CharArrayUtils.equals(mode, "__HI__") || CharArrayUtils.equals(mode, "HI")) {
                        type = new CBasicType(IBasicType.Kind.eInt, 2 | CVisitor.getSignModifiers(basicType));
                    } else if (CharArrayUtils.equals(mode, "__SI__") || CharArrayUtils.equals(mode, "SI")) {
                        type = new CBasicType(IBasicType.Kind.eInt, CVisitor.getSignModifiers(basicType));
                    } else if (CharArrayUtils.equals(mode, "__DI__") || CharArrayUtils.equals(mode, "DI")) {
                        SizeofCalculator sizeofs = new SizeofCalculator(declarator.getTranslationUnit());
                        int modifier = sizeofs.sizeof_long != null && sizeofs.sizeof_int != null && sizeofs.sizeof_long.size == 2L * sizeofs.sizeof_int.size ? 1 : 64;
                        type = new CBasicType(IBasicType.Kind.eInt, modifier | CVisitor.getSignModifiers(basicType));
                    } else if (CharArrayUtils.equals(mode, "__word__") || CharArrayUtils.equals(mode, "word")) {
                        type = new CBasicType(IBasicType.Kind.eInt, 1 | CVisitor.getSignModifiers(basicType));
                    }
                }
                ++n2;
            }
        }
        return type;
    }

    private static int getSignModifiers(IBasicType type) {
        return type.getModifiers() & 0xC;
    }

    public static IType createType(IType returnType, IASTFunctionDeclarator declarator) {
        IType[] pTypes = CVisitor.getParmTypes(declarator);
        returnType = CVisitor.setupPointerChain(declarator.getPointerOperators(), returnType);
        boolean takesVarargs = declarator instanceof IASTStandardFunctionDeclarator && ((IASTStandardFunctionDeclarator)declarator).takesVarArgs();
        CFunctionType type = new CFunctionType(returnType, pTypes, takesVarargs);
        IASTDeclarator nested = declarator.getNestedDeclarator();
        if (nested != null) {
            return CVisitor.createType(type, nested, 0);
        }
        return type;
    }

    public static IType createBaseType(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof ICASTSimpleDeclSpecifier) {
            ICASTSimpleDeclSpecifier sds = (ICASTSimpleDeclSpecifier)declSpec;
            IASTExpression exp = sds.getDeclTypeExpression();
            if (exp != null) {
                return exp.getExpressionType();
            }
            return new CBasicType(sds);
        }
        IBinding binding = null;
        IASTName name = null;
        if (declSpec instanceof ICASTTypedefNameSpecifier) {
            name = ((ICASTTypedefNameSpecifier)declSpec).getName();
        } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            name = ((IASTElaboratedTypeSpecifier)declSpec).getName();
        } else if (declSpec instanceof IASTCompositeTypeSpecifier) {
            name = ((IASTCompositeTypeSpecifier)declSpec).getName();
        } else if (declSpec instanceof IASTEnumerationSpecifier) {
            name = ((IASTEnumerationSpecifier)declSpec).getName();
        } else {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            return new ProblemType(10000);
        }
        binding = name.resolveBinding();
        if (binding instanceof IType && !(binding instanceof IProblemBinding)) {
            return (IType)((Object)binding);
        }
        return new ProblemType(10001);
    }

    public static IType createType(ICASTDeclSpecifier declSpec) {
        if (declSpec.isConst() || declSpec.isVolatile() || declSpec.isRestrict()) {
            return new CQualifierType(declSpec);
        }
        return CVisitor.createBaseType(declSpec);
    }

    private static IType[] getParmTypes(IASTFunctionDeclarator decltor) {
        if (decltor instanceof IASTStandardFunctionDeclarator) {
            IASTParameterDeclaration[] parms = ((IASTStandardFunctionDeclarator)decltor).getParameters();
            IType[] parmTypes = new IType[parms.length];
            int i = 0;
            while (i < parms.length) {
                parmTypes[i] = CVisitor.createType(parms[i].getDeclarator());
                ++i;
            }
            if (parmTypes.length == 1 && SemanticUtil.isVoidType(parmTypes[0])) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            return parmTypes;
        }
        if (decltor instanceof ICASTKnRFunctionDeclarator) {
            IASTName[] parms = ((ICASTKnRFunctionDeclarator)decltor).getParameterNames();
            IType[] parmTypes = new IType[parms.length];
            int i = 0;
            while (i < parms.length) {
                IASTDeclarator dtor = CVisitor.getKnRParameterDeclarator((ICASTKnRFunctionDeclarator)decltor, parms[i]);
                if (dtor != null) {
                    parmTypes[i] = CVisitor.createType(dtor);
                }
                ++i;
            }
            return parmTypes;
        }
        throw new IllegalArgumentException();
    }

    protected static IASTDeclarator getKnRParameterDeclarator(ICASTKnRFunctionDeclarator fKnRDtor, IASTName name) {
        IASTDeclaration[] decls = fKnRDtor.getParameterDeclarations();
        char[] n = name.toCharArray();
        int i = 0;
        while (i < decls.length) {
            if (decls[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decls[i]).getDeclarators();
                int n2 = dtors.length;
                int n3 = 0;
                while (n3 < n2) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n3];
                    if (CharArrayUtils.equals(dtor.getName().toCharArray(), n)) {
                        return dtor;
                    }
                    ++n3;
                }
            }
            ++i;
        }
        return null;
    }

    private static IType setupArrayChain(IASTDeclarator decl, IType lastType) {
        if (decl instanceof IASTArrayDeclarator) {
            IASTArrayModifier[] mods = ((IASTArrayDeclarator)decl).getArrayModifiers();
            int i = mods.length - 1;
            while (i >= 0) {
                CArrayType arrayType = new CArrayType(lastType);
                if (mods[i] instanceof ICASTArrayModifier) {
                    arrayType.setModifier((ICASTArrayModifier)mods[i]);
                }
                lastType = arrayType;
                --i;
            }
        }
        return lastType;
    }

    private static IType setupPointerChain(IASTPointerOperator[] ptrs, IType lastType) {
        CPointerType pointerType = null;
        if (ptrs != null && ptrs.length > 0) {
            pointerType = new CPointerType();
            if (ptrs.length == 1) {
                pointerType.setType(lastType);
                pointerType.setQualifiers((((ICASTPointer)ptrs[0]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[0]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[0]).isVolatile() ? 4 : 0));
            } else {
                CPointerType tempType = new CPointerType();
                pointerType.setType(tempType);
                pointerType.setQualifiers((((ICASTPointer)ptrs[ptrs.length - 1]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[ptrs.length - 1]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[ptrs.length - 1]).isVolatile() ? 4 : 0));
                int i = ptrs.length - 2;
                while (i > 0) {
                    tempType.setType(new CPointerType());
                    tempType.setQualifiers((((ICASTPointer)ptrs[i]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[i]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[i]).isVolatile() ? 4 : 0));
                    tempType = (CPointerType)tempType.getType();
                    --i;
                }
                tempType.setType(lastType);
                tempType.setQualifiers((((ICASTPointer)ptrs[i]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[i]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[i]).isVolatile() ? 4 : 0));
            }
            return pointerType;
        }
        return lastType;
    }

    public static IASTProblem[] getProblems(IASTTranslationUnit tu) {
        CollectProblemsAction action = new CollectProblemsAction();
        tu.accept(action);
        return action.getProblems();
    }

    public static IASTName[] getDeclarations(IASTTranslationUnit tu, IBinding binding) {
        CollectDeclarationsAction action = new CollectDeclarationsAction(binding);
        tu.accept(action);
        return action.getDeclarationNames();
    }

    public static IASTName[] getReferences(IASTTranslationUnit tu, IBinding binding) {
        CollectReferencesAction action = new CollectReferencesAction(binding);
        tu.accept(action);
        return action.getReferences();
    }

    public static IBinding[] findBindingsForContentAssist(IASTName name, boolean isPrefix) {
        ASTNodeProperty prop = name.getPropertyInParent();
        IBinding[] result = null;
        if (prop == IASTFieldReference.FIELD_NAME) {
            Object res = CVisitor.findBinding((IASTFieldReference)name.getParent(), isPrefix);
            if (isPrefix) {
                result = (IBinding[])res;
            } else {
                IBinding binding = (IBinding)res;
                if (binding != null) {
                    result = new IBinding[]{binding};
                }
            }
        } else if (prop == ICASTFieldDesignator.FIELD_NAME) {
            result = CVisitor.findBindingForContentAssist((ICASTFieldDesignator)name.getParent(), isPrefix);
        } else {
            IScope scope = CVisitor.getContainingScope(name);
            try {
                result = isPrefix ? CVisitor.lookupPrefix(scope, name) : new IBinding[]{CVisitor.lookup(scope, name)};
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return ArrayUtil.trim(IBinding.class, result);
    }

    /*
     * Unable to fully structure code
     */
    private static IBinding[] findBindingForContentAssist(ICASTFieldDesignator fd, boolean isPrefix) {
        block8: {
            declarationNode = blockItem = CVisitor.getContainingBlockItem(fd);
            if (!(blockItem instanceof IASTDeclarationStatement) || !(((IASTDeclarationStatement)blockItem).getDeclaration() instanceof IASTSimpleDeclaration)) ** GOTO lbl6
            declarationNode = ((IASTDeclarationStatement)blockItem).getDeclaration();
            break block8;
lbl-1000:
            // 1 sources

            {
                declarationNode = declarationNode.getParent();
lbl6:
                // 2 sources

                ** while (declarationNode != null && !(declarationNode instanceof IASTSimpleDeclaration))
            }
        }
        if (declarationNode instanceof IASTSimpleDeclaration) {
            simpleDecl = (IASTSimpleDeclaration)declarationNode;
            struct = null;
            if (simpleDecl.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                struct = ((IASTNamedTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
            } else if (simpleDecl.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
                struct = ((IASTElaboratedTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
            } else if (simpleDecl.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                struct = ((IASTCompositeTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
            }
            if (struct instanceof IType && (t = CVisitor.unwrapTypedefs((IType)struct)) instanceof ICompositeType) {
                return CVisitor.findFieldsByPrefix((ICompositeType)t, fd.getName().toCharArray());
            }
        }
        return null;
    }

    public static IBinding[] findBindings(IScope scope, String name) {
        CASTName astName = new CASTName(name.toCharArray());
        astName.setPropertyInParent(STRING_LOOKUP_PROPERTY);
        IBinding o1 = CVisitor.lookup(scope, astName);
        Object[] b1 = null;
        b1 = o1 instanceof IBinding ? new IBinding[]{o1} : (IBinding[])o1;
        astName.setPropertyInParent(STRING_LOOKUP_TAGS_PROPERTY);
        IBinding o2 = CVisitor.lookup(scope, astName);
        Object[] b2 = null;
        b2 = o2 instanceof IBinding ? new IBinding[]{o2} : (IBinding[])o2;
        ArrayList<ILabel> b3 = new ArrayList<ILabel>();
        block2: do {
            char[] n = name.toCharArray();
            if (scope instanceof CFunctionScope) {
                ILabel[] labels;
                IASTFunctionDefinition def = ASTQueries.findAncestorWithType(((CFunctionScope)scope).getPhysicalNode(), IASTFunctionDefinition.class);
                ILabel[] iLabelArray = labels = CVisitor.getLabels(def);
                int n2 = labels.length;
                int n3 = 0;
                while (n3 < n2) {
                    ILabel label = iLabelArray[n3];
                    if (CharArrayUtils.equals(label.getNameCharArray(), n)) {
                        b3.add(label);
                        break block2;
                    }
                    ++n3;
                }
                break;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException e) {
                scope = null;
            }
        } while (scope != null);
        int c = (b1 == null ? 0 : b1.length) + (b2 == null ? 0 : b2.length) + b3.size();
        IBinding[] result = new IBinding[c];
        if (b1 != null) {
            ArrayUtil.addAll(IBinding.class, result, b1);
        }
        if (b2 != null) {
            ArrayUtil.addAll(IBinding.class, result, b2);
        }
        ArrayUtil.addAll(IBinding.class, result, b3.toArray(new IBinding[b3.size()]));
        return result;
    }

    public static boolean declaredBefore(IASTNode nodeA, IASTNode nodeB) {
        if (nodeB == null) {
            return true;
        }
        if (nodeB.getPropertyInParent() == STRING_LOOKUP_PROPERTY) {
            return true;
        }
        if (nodeB.getPropertyInParent() == STRING_LOOKUP_TAGS_PROPERTY) {
            return true;
        }
        if (nodeA instanceof ASTNode) {
            ASTNode nd = (ASTNode)nodeA;
            int pointOfDecl = 0;
            ASTNodeProperty prop = nd.getPropertyInParent();
            if (prop == IASTDeclarator.DECLARATOR_NAME || nd instanceof IASTDeclarator) {
                IASTDeclarator dtor = (IASTDeclarator)(nd instanceof IASTDeclarator ? nd : nd.getParent());
                while (dtor.getParent() instanceof IASTDeclarator) {
                    dtor = (IASTDeclarator)dtor.getParent();
                }
                IASTInitializer init = dtor.getInitializer();
                pointOfDecl = init != null ? ((ASTNode)((Object)init)).getOffset() - 1 : ((ASTNode)((Object)dtor)).getOffset() + ((ASTNode)((Object)dtor)).getLength();
            } else if (prop == IASTEnumerationSpecifier.IASTEnumerator.ENUMERATOR_NAME) {
                IASTEnumerationSpecifier.IASTEnumerator enumtor = (IASTEnumerationSpecifier.IASTEnumerator)nd.getParent();
                if (enumtor.getValue() != null) {
                    ASTNode exp = (ASTNode)((Object)enumtor.getValue());
                    pointOfDecl = exp.getOffset() + exp.getLength();
                } else {
                    pointOfDecl = nd.getOffset() + nd.getLength();
                }
            } else {
                pointOfDecl = nd.getOffset() + nd.getLength();
            }
            return pointOfDecl < ((ASTNode)nodeB).getOffset();
        }
        return true;
    }

    public static IBinding findDeclarationOwner(IASTNode node, boolean allowFunction) {
        while (!(node instanceof IASTDeclaration)) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        IASTName name = null;
        node = node.getParent();
        while (node != null) {
            if (node instanceof IASTFunctionDefinition) {
                if (allowFunction) {
                    IASTDeclarator dtor = CVisitor.findInnermostDeclarator(((IASTFunctionDefinition)node).getDeclarator());
                    if (dtor == null) break;
                    name = dtor.getName();
                    break;
                }
            } else if (node instanceof IASTCompositeTypeSpecifier) {
                name = ((IASTCompositeTypeSpecifier)node).getName();
                break;
            }
            node = node.getParent();
        }
        if (name == null) {
            return null;
        }
        return name.resolveBinding();
    }

    public static boolean isNullPointerConstant(IASTExpression expression) {
        IValue value;
        IASTCastExpression castExpression;
        IType castType;
        IASTUnaryExpression unaryExpression;
        if (expression instanceof IASTUnaryExpression && (unaryExpression = (IASTUnaryExpression)expression).getOperator() == 11) {
            return CVisitor.isNullPointerConstant(unaryExpression.getOperand());
        }
        if (expression instanceof IASTCastExpression && (castType = CVisitor.createType((castExpression = (IASTCastExpression)expression).getTypeId())).isSameType(CPointerType.VOID_POINTER)) {
            return CVisitor.isNullPointerConstant(castExpression.getOperand());
        }
        IType expressionType = expression.getExpressionType();
        if (expressionType instanceof IBasicType && (value = ValueFactory.create(expression)) != null && value.numberValue() != null) {
            return value.numberValue().longValue() == 0L;
        }
        return false;
    }

    public static class CollectDeclarationsAction
    extends ASTVisitor {
        private static final int DEFAULT_CHILDREN_LIST_SIZE = 8;
        private IASTName[] declsFound;
        int numFound;
        IBinding binding;
        boolean compositeTypeDeclared;

        private void addName(IASTName name) {
            if (this.declsFound.length == this.numFound) {
                IASTName[] old = this.declsFound;
                this.declsFound = new IASTName[old.length * 2];
                int j = 0;
                while (j < old.length) {
                    this.declsFound[j] = old[j];
                    ++j;
                }
            }
            this.declsFound[this.numFound++] = name;
        }

        private IASTName[] removeNullFromNames() {
            if (this.declsFound[this.declsFound.length - 1] != null) {
                return this.declsFound;
            }
            if (this.declsFound[0] == null) {
                return new IASTName[0];
            }
            IASTName[] results = new IASTName[this.numFound];
            int i = 0;
            while (i < results.length) {
                results[i] = this.declsFound[i];
                ++i;
            }
            return results;
        }

        public IASTName[] getDeclarationNames() {
            return this.removeNullFromNames();
        }

        public CollectDeclarationsAction(IBinding binding) {
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitEnumerators = true;
            this.shouldVisitStatements = true;
            this.declsFound = null;
            this.numFound = 0;
            this.binding = null;
            this.compositeTypeDeclared = false;
            this.declsFound = new IASTName[8];
            this.binding = binding;
        }

        @Override
        public int visit(IASTDeclarator declarator) {
            if (declarator == null || declarator.getName() == null || declarator.getName().toCharArray().length == 0) {
                return 3;
            }
            if (this.binding instanceof ICompositeType) {
                return 3;
            }
            if (this.binding instanceof IEnumeration) {
                return 3;
            }
            IASTNode parent = declarator.getParent();
            while (parent != null && !(parent instanceof IASTDeclaration) && !(parent instanceof IASTParameterDeclaration)) {
                parent = parent.getParent();
            }
            if (parent instanceof IASTDeclaration) {
                if (parent instanceof IASTFunctionDefinition) {
                    if (declarator.getName() != null && declarator.getName().resolveBinding() == this.binding) {
                        this.addName(declarator.getName());
                    }
                } else if (parent instanceof IASTSimpleDeclaration && declarator.getName() != null && declarator.getName().resolveBinding() == this.binding) {
                    this.addName(declarator.getName());
                }
            } else if (parent instanceof IASTParameterDeclaration && declarator.getName() != null && declarator.getName().resolveBinding() == this.binding) {
                this.addName(declarator.getName());
            }
            return 3;
        }

        @Override
        public int visit(IASTDeclSpecifier declSpec) {
            if (this.compositeTypeDeclared && declSpec instanceof ICASTTypedefNameSpecifier) {
                return 3;
            }
            if (!(this.binding instanceof ICompositeType) && !(this.binding instanceof IEnumeration)) {
                return 3;
            }
            if (this.binding instanceof ICompositeType && declSpec instanceof IASTCompositeTypeSpecifier) {
                if (((IASTCompositeTypeSpecifier)declSpec).getName().resolveBinding() == this.binding) {
                    this.compositeTypeDeclared = true;
                    this.addName(((IASTCompositeTypeSpecifier)declSpec).getName());
                }
            } else if (this.binding instanceof IEnumeration && declSpec instanceof IASTEnumerationSpecifier) {
                if (((IASTEnumerationSpecifier)declSpec).getName().resolveBinding() == this.binding) {
                    this.compositeTypeDeclared = true;
                    this.addName(((IASTEnumerationSpecifier)declSpec).getName());
                }
            } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
                IASTNode parent;
                if (this.compositeTypeDeclared && (!((parent = declSpec.getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)parent).getDeclarators().length > 0)) {
                    return 3;
                }
                if (((IASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding() == this.binding) {
                    this.compositeTypeDeclared = true;
                    this.addName(((IASTElaboratedTypeSpecifier)declSpec).getName());
                }
            }
            return 3;
        }

        @Override
        public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            if (this.binding instanceof IEnumerator && enumerator.getName().resolveBinding() == this.binding) {
                this.addName(enumerator.getName());
            }
            return 3;
        }

        @Override
        public int visit(IASTStatement statement) {
            if (statement instanceof IASTLabelStatement && this.binding instanceof ILabel) {
                if (((IASTLabelStatement)statement).getName().resolveBinding() == this.binding) {
                    this.addName(((IASTLabelStatement)statement).getName());
                }
                return 1;
            }
            return 3;
        }
    }

    public static class CollectProblemsAction
    extends ASTVisitor {
        private static final int DEFAULT_CHILDREN_LIST_SIZE = 8;
        private IASTProblem[] problems;
        int numFound;

        public CollectProblemsAction() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitTypeIds = true;
            this.problems = null;
            this.numFound = 0;
            this.problems = new IASTProblem[8];
        }

        private void addProblem(IASTProblem problem) {
            if (this.problems.length == this.numFound) {
                IASTProblem[] old = this.problems;
                this.problems = new IASTProblem[old.length * 2];
                int j = 0;
                while (j < old.length) {
                    this.problems[j] = old[j];
                    ++j;
                }
            }
            this.problems[this.numFound++] = problem;
        }

        private IASTProblem[] removeNullFromProblems() {
            if (this.problems[this.problems.length - 1] != null) {
                return this.problems;
            }
            if (this.problems[0] == null) {
                return new IASTProblem[0];
            }
            IASTProblem[] results = new IASTProblem[this.numFound];
            int i = 0;
            while (i < results.length) {
                results[i] = this.problems[i];
                ++i;
            }
            return results;
        }

        public IASTProblem[] getProblems() {
            return this.removeNullFromProblems();
        }

        @Override
        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)declaration)).getProblem());
            }
            return 3;
        }

        @Override
        public int visit(IASTExpression expression) {
            if (expression instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)expression)).getProblem());
            }
            return 3;
        }

        @Override
        public int visit(IASTStatement statement) {
            if (statement instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)statement)).getProblem());
            }
            return 3;
        }

        @Override
        public int visit(IASTTypeId typeId) {
            if (typeId instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)typeId)).getProblem());
            }
            return 3;
        }
    }

    public static class CollectReferencesAction
    extends ASTVisitor {
        private static final int DEFAULT_LIST_SIZE = 8;
        private IASTName[] refs;
        private final IBinding binding;
        private int idx = 0;
        private int kind;
        private static final int KIND_LABEL = 1;
        private static final int KIND_OBJ_FN = 2;
        private static final int KIND_TYPE = 3;

        public CollectReferencesAction(IBinding binding) {
            this.binding = binding;
            this.refs = new IASTName[8];
            this.shouldVisitNames = true;
            this.kind = binding instanceof ILabel ? 1 : (binding instanceof ICompositeType || binding instanceof ITypedef || binding instanceof IEnumeration ? 3 : 2);
        }

        @Override
        public int visit(IASTName name) {
            ASTNodeProperty prop = name.getPropertyInParent();
            switch (this.kind) {
                case 1: {
                    if (prop == IASTGotoStatement.NAME) break;
                    return 3;
                }
                case 3: {
                    IASTNode p;
                    if (prop == IASTNamedTypeSpecifier.NAME || prop == IASTElaboratedTypeSpecifier.TYPE_NAME && (!((p = name.getParent().getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)p).getDeclarators().length > 0)) break;
                    return 3;
                }
                case 2: {
                    if (prop == IASTIdExpression.ID_NAME || prop == IASTFieldReference.FIELD_NAME || prop == ICASTFieldDesignator.FIELD_NAME) break;
                    return 3;
                }
            }
            if (CharArrayUtils.equals(name.toCharArray(), this.binding.getNameCharArray()) && this.sameBinding(name.resolveBinding(), this.binding)) {
                if (this.refs.length == this.idx) {
                    IASTName[] temp = new IASTName[this.refs.length * 2];
                    System.arraycopy(this.refs, 0, temp, 0, this.refs.length);
                    this.refs = temp;
                }
                this.refs[this.idx++] = name;
            }
            return 3;
        }

        private boolean sameBinding(IBinding binding1, IBinding binding2) {
            if (binding1 == binding2) {
                return true;
            }
            return binding1 != null && binding1.equals(binding2);
        }

        public IASTName[] getReferences() {
            if (this.idx < this.refs.length) {
                IASTName[] temp = new IASTName[this.idx];
                System.arraycopy(this.refs, 0, temp, 0, this.idx);
                this.refs = temp;
            }
            return this.refs;
        }
    }
}

