/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.util.Map;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParserSettings;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.core.parser.ScannerInfo;

public class ExtendedScannerInfo
extends ScannerInfo
implements IExtendedScannerInfo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String[] macroFiles;
    private String[] includeFiles;
    private String[] localIncludePaths;
    private IncludeExportPatterns includeExportPatterns;
    private IParserSettings parserSettings;

    public ExtendedScannerInfo() {
    }

    public ExtendedScannerInfo(Map<String, String> definedSymbols, String[] includePaths) {
        super(definedSymbols, includePaths);
    }

    public ExtendedScannerInfo(Map<String, String> definedSymbols, String[] includePaths, String[] macroFiles, String[] includeFiles) {
        super(definedSymbols, includePaths);
        this.macroFiles = macroFiles;
        this.includeFiles = includeFiles;
    }

    public ExtendedScannerInfo(Map<String, String> definedSymbols, String[] includePaths, String[] macroFiles, String[] includeFiles, String[] localIncludePaths) {
        super(definedSymbols, includePaths);
        this.macroFiles = macroFiles;
        this.includeFiles = includeFiles;
        this.localIncludePaths = localIncludePaths;
    }

    public ExtendedScannerInfo(IScannerInfo info) {
        super(info.getDefinedSymbols(), info.getIncludePaths());
        if (info instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo einfo = (IExtendedScannerInfo)info;
            this.macroFiles = einfo.getMacroFiles();
            this.includeFiles = einfo.getIncludeFiles();
            this.localIncludePaths = einfo.getLocalIncludePath();
        }
        if (info instanceof ExtendedScannerInfo) {
            ExtendedScannerInfo extendedScannerInfo = (ExtendedScannerInfo)info;
            this.includeExportPatterns = extendedScannerInfo.includeExportPatterns;
            this.parserSettings = extendedScannerInfo.parserSettings;
        }
    }

    @Override
    public String[] getMacroFiles() {
        if (this.macroFiles == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.macroFiles;
    }

    @Override
    public String[] getIncludeFiles() {
        if (this.includeFiles == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.includeFiles;
    }

    @Override
    public String[] getLocalIncludePath() {
        if (this.localIncludePaths == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.localIncludePaths;
    }

    public IncludeExportPatterns getIncludeExportPatterns() {
        return this.includeExportPatterns;
    }

    public void setIncludeExportPatterns(IncludeExportPatterns patterns) {
        this.includeExportPatterns = patterns;
    }

    public IParserSettings getParserSettings() {
        return this.parserSettings;
    }

    public void setParserSettings(IParserSettings parserSettings) {
        this.parserSettings = parserSettings;
    }
}

