/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language.settings.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsBroadcastingProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsBaseProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsSerializableStorage;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LanguageSettingsSerializableProvider
extends LanguageSettingsBaseProvider
implements ILanguageSettingsBroadcastingProvider {
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_CLASS = "class";
    protected static final String ELEM_PROVIDER = "provider";
    protected static final String ELEM_LANGUAGE_SCOPE = "language-scope";
    private LanguageSettingsSerializableStorage fStorage = new LanguageSettingsSerializableStorage();

    public LanguageSettingsSerializableProvider() {
    }

    public LanguageSettingsSerializableProvider(String id, String name) {
        super(id, name);
    }

    public LanguageSettingsSerializableProvider(Element elementProvider) {
        this.load(elementProvider);
    }

    @Override
    public void configureProvider(String id, String name, List<String> languages, List<ICLanguageSettingEntry> entries, Map<String, String> properties) {
        super.configureProvider(id, name, languages, null, properties);
        this.fStorage.clear();
        if (entries != null) {
            this.setSettingEntries(null, null, null, entries);
        }
    }

    public boolean isEmpty() {
        return this.fStorage.isEmpty();
    }

    public void setLanguageScope(List<String> languages) {
        this.languageScope = languages == null ? null : new ArrayList<String>(languages);
    }

    public void clear() {
        this.fStorage.clear();
    }

    public void setSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId, List<? extends ICLanguageSettingEntry> entries) {
        String rcProjectPath = rc != null ? rc.getProjectRelativePath().toString() : null;
        this.fStorage.setSettingEntries(rcProjectPath, languageId, entries);
        if (cfgDescription != null) {
            CommandLauncherManager.getInstance().setLanguageSettingEntries(cfgDescription.getProjectDescription().getProject(), entries);
        }
    }

    @Override
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        String rcProjectPath = rc != null ? rc.getProjectRelativePath().toString() : null;
        List<ICLanguageSettingEntry> entries = this.fStorage.getSettingEntries(rcProjectPath, languageId);
        if (entries == null && languageId != null && (this.languageScope == null || this.languageScope.contains(languageId))) {
            entries = this.fStorage.getSettingEntries(rcProjectPath, null);
        }
        if (cfgDescription != null) {
            entries = CommandLauncherManager.getInstance().getLanguageSettingEntries(cfgDescription.getProjectDescription().getProject(), entries);
        }
        return entries;
    }

    public final Element serialize(Element parentElement) {
        Element elementProvider = this.serializeAttributes(parentElement);
        this.serializeEntries(elementProvider);
        return elementProvider;
    }

    public Element serializeAttributes(Element parentElement) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(ATTR_ID);
        attributes.add(this.getId());
        attributes.add(ATTR_NAME);
        attributes.add(this.getName());
        attributes.add(ATTR_CLASS);
        attributes.add(this.getClass().getCanonicalName());
        for (Map.Entry entry : this.properties.entrySet()) {
            attributes.add((String)entry.getKey());
            attributes.add((String)entry.getValue());
        }
        Element elementProvider = XmlUtil.appendElement(parentElement, ELEM_PROVIDER, attributes.toArray(new String[0]));
        if (this.languageScope != null) {
            for (String langId : this.languageScope) {
                XmlUtil.appendElement(elementProvider, ELEM_LANGUAGE_SCOPE, new String[]{ATTR_ID, langId});
            }
        }
        return elementProvider;
    }

    public void serializeEntries(Element elementProvider) {
        this.fStorage.serializeEntries(elementProvider);
    }

    public IStatus serializeLanguageSettings(ICConfigurationDescription cfgDescription) {
        IStatus status = Status.OK_STATUS;
        try {
            if (cfgDescription != null) {
                LanguageSettingsManager.serializeLanguageSettings(cfgDescription.getProjectDescription());
            } else {
                LanguageSettingsManager.serializeLanguageSettingsWorkspace();
            }
        }
        catch (CoreException e) {
            status = new Status(4, "org.eclipse.cdt.core", 4, "Error serializing language settings", (Throwable)e);
            CCorePlugin.log(status);
        }
        return status;
    }

    public void serializeLanguageSettingsInBackground(ICConfigurationDescription cfgDescription) {
        if (cfgDescription != null) {
            if (this.isLanguageSettingsProviderStoreChanged(cfgDescription)) {
                LanguageSettingsManager.serializeLanguageSettingsInBackground(cfgDescription.getProjectDescription());
            }
        } else {
            LanguageSettingsManager.serializeLanguageSettingsWorkspaceInBackground();
        }
    }

    private boolean isLanguageSettingsProviderStoreChanged(ICConfigurationDescription cfgDescription) {
        if (cfgDescription instanceof IInternalCCfgInfo) {
            try {
                CConfigurationSpecSettings ss = ((IInternalCCfgInfo)((Object)cfgDescription)).getSpecSettings();
                if (ss != null) {
                    return ss.isLanguageSettingsProviderStoreChanged(this);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return true;
    }

    public final void load(Element providerNode) {
        this.fStorage.clear();
        this.languageScope = null;
        if (providerNode != null) {
            this.loadAttributes(providerNode);
            this.loadEntries(providerNode);
        }
    }

    private void loadLanguageScopeElement(Node parentNode) {
        if (this.languageScope == null) {
            this.languageScope = new ArrayList();
        }
        String id = XmlUtil.determineAttributeValue(parentNode, ATTR_ID);
        this.languageScope.add(id);
    }

    public void loadAttributes(Element providerNode) {
        String providerId = XmlUtil.determineAttributeValue(providerNode, ATTR_ID);
        String providerName = XmlUtil.determineAttributeValue(providerNode, ATTR_NAME);
        this.properties.clear();
        NamedNodeMap attrs = providerNode.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            String key;
            Node attr = attrs.item(i);
            if (!(attr.getNodeType() != 2 || (key = attr.getNodeName()).equals(ATTR_ID) || key.equals(ATTR_NAME) || key.equals(ATTR_CLASS))) {
                String value = attr.getNodeValue();
                this.properties.put(key, value);
            }
            ++i;
        }
        this.setId(providerId);
        this.setName(providerName);
        NodeList nodes = providerNode.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Node elementNode = nodes.item(i2);
            if (elementNode.getNodeType() == 1 && ELEM_LANGUAGE_SCOPE.equals(elementNode.getNodeName())) {
                this.loadLanguageScopeElement(elementNode);
            }
            ++i2;
        }
    }

    public void loadEntries(Element providerNode) {
        this.fStorage.loadEntries(providerNode);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setPropertyBool(String key, boolean value) {
        this.properties.put(key, Boolean.toString(value));
    }

    private LanguageSettingsSerializableProvider cloneShallowInternal() throws CloneNotSupportedException {
        LanguageSettingsSerializableProvider clone = (LanguageSettingsSerializableProvider)super.clone();
        if (this.languageScope != null) {
            clone.languageScope = new ArrayList(this.languageScope);
        }
        clone.properties = new HashMap(this.properties);
        clone.fStorage = new LanguageSettingsSerializableStorage();
        return clone;
    }

    protected LanguageSettingsSerializableProvider cloneShallow() throws CloneNotSupportedException {
        return this.cloneShallowInternal();
    }

    protected LanguageSettingsSerializableProvider clone() throws CloneNotSupportedException {
        LanguageSettingsSerializableProvider clone = this.cloneShallowInternal();
        clone.fStorage = this.fStorage.clone();
        return clone;
    }

    @Override
    public LanguageSettingsStorage copyStorage() {
        try {
            return this.fStorage.clone();
        }
        catch (CloneNotSupportedException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fStorage == null ? 0 : this.fStorage.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageSettingsSerializableProvider other = (LanguageSettingsSerializableProvider)obj;
        return !(this.fStorage == null ? other.fStorage != null : !this.fStorage.equals(other.fStorage));
    }
}

