/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;

public class CLanguageKeywords
implements ICLanguageKeywords {
    private final ParserLanguage language;
    private final IScannerExtensionConfiguration config;
    private String[] keywords = null;
    private String[] builtinTypes = null;
    private String[] preprocessorKeywords = null;

    public CLanguageKeywords(ParserLanguage language, IScannerExtensionConfiguration config) {
        if (language == null) {
            throw new NullPointerException("language is null");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.language = language;
        this.config = config;
    }

    @Override
    public String[] getKeywords() {
        if (this.keywords == null) {
            HashSet<String> keywordSet = new HashSet<String>(KeywordSets.getKeywords(KeywordSetKey.KEYWORDS, this.language));
            CharArrayIntMap additionalKeywords = this.config.getAdditionalKeywords();
            if (additionalKeywords != null) {
                for (char[] name : additionalKeywords.toList()) {
                    keywordSet.add(new String(name));
                }
            }
            this.keywords = keywordSet.toArray(new String[keywordSet.size()]);
        }
        return this.keywords;
    }

    @Override
    public String[] getBuiltinTypes() {
        if (this.builtinTypes == null) {
            Set<String> types = KeywordSets.getKeywords(KeywordSetKey.TYPES, this.language);
            this.builtinTypes = types.toArray(new String[types.size()]);
        }
        return this.builtinTypes;
    }

    @Override
    public String[] getPreprocessorKeywords() {
        if (this.preprocessorKeywords == null) {
            HashSet<String> keywords = new HashSet<String>(KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, this.language));
            CharArrayIntMap additionalKeywords = this.config.getAdditionalPreprocessorKeywords();
            if (additionalKeywords != null) {
                for (char[] name : additionalKeywords.toList()) {
                    keywords.add(new String(name));
                }
            }
            this.preprocessorKeywords = keywords.toArray(new String[keywords.size()]);
        }
        return this.preprocessorKeywords;
    }
}

