/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;

public class InstallableUnitPatch
extends InstallableUnit
implements IInstallableUnitPatch {
    public static final String MEMBER_APPLICABILITY_SCOPE = "applicabilityScope";
    public static final String MEMBER_LIFECYCLE = "lifeCycle";
    public static final String MEMBER_REQUIREMENTS_CHANGE = "requirementsChange";
    private IRequirementChange[] changes;
    private IRequirement lifeCycle;
    private IRequirement[][] scope;

    private void addRequiredCapability(IRequirement[] toAdd) {
        Collection current = super.getRequirements();
        int currSize = current.size();
        IRequirement[] result = new IRequirement[currSize + toAdd.length];
        int i = 0;
        while (i < currSize) {
            result[i] = (IRequirement)current.get(i);
            ++i;
        }
        System.arraycopy(toAdd, 0, result, currSize, toAdd.length);
        super.setRequiredCapabilities(result);
    }

    @Override
    public void setRequiredCapabilities(IRequirement[] capabilities) {
        IRequirement[] result = capabilities;
        if (this.lifeCycle != null && !Arrays.asList(capabilities).contains(this.lifeCycle)) {
            int currSize = capabilities.length;
            result = new IRequirement[currSize + 1];
            System.arraycopy(capabilities, 0, result, 0, capabilities.length);
            result[currSize] = this.lifeCycle;
        }
        super.setRequiredCapabilities(result);
    }

    @Override
    public IRequirement[][] getApplicabilityScope() {
        return this.scope;
    }

    @Override
    public IRequirement getLifeCycle() {
        return this.lifeCycle;
    }

    @Override
    public List<IRequirementChange> getRequirementsChange() {
        return CollectionUtils.unmodifiableList((Object[])this.changes);
    }

    public void setApplicabilityScope(IRequirement[][] applyTo) {
        this.scope = applyTo;
    }

    public void setLifeCycle(IRequirement lifeCycle) {
        if (lifeCycle == null) {
            return;
        }
        this.lifeCycle = lifeCycle;
        this.addRequiredCapability(new IRequirement[]{lifeCycle});
    }

    public void setRequirementsChange(IRequirementChange[] changes) {
        this.changes = changes;
    }

    @Override
    public Object getMember(String memberName) {
        if (MEMBER_APPLICABILITY_SCOPE == memberName) {
            return this.scope;
        }
        if (MEMBER_LIFECYCLE == memberName) {
            return this.lifeCycle;
        }
        if (MEMBER_REQUIREMENTS_CHANGE == memberName) {
            return this.changes;
        }
        return super.getMember(memberName);
    }
}

