/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.CompositeValue;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalID;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public final class EvalFunctionCall
extends CPPDependentEvaluation {
    private final ICPPEvaluation[] fArguments;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private IType fType;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;
    private final ICPPEvaluation fImplicitThis;

    public EvalFunctionCall(ICPPEvaluation[] args, ICPPEvaluation owner, IBinding templateDefinition) {
        super(templateDefinition);
        int i = 0;
        while (i < args.length) {
            Assert.isNotNull((Object)args[i]);
            ++i;
        }
        this.fArguments = args;
        this.fImplicitThis = this.getImplicitThis() == owner ? null : owner;
    }

    public EvalFunctionCall(ICPPEvaluation[] args, ICPPEvaluation owner, IASTNode pointOfDefinition) {
        this(args, owner, EvalFunctionCall.findEnclosingTemplate(pointOfDefinition));
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    private ICPPEvaluation getImplicitThis() {
        if (this.fImplicitThis != null) {
            return this.fImplicitThis;
        }
        if (this.fArguments.length > 0) {
            if (this.fArguments[0] instanceof EvalMemberAccess) {
                return ((EvalMemberAccess)this.fArguments[0]).getOwnerEval();
            }
            if (this.fArguments[0] instanceof EvalID) {
                return ((EvalID)this.fArguments[0]).getFieldOwner();
            }
        }
        return null;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        return EvalFunctionCall.containsDependentType(this.fArguments);
    }

    @Override
    public boolean isValueDependent() {
        return EvalFunctionCall.containsDependentValue(this.fArguments) || !CPPTemplates.isFullyInstantiated(this.resolveFunctionBinding());
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        return EvalFunctionCall.areAllConstantExpressions(this.fArguments) && EvalFunctionCall.isNullOrConstexprFunc(this.resolveFunctionBinding());
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalFunctionCall)) {
            return false;
        }
        EvalFunctionCall o = (EvalFunctionCall)other;
        return EvalFunctionCall.areEquivalentEvaluations(this.fArguments, o.fArguments);
    }

    public ICPPFunction getOverload() {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload();
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload() {
        if (this.isTypeDependent()) {
            return null;
        }
        IType t = SemanticUtil.getNestedType(this.fArguments[0].getType(), 13);
        if (t instanceof ICPPClassType) {
            return CPPSemantics.findOverloadedOperator(this.getTemplateDefinitionScope(), this.fArguments, t, OverloadableOperator.PAREN, CPPSemantics.LookupMode.NO_GLOBALS);
        }
        return null;
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.computeType();
        }
        return this.fType;
    }

    private IType computeType() {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.typeFromFunctionCall(overload);
        }
        ICPPEvaluation function = this.fArguments[0];
        IType result = ExpressionTypes.typeFromFunctionCall(function.getType());
        if (function instanceof EvalMemberAccess) {
            result = ExpressionTypes.restoreTypedefs(result, ((EvalMemberAccess)function).getOwnerType());
        }
        return result;
    }

    @Override
    public IValue getValue() {
        ICPPEvaluation eval = this.evaluateFunctionBody(new ICPPEvaluation.ConstexprEvaluationContext());
        if (eval == this) {
            return DependentValue.create(eval);
        }
        return eval.getValue();
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        IType t = this.fArguments[0].getType();
        if (t instanceof IPointerType) {
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 13);
        }
        if (t instanceof IFunctionType) {
            return ExpressionTypes.valueCategoryFromReturnType(((IFunctionType)t).getReturnType());
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)8);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        buffer.marshalEvaluation(this.fImplicitThis, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        ICPPEvaluation[] args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = buffer.unmarshalEvaluation();
            ++i;
        }
        ICPPEvaluation implicitThis = buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalFunctionCall(args, implicitThis, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation[] args = EvalFunctionCall.instantiateExpressions(this.fArguments, context, maxDepth);
        if (args == this.fArguments) {
            return this;
        }
        ICPPEvaluation implicitThis = this.fImplicitThis;
        if (args[0] instanceof EvalFunctionSet && this.getOverload() == null) {
            EvalFunctionSet functionSet = (EvalFunctionSet)args[0];
            args[0] = functionSet.resolveFunction(Arrays.copyOfRange(args, 1, args.length));
            if (args[0] == EvalFixed.INCOMPLETE) {
                IASTNode iASTNode = CPPSemantics.getCurrentLookupPoint();
                if (iASTNode instanceof ICPPASTTemplateId) {
                    ICPPASTTemplateId templateId = (ICPPASTTemplateId)iASTNode;
                    IASTNode[] iASTNodeArray = templateId.getTemplateArguments();
                    int n = iASTNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTTypeId typeId;
                        IASTNode argument = iASTNodeArray[n2];
                        if (argument instanceof IASTTypeId && CPPVisitor.createType(typeId = (IASTTypeId)argument) instanceof ICPPTemplateParameter) {
                            return this;
                        }
                        ++n2;
                    }
                }
                return args[0];
            }
            if (implicitThis == null) {
                implicitThis = this.getImplicitThis();
            }
        }
        ICPPEvaluation newImplicitThis = implicitThis != null ? implicitThis.instantiate(context, maxDepth) : null;
        return new EvalFunctionCall(args, newImplicitThis, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (context.getStepsPerformed() >= 1024) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPFunction functionBinding = this.resolveFunctionBinding();
        if (functionBinding == null) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation[] args = new ICPPEvaluation[this.fArguments.length];
        System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
        ICPPParameter[] parameters = functionBinding.getParameters();
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(record, context.recordStep());
            if (i > 0 && i <= parameters.length && this.isReference(parameters[i - 1]) && this.fArguments[i] instanceof EvalBinding) {
                EvalBinding evalBinding = (EvalBinding)this.fArguments[i];
                IBinding binding = evalBinding.getBinding();
                if (record.getVariable(binding) == null) {
                    return EvalFixed.INCOMPLETE;
                }
                arg = new EvalReference(record, binding, evalBinding.getTemplateDefinition());
            } else if (i > 0 && i <= parameters.length && !this.isReference(parameters[i - 1])) {
                IValue copiedValue = arg.getValue().clone();
                arg = new EvalFixed(arg.getType(), arg.getValueCategory(), copiedValue);
            }
            if (arg == EvalFixed.INCOMPLETE) {
                return EvalFixed.INCOMPLETE;
            }
            args[i] = arg;
            ++i;
        }
        ICPPEvaluation implicitThis = this.getImplicitThis();
        ICPPEvaluation owner = null;
        if (functionBinding instanceof ICPPMethod) {
            IBinding ownerBinding;
            owner = implicitThis instanceof EvalBinding ? (record.getVariable(ownerBinding = ((EvalBinding)implicitThis).getBinding()) != null ? new EvalReference(record, ownerBinding, implicitThis.getTemplateDefinition()) : implicitThis) : (implicitThis != null ? implicitThis.computeForFunctionCall(record, context) : record.getImplicitThis());
        }
        return new EvalFunctionCall(args, owner, this.getTemplateDefinition()).evaluateFunctionBody(context.recordStep());
    }

    private ICPPEvaluation evaluateFunctionBody(ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.isValueDependent()) {
            return this;
        }
        if (!EvalFunctionCall.areAllConstantExpressions(this.fArguments, 1, this.fArguments.length)) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPFunction function = this.resolveFunctionBinding();
        if (function == null) {
            return this;
        }
        if (!function.isConstexpr()) {
            return EvalFixed.INCOMPLETE;
        }
        ActivationRecord record = EvalFunctionCall.createActivationRecord(function.getParameters(), this.fArguments, this.getImplicitThis());
        ICPPExecution bodyExec = CPPFunction.getFunctionBodyExecution(function);
        if (bodyExec == null) {
            if (!(function instanceof ICPPTemplateInstance) || ((ICPPTemplateInstance)((Object)function)).isExplicitSpecialization()) {
                return EvalFixed.INCOMPLETE;
            }
            ICPPTemplateInstance functionInstance = (ICPPTemplateInstance)((Object)function);
            IBinding specialized = functionInstance.getSpecializedBinding();
            if (!(specialized instanceof ICPPFunction)) {
                return this;
            }
            bodyExec = CPPFunction.getFunctionBodyExecution((ICPPFunction)specialized);
        }
        if (bodyExec != null && (bodyExec = bodyExec.executeForFunctionCall(record, context.recordStep())) != null) {
            if ((bodyExec = bodyExec.executeForFunctionCall(record, context.recordStep())) instanceof ExecReturn) {
                ExecReturn execReturn = (ExecReturn)bodyExec;
                ICPPEvaluation returnValueEval = execReturn.getReturnValueEvaluation();
                if (returnValueEval instanceof EvalBinding) {
                    returnValueEval = returnValueEval.computeForFunctionCall(record, context.recordStep());
                }
                return returnValueEval;
            }
            if (bodyExec == ExecIncomplete.INSTANCE) {
                return EvalFixed.INCOMPLETE;
            }
        }
        return EvalFixed.INCOMPLETE;
    }

    public ICPPFunction resolveFunctionBinding() {
        ICPPFunction function = this.getOverload();
        if (function == null) {
            ICPPEvaluation funcEval = this.fArguments[0];
            if (funcEval instanceof EvalFunctionSet) {
                EvalFunctionSet funcEvalFunctionSet = (EvalFunctionSet)funcEval;
                funcEval = funcEvalFunctionSet.resolveFunction(Arrays.copyOfRange(this.fArguments, 1, this.fArguments.length));
            }
            IBinding binding = null;
            if (funcEval instanceof EvalBinding) {
                EvalBinding funcEvalBinding = (EvalBinding)funcEval;
                binding = funcEvalBinding.getBinding();
            } else if (funcEval instanceof EvalMemberAccess) {
                EvalMemberAccess funcEvalMemberAccess = (EvalMemberAccess)funcEval;
                binding = funcEvalMemberAccess.getMember();
            }
            if (binding instanceof ICPPFunction) {
                function = (ICPPFunction)binding;
            }
        }
        return function;
    }

    private boolean isReference(IBinding binding) {
        return binding instanceof IVariable && (((IVariable)binding).getType() instanceof ICPPReferenceType || ((IVariable)binding).getType() instanceof IPointerType);
    }

    public static ActivationRecord createActivationRecord(ICPPParameter[] parameters, ICPPEvaluation[] arguments, ICPPEvaluation implicitThis) {
        ActivationRecord record = new ActivationRecord(parameters, implicitThis);
        int j = 1;
        ICPPParameter[] iCPPParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPParameter param = iCPPParameterArray[n2];
            if (param.isParameterPack() || EvalFunctionCall.isSpecializedParameterPack(param)) {
                int paramPackLen = arguments.length - j;
                ICPPEvaluation[] values = new ICPPEvaluation[paramPackLen];
                IType[] types = new IType[paramPackLen];
                int i = 0;
                while (i < paramPackLen) {
                    ICPPEvaluation arg;
                    values[i] = arg = arguments[j + i];
                    types[i] = arg.getType();
                    ++i;
                }
                CompositeValue paramPackValue = new CompositeValue(null, values);
                ParameterPackType paramPackType = new ParameterPackType(types);
                EvalFixed paramPack = new EvalFixed(paramPackType, IASTExpression.ValueCategory.PRVALUE, paramPackValue);
                record.update(param, paramPack);
                break;
            }
            if (j < arguments.length) {
                ICPPEvaluation argument = EvalFunctionCall.maybeApplyConversion(arguments[j++], param.getType(), false, true);
                record.update(param, argument);
            } else if (param.hasDefaultValue()) {
                IValue value = param.getDefaultValue();
                ICPPEvaluation eval = value.getEvaluation();
                if (eval == null) {
                    eval = new EvalFixed(param.getType(), IASTExpression.ValueCategory.PRVALUE, value);
                }
                record.update(param, eval);
            }
            ++n2;
        }
        return record;
    }

    private static boolean isSpecializedParameterPack(ICPPParameter param) {
        ICPPSpecialization paramSpecialization;
        IBinding specializedBinding;
        if (param instanceof ICPPSpecialization && (specializedBinding = (paramSpecialization = (ICPPSpecialization)((Object)param)).getSpecializedBinding()) instanceof ICPPParameter) {
            ICPPParameter specializedParam = (ICPPParameter)specializedBinding;
            return specializedParam.isParameterPack();
        }
        return false;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    ICPPFunctionType resolveFunctionType() {
        ICPPFunction function = this.resolveFunctionBinding();
        if (function != null) {
            return function.getType();
        }
        IType result = this.fArguments[0].getType();
        if (result instanceof IPointerType) {
            result = ((IPointerType)result).getType();
        } else if (result instanceof CPPClosureType) {
            result = ((CPPClosureType)result).getFunctionCallOperator().getType();
        }
        if (result instanceof ICPPFunctionType) {
            return (ICPPFunctionType)result;
        }
        return null;
    }

    @Override
    public boolean isNoexcept() {
        ICPPFunctionType fctType = this.resolveFunctionType();
        if (fctType != null && !EvalUtil.evaluateNoexceptSpecifier(fctType.getNoexceptSpecifier())) {
            return false;
        }
        int i = 1;
        while (i < this.fArguments.length) {
            ICPPEvaluation eval = this.fArguments[i];
            if (!eval.isNoexcept()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class ParameterPackType
    implements IType {
        private final IType[] types;

        public ParameterPackType(IType[] types) {
            this.types = types;
        }

        public IType[] getTypes() {
            return this.types;
        }

        @Override
        public boolean isSameType(IType type) {
            return false;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

