/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfProjectModelHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class TmfNavigatorContentProvider
implements IPipelinedTreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.getParent();
        }
        if (element instanceof TmfProjectElement) {
            IProject p = TmfProjectModelHelper.getProjectFromShadowProject(((TmfProjectElement)element).getResource());
            if (p != null && p.isAccessible()) {
                return p;
            }
            return ((TmfProjectElement)element).getResource();
        }
        if (element instanceof TmfTracesFolder) {
            IProject p;
            TmfTracesFolder folder = (TmfTracesFolder)element;
            if (folder.getParent() instanceof TmfProjectElement && (p = TmfProjectModelHelper.getProjectFromShadowProject(((TmfProjectElement)folder.getParent()).getResource())) != null && p.isAccessible()) {
                return folder.getParent();
            }
            return folder.getParent().getResource();
        }
        if (element instanceof TmfExperimentFolder) {
            IProject p;
            TmfExperimentFolder folder = (TmfExperimentFolder)element;
            if (folder.getParent() instanceof TmfProjectElement && (p = TmfProjectModelHelper.getProjectFromShadowProject(((TmfProjectElement)folder.getParent()).getResource())) != null && p.isAccessible()) {
                return folder.getParent();
            }
            return folder.getParent().getResource();
        }
        if (element instanceof ITmfProjectModelElement) {
            ITmfProjectModelElement modelElement = (ITmfProjectModelElement)element;
            return modelElement.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.isAccessible();
        }
        if (element instanceof ITmfProjectModelElement) {
            ITmfProjectModelElement modelElement = (ITmfProjectModelElement)element;
            return modelElement.hasChildren();
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public synchronized Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            IProject parentProject = (IProject)parentElement;
            if (TmfProjectElement.showProjectRoot(parentProject)) {
                if (TmfProjectModelHelper.shadowProjectAccessible(parentProject)) {
                    Object[] elements = new TmfProjectElement[]{TmfProjectRegistry.getProject(parentProject, true)};
                    return elements;
                }
                return new Object[0];
            }
            TmfProjectElement element = TmfProjectRegistry.getProject(parentProject, true);
            return element.getChildren().toArray();
        }
        if (parentElement instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)parentElement).getChildren().toArray();
        }
        return new Object[0];
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        TmfNavigatorContentProvider.customizeTmfElements(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        TmfNavigatorContentProvider.customizeTmfElements(this.getElements(input), currentElements);
    }

    private static void customizeTmfElements(Object[] elements, Set<Object> children) {
        if (elements != null && children != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof ITmfProjectModelElement) {
                    ITmfProjectModelElement tmfElement = (ITmfProjectModelElement)element;
                    IResource resource = tmfElement.getResource();
                    if (resource != null) {
                        children.remove(resource);
                    }
                    children.add(element);
                } else if (element != null) {
                    children.add(element);
                }
                ++n2;
            }
        }
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return anAddModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }
}

