/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.constraintgraph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.constraintgraph.ConstraintConfig;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ClaimNode;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.Constraint;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ConstraintGraphNode;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.EventNode;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.SrcSnkNode;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.ITrace;

public class ConstraintGraph {
    private final List<ConstraintGraphNode> nodes = new ArrayList<ConstraintGraphNode>();

    public ConstraintGraph(ITrace trace) {
        this(trace, ConstraintConfig.getDefault());
    }

    public ConstraintGraph(ITrace trace, ConstraintConfig config) {
        this(trace.getEvents(), trace.getDependencies(), config);
    }

    public ConstraintGraph(List<IEvent> events, ConstraintConfig config) {
        this(events, null, config);
    }

    public ConstraintGraph(List<IEvent> events, List<IDependency> deps, ConstraintConfig config) {
        if (events == null || config == null) {
            throw new IllegalArgumentException();
        }
        this.createNodeList(events, config.isAddSourceAndSink());
        if (config.isAddClaimLowerBoundConstraints() || config.isAddClaimUpperBoundConstraints()) {
            this.applyClaimDurations(config);
        }
        if (config.isApplyOrderingHeuristic()) {
            this.applyOrderHeuristic(config.getEpsilon());
        }
        if (config.isApplyNonElasticityHeuristic()) {
            this.applyNonElasticityConstraint(config.getFilter(), config.getPartitioningAttribute());
        }
        if (config.isUseDependencies()) {
            if (deps == null) {
                throw new IllegalArgumentException("dependencies not available");
            }
            this.applyDependencies(deps);
        }
        if (config.isAddSourceAndSink()) {
            this.addSourceAndSink();
        }
    }

    public final List<ConstraintGraphNode> getNodes() {
        return this.nodes;
    }

    public final int size() {
        return this.nodes.size();
    }

    public final int edgeSize() {
        int cnt = 0;
        for (ConstraintGraphNode n : this.nodes) {
            cnt += n.constraints().size();
        }
        return cnt;
    }

    private void createNodeList(List<IEvent> events, boolean addSourceAndSink) {
        int id = addSourceAndSink ? 1 : 0;
        for (IEvent event : events) {
            if (event instanceof IClaimEvent) {
                this.nodes.add(new ClaimNode(id, (IClaimEvent)event));
            } else {
                this.nodes.add(new EventNode(id, event));
            }
            ++id;
        }
        Collections.sort(this.nodes);
    }

    private void applyClaimDurations(ConstraintConfig cfg) {
        int i = 0;
        while (i < this.nodes.size()) {
            ConstraintGraphNode node = this.nodes.get(i);
            if (node instanceof ClaimNode && ((ClaimNode)node).isClaimStart()) {
                ClaimNode startNode = (ClaimNode)node;
                int j = this.findStartIndex(startNode, i);
                while (j < this.nodes.size()) {
                    ConstraintGraphNode nj = this.nodes.get(j);
                    if (nj instanceof ClaimNode && ((ClaimNode)nj).isClaimStop() && ((ClaimNode)nj).getClaim() == startNode.getClaim()) {
                        double duration = nj.timestamp() - startNode.timestamp();
                        if (cfg.isAddClaimLowerBoundConstraints()) {
                            startNode.addConstraint(nj, duration);
                        }
                        if (!cfg.isAddClaimUpperBoundConstraints()) break;
                        nj.addConstraint(startNode, -duration);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private int findStartIndex(ClaimNode n, int i) {
        boolean zeroDuration;
        IClaim c = n.getClaim();
        boolean bl = zeroDuration = c.getStartTime().doubleValue() == c.getEndTime().doubleValue();
        if (zeroDuration) {
            return 0;
        }
        return i + 1;
    }

    private void applyNonElasticityConstraint(Map<String, String> nonElasticGroupFilter, String nonElasticGroupPartitioning) {
        Collection<List<ConstraintGraphNode>> nonElasticCells = this.computeNonElasticGroups(nonElasticGroupFilter, nonElasticGroupPartitioning);
        for (List<ConstraintGraphNode> cell : nonElasticCells) {
            Collections.sort(cell);
            int i = 0;
            while (i < cell.size() - 1) {
                ConstraintGraphNode ei = cell.get(i);
                ConstraintGraphNode ej = cell.get(i + 1);
                double duration = ej.timestamp() - ei.timestamp();
                ei.addConstraint(ej, duration);
                ej.addConstraint(ei, -duration);
                ++i;
            }
        }
    }

    private Collection<List<ConstraintGraphNode>> computeNonElasticGroups(Map<String, String> nonElasticGroupFilter, String nonElasticGroupPartitioning) {
        HashMap<String, ArrayList<ConstraintGraphNode>> neg = new HashMap<String, ArrayList<ConstraintGraphNode>>();
        for (ConstraintGraphNode ce : this.nodes) {
            String pid;
            EventNode eventNode = (EventNode)ce;
            if (!ConstraintGraph.matches(eventNode, nonElasticGroupFilter) || (pid = eventNode.getEvent().getAttributeValue(nonElasticGroupPartitioning)) == null) continue;
            ArrayList<ConstraintGraphNode> cell = (ArrayList<ConstraintGraphNode>)neg.get(pid);
            if (cell == null) {
                cell = new ArrayList<ConstraintGraphNode>();
                neg.put(pid, cell);
            }
            cell.add(ce);
        }
        return neg.values();
    }

    private static boolean matches(EventNode ce, Map<String, String> filter) {
        if (filter != null && filter.size() > 0) {
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                String val = ce.getEvent().getAttributeValue(entry.getKey());
                if (entry.getValue().equals(val)) continue;
                return false;
            }
        }
        return true;
    }

    private void applyDependencies(List<IDependency> deps) {
        EventNode en;
        HashMap<IEvent, HashSet<IEvent>> succs = new HashMap<IEvent, HashSet<IEvent>>();
        for (IDependency dep : deps) {
            IEvent src = dep.getSrc();
            IEvent dst = dep.getDst();
            HashSet<IEvent> s = (HashSet<IEvent>)succs.get(src);
            if (s == null) {
                s = new HashSet<IEvent>();
                succs.put(src, s);
            }
            s.add(dst);
        }
        HashMap<IEvent, EventNode> eventMap = new HashMap<IEvent, EventNode>();
        for (ConstraintGraphNode node : this.nodes) {
            if (!(node instanceof EventNode)) continue;
            en = (EventNode)node;
            IEvent event = en.getEvent();
            eventMap.put(event, en);
        }
        for (ConstraintGraphNode node : this.nodes) {
            IEvent src;
            Set ss;
            if (!(node instanceof EventNode) || (ss = (Set)succs.get(src = (en = (EventNode)node).getEvent())) == null) continue;
            for (IEvent s : ss) {
                EventNode dst = (EventNode)eventMap.get(s);
                en.addConstraint(dst, 0.0);
            }
        }
    }

    private void applyOrderHeuristic(double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon must be at least 0");
        }
        ArrayList<ClaimNode> f = new ArrayList<ClaimNode>();
        for (ConstraintGraphNode v : this.nodes) {
            if (!(v instanceof ClaimNode)) continue;
            ClaimNode claimNode = (ClaimNode)v;
            if (claimNode.isClaimStart()) {
                for (ClaimNode w : f) {
                    if (epsilon != Double.POSITIVE_INFINITY && !(v.timestamp() - w.timestamp() <= epsilon)) continue;
                    w.addConstraint(v, 0.0);
                }
                continue;
            }
            if (!claimNode.isClaimStop()) continue;
            HashSet<ClaimNode> toRemove = new HashSet<ClaimNode>();
            for (ClaimNode claimNode2 : f) {
                for (Constraint succw : claimNode2.constraints()) {
                    ConstraintGraphNode s = succw.getDst();
                    if (!(s instanceof ClaimNode) || !((ClaimNode)s).isClaimStart() || ((ClaimNode)s).getClaim() != claimNode.getClaim()) continue;
                    toRemove.add(claimNode2);
                }
                if (epsilon == Double.POSITIVE_INFINITY || !(v.timestamp() - claimNode2.timestamp() > epsilon)) continue;
                toRemove.add(claimNode2);
            }
            for (ConstraintGraphNode constraintGraphNode : toRemove) {
                f.remove(constraintGraphNode);
            }
            f.add(claimNode);
        }
    }

    private void addSourceAndSink() {
        SrcSnkNode src = new SrcSnkNode(0, true);
        SrcSnkNode snk = new SrcSnkNode(this.nodes.size() + 1, false);
        for (ConstraintGraphNode e : this.nodes) {
            e.addConstraint(snk, 0.0);
        }
        for (ConstraintGraphNode e : this.nodes) {
            src.addConstraint(e, 0.0);
        }
        this.nodes.add(0, src);
        this.nodes.add(snk);
    }

    public final String toString() {
        StringBuilder b = new StringBuilder("ConstraintGraph[size=");
        b.append(this.nodes.size()).append("]:\n");
        for (ConstraintGraphNode e : this.nodes) {
            for (Constraint edge : e.constraints()) {
                if (edge.isClaimDurationConstraint()) continue;
                b.append("\t\t").append(edge).append("\n");
            }
        }
        return b.toString();
    }
}

