/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class HideAction
extends AbstractTraceViewAction {
    private final TracePart part;

    public HideAction(TraceView view, TracePart part) {
        super(view);
        this.part = part;
        this.setText("Show " + part.toString().toLowerCase());
    }

    public int getStyle() {
        return 2;
    }

    public boolean isEnabled() {
        switch (this.part) {
            case CLAIM: {
                return this.view.hasClaims(true);
            }
            case EVENT: {
                return this.view.hasEvents(false, true);
            }
            case DEPENDENCY: {
                return this.view.hasDependencies(true);
            }
            case SIGNAL: {
                return this.view.hasSignals(true);
            }
        }
        throw new IllegalStateException();
    }

    public boolean isChecked() {
        switch (this.part) {
            case CLAIM: {
                return this.viewCfg.showClaims();
            }
            case EVENT: {
                return this.viewCfg.showEvents();
            }
            case DEPENDENCY: {
                return this.viewCfg.showDependencies();
            }
            case SIGNAL: {
                return this.viewCfg.showSignals();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void doRun() throws TraceException {
        switch (this.part) {
            case CLAIM: {
                this.viewCfg.setShowClaims(!this.viewCfg.showClaims());
                break;
            }
            case EVENT: {
                this.viewCfg.setShowEvents(!this.viewCfg.showEvents());
                break;
            }
            case DEPENDENCY: {
                this.viewCfg.setShowDependencies(!this.viewCfg.showDependencies());
                break;
            }
            case SIGNAL: {
                this.viewCfg.setShowSignals(!this.viewCfg.showSignals());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.view.update();
    }
}

