/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl.check;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.mtl.AtomicProposition;
import org.eclipse.trace4cps.analysis.mtl.ExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlUtil;
import org.eclipse.trace4cps.analysis.mtl.State;
import org.eclipse.trace4cps.analysis.mtl.check.CompactExplanationTableImpl;
import org.eclipse.trace4cps.analysis.mtl.check.SingleFormulaChecker;
import org.eclipse.trace4cps.analysis.mtl.check.TabularExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLand;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLimply;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLnot;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLor;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLuntil;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.core.impl.Interval;

public final class RecursiveMemoizationChecker
implements SingleFormulaChecker {
    private List<? extends State> trace;
    private Set<InformativePrefix> log;
    private boolean interpretAsPrefix;
    private TabularExplanationTable l;
    private final Map<MtlFormula, Integer> idMap = new HashMap<MtlFormula, Integer>();
    private final Map<MtlFormula, Integer> depthMap = new HashMap<MtlFormula, Integer>();

    @Override
    public InformativePrefix check(List<? extends State> trace, MtlFormula phi, Set<InformativePrefix> log, boolean interpretAsPrefix) {
        this.trace = trace;
        this.log = log != null ? log : Collections.emptySet();
        this.interpretAsPrefix = interpretAsPrefix;
        List<MtlFormula> sub = MtlUtil.getSubformulas(phi);
        this.idMap.clear();
        int i = 0;
        for (MtlFormula f : sub) {
            this.idMap.put(f, i);
            ++i;
        }
        this.fillDepthMap(phi);
        this.l = new CompactExplanationTableImpl(trace, this.idMap);
        this.fillTable(phi, 0);
        InformativePrefix result = this.l.getValue(phi, 0);
        if (!this.log.contains((Object)result)) {
            this.l = null;
        }
        return result;
    }

    private int fillDepthMap(MtlFormula phi) {
        int max = 0;
        for (MtlFormula child : phi.getChildren()) {
            max = Math.max(max, this.fillDepthMap(child));
        }
        this.depthMap.put(phi, max);
        return max;
    }

    private int getDepth(MtlFormula phi) {
        Integer depth = this.depthMap.get(phi);
        if (depth != null) {
            return depth;
        }
        throw new IllegalStateException(phi + " not present in depth map");
    }

    @Override
    public ExplanationTable getExplanation() {
        return this.l;
    }

    private int fillTable(MtlFormula f, int i) {
        if (f instanceof AtomicProposition) {
            return this.fillAP((AtomicProposition)f, i);
        }
        if (f instanceof MTLnot) {
            return this.fillNot((MTLnot)f, i);
        }
        if (f instanceof MTLand) {
            return this.fillAnd((MTLand)f, i);
        }
        if (f instanceof MTLimply) {
            return this.fillImply((MTLimply)f, i);
        }
        if (f instanceof MTLor) {
            return this.fillOr((MTLor)f, i);
        }
        if (f instanceof MTLuntil) {
            return this.fillUntil((MTLuntil)f, i);
        }
        if (f instanceof StlFormula) {
            return this.fillStlSubformula((StlFormula)f, i);
        }
        throw new IllegalStateException("use of " + f.getClass().toString() + " constructs unsupported!");
    }

    private int fillAP(AtomicProposition f, int i) {
        int formulaIndex = this.idMap.get(f);
        if (this.trace.get(i).satisfies(f)) {
            this.l.put(formulaIndex, i, 1);
            return 1;
        }
        this.l.put(formulaIndex, i, 2);
        return 2;
    }

    private int fillStlSubformula(StlFormula f, int i) {
        int formulaIndex = this.idMap.get(f);
        double t = this.trace.get(i).getTimestamp().doubleValue();
        if (!PsopHelper.dom(f.getSignal()).contains(t)) {
            throw new IllegalStateException("incompatible time domain");
        }
        double rho = PsopHelper.valueAt(f.getSignal(), (Number)t).doubleValue();
        if (rho >= 0.0) {
            this.l.put(formulaIndex, i, 1);
            return 1;
        }
        this.l.put(formulaIndex, i, 2);
        return 2;
    }

    private int fillNot(MTLnot f, int i) {
        int childIndex = this.idMap.get(f.getChild());
        int formulaIndex = this.idMap.get(f);
        int v = this.l.get(childIndex, i);
        if (v == 0) {
            v = this.fillTable(f.getChild(), i);
        }
        return this.l.put(formulaIndex, i, RecursiveMemoizationChecker.not(v));
    }

    private int fillOr(MTLor f, int i) {
        MtlFormula f1 = f.getLeft();
        MtlFormula f2 = f.getRight();
        int v1 = this.l.get(this.idMap.get(f1), i);
        int v2 = this.l.get(this.idMap.get(f2), i);
        if (v1 == 0 && v2 == 0) {
            if (this.getDepth(f1) <= this.getDepth(f2)) {
                v1 = this.fillTable(f1, i);
            } else {
                v2 = this.fillTable(f2, i);
            }
        }
        if (v1 == 0 && v2 != 1) {
            v1 = this.fillTable(f1, i);
        } else if (v2 == 0 && v1 != 1) {
            v2 = this.fillTable(f2, i);
        }
        return this.l.put(this.idMap.get(f), i, RecursiveMemoizationChecker.or(v1, v2));
    }

    private int fillAnd(MTLand f, int i) {
        MtlFormula f1 = f.getLeft();
        MtlFormula f2 = f.getRight();
        int v1 = this.l.get(this.idMap.get(f1), i);
        int v2 = this.l.get(this.idMap.get(f2), i);
        if (v1 == 0 && v2 == 0) {
            if (this.getDepth(f1) <= this.getDepth(f2)) {
                v1 = this.fillTable(f1, i);
            } else {
                v2 = this.fillTable(f2, i);
            }
        }
        if (v1 == 0 && v2 != 2) {
            v1 = this.fillTable(f1, i);
        } else if (v2 == 0 && v1 != 2) {
            v2 = this.fillTable(f2, i);
        }
        return this.l.put(this.idMap.get(f), i, RecursiveMemoizationChecker.and(v1, v2));
    }

    private int fillImply(MTLimply f, int i) {
        MtlFormula f1 = f.getLeft();
        MtlFormula f2 = f.getRight();
        int v1 = this.l.get(this.idMap.get(f1), i);
        int v2 = this.l.get(this.idMap.get(f2), i);
        if (v1 == 0 && v2 == 0) {
            if (this.getDepth(f1) <= this.getDepth(f2)) {
                v1 = this.fillTable(f1, i);
            } else {
                v2 = this.fillTable(f2, i);
            }
        }
        if (v1 == 0 && v2 != 2) {
            v1 = this.fillTable(f1, i);
        } else if (v2 == 0 && v1 != 2) {
            v2 = this.fillTable(f2, i);
        }
        return this.l.put(this.idMap.get(f), i, RecursiveMemoizationChecker.implies(v1, v2));
    }

    private static int not(int v) {
        if (v == 1) {
            return 2;
        }
        if (v == 2) {
            return 1;
        }
        return 3;
    }

    private static int or(int v1, int v2) {
        if (v1 == 1 || v2 == 1) {
            return 1;
        }
        if (v1 == 2 && v2 == 2) {
            return 2;
        }
        return 3;
    }

    private static int and(int v1, int v2) {
        if (v1 == 1 && v2 == 1) {
            return 1;
        }
        if (v1 == 2 || v2 == 2) {
            return 2;
        }
        return 3;
    }

    private static int implies(int v1, int v2) {
        return RecursiveMemoizationChecker.or(RecursiveMemoizationChecker.not(v1), v2);
    }

    private int fillUntil(MTLuntil f, int i) {
        if (this.interpretAsPrefix) {
            return this.fillUntilEntry(f, i);
        }
        return this.fillUntilEntryFinite(f, i);
    }

    private int fillUntilEntry(MTLuntil f, int i) {
        double ti = this.trace.get(i).getTimestamp().doubleValue();
        double tn = this.trace.get(this.trace.size() - 1).getTimestamp().doubleValue();
        Interval interval = f.getInterval();
        int formulaIndex = this.idMap.get(f);
        int leftIndex = this.idMap.get(f.getLeft());
        int rightIndex = this.idMap.get(f.getRight());
        boolean c1 = false;
        boolean c11 = true;
        boolean c2 = true;
        boolean c22 = false;
        boolean c3 = interval.strictlySmallerThan(tn - ti);
        int j = i;
        while (j < this.trace.size()) {
            double tj = this.trace.get(j).getTimestamp().doubleValue();
            int r2 = this.l.get(rightIndex, j);
            if (r2 == 0) {
                r2 = this.fillTable(f.getRight(), j);
            }
            boolean bl = c1 = c1 || r2 == 1 && interval.contains(tj - ti) && c11;
            if (c1) {
                return this.l.put(formulaIndex, i, 1);
            }
            int r1 = this.l.get(leftIndex, j);
            if (r1 == 0) {
                r1 = this.fillTable(f.getLeft(), j);
            }
            c2 = c2 && (r2 == 2 || !interval.contains(tj - ti) || c22);
            c3 = c3 || r1 == 2;
            c11 = c11 && r1 == 1;
            boolean bl2 = c22 = c22 || r1 == 2;
            if ((c22 || j == this.trace.size() - 1 || interval.strictlySmallerThan(tj - ti)) && c2 && c3) {
                return this.l.put(formulaIndex, i, 2);
            }
            if (!(c11 && !interval.strictlySmallerThan(tj - ti) || c1 || c2)) {
                return this.l.put(formulaIndex, i, 3);
            }
            ++j;
        }
        return this.l.put(formulaIndex, i, 3);
    }

    private int fillUntilEntryFinite(MTLuntil f, int i) {
        double ti = this.trace.get(i).getTimestamp().doubleValue();
        Interval interval = f.getInterval();
        int formulaIndex = this.idMap.get(f);
        int leftIndex = this.idMap.get(f.getLeft());
        int rightIndex = this.idMap.get(f.getRight());
        boolean c1 = false;
        boolean c11 = true;
        int j = i;
        while (j < this.trace.size()) {
            double tj = this.trace.get(j).getTimestamp().doubleValue();
            int r2 = this.l.get(rightIndex, j);
            if (r2 == 0) {
                r2 = this.fillTable(f.getRight(), j);
            }
            boolean bl = c1 = c1 || r2 == 1 && interval.contains(tj - ti) && c11;
            if (c1) {
                return this.l.put(formulaIndex, i, 1);
            }
            int r1 = this.l.get(leftIndex, j);
            if (r1 == 0) {
                r1 = this.fillTable(f.getLeft(), j);
            }
            boolean bl2 = c11 = c11 && r1 == 1;
            if (!(c11 && j != this.trace.size() - 1 && !interval.strictlySmallerThan(tj - ti) || c1)) {
                return this.l.put(formulaIndex, i, 2);
            }
            ++j;
        }
        throw new IllegalStateException();
    }
}

