/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.impl.InnerClassNameVariants;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IShadowedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.util.Strings;

public class IndexedJvmTypeAccess {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    InnerClassNameVariants innerClassNameVariants;

    public boolean isIndexingPhase(Notifier notifier) {
        return this.compilerPhases.isIndexing(notifier);
    }

    public EObject getIndexedJvmType(URI javaObjectURI, ResourceSet resourceSet) throws UnknownNestedTypeException {
        return this.getIndexedJvmType(javaObjectURI, resourceSet, false);
    }

    public EObject getIndexedJvmType(URI javaObjectURI, ResourceSet resourceSet, boolean throwShadowedException) throws UnknownNestedTypeException {
        if (resourceSet != null) {
            String fqn;
            EObject result;
            Map resourceMap;
            URI withoutFragment = javaObjectURI.trimFragment();
            if (resourceSet instanceof ResourceSetImpl && (resourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap()) != null && resourceMap.containsKey(withoutFragment) && (result = resourceSet.getEObject(javaObjectURI, true)) != null) {
                return result;
            }
            String base = fqn = withoutFragment.segment(withoutFragment.segmentCount() - 1);
            Iterator<String> variants = this.innerClassNameVariants.variantsFor(base);
            EObject jvmType = null;
            while (jvmType == null && variants.hasNext()) {
                fqn = variants.next();
                List fqnSegments = Strings.split((String)fqn, (char)'.');
                QualifiedName qualifiedName = QualifiedName.create((List)fqnSegments);
                jvmType = this.getIndexedJvmType(qualifiedName, javaObjectURI.fragment(), resourceSet, throwShadowedException);
            }
            return jvmType;
        }
        return null;
    }

    public EObject getIndexedJvmType(QualifiedName qualifiedName, String fragment, ResourceSet resourceSet) throws UnknownNestedTypeException {
        return this.getIndexedJvmType(qualifiedName, fragment, resourceSet, false);
    }

    public EObject getIndexedJvmType(QualifiedName qualifiedName, String fragment, ResourceSet resourceSet, boolean throwShadowedException) throws UnknownNestedTypeException {
        if (resourceSet != null) {
            EObject result;
            IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
            Iterable candidates = descriptions.getExportedObjects(TypesPackage.Literals.JVM_TYPE, qualifiedName, false);
            Iterator<IEObjectDescription> iterator = candidates.iterator();
            if (iterator.hasNext() && (result = this.findAccessibleType(fragment, resourceSet, iterator)) != null) {
                return result;
            }
            if (throwShadowedException && descriptions instanceof IShadowedResourceDescriptions && ((IShadowedResourceDescriptions)descriptions).isShadowed(TypesPackage.Literals.JVM_TYPE, qualifiedName, false)) {
                throw new ShadowedTypeException("The type '" + qualifiedName + "' is locally shadowed.");
            }
        }
        return null;
    }

    protected EObject findAccessibleType(String fragment, ResourceSet resourceSet, Iterator<IEObjectDescription> fromIndex) throws UnknownNestedTypeException {
        IEObjectDescription description = fromIndex.next();
        return this.getAccessibleType(description, fragment, resourceSet);
    }

    protected EObject getAccessibleType(IEObjectDescription description, String fragment, ResourceSet resourceSet) throws UnknownNestedTypeException {
        EObject typeProxy = description.getEObjectOrProxy();
        if (typeProxy.eIsProxy()) {
            typeProxy = EcoreUtil.resolve((EObject)typeProxy, (ResourceSet)resourceSet);
        }
        if (!typeProxy.eIsProxy() && typeProxy instanceof JvmType) {
            if (fragment != null) {
                EObject result = this.resolveJavaObject((JvmType)typeProxy, fragment);
                if (result != null) {
                    return result;
                }
            } else {
                return typeProxy;
            }
        }
        return null;
    }

    public EObject resolveJavaObject(JvmType rootType, String fragment) throws UnknownNestedTypeException {
        if (fragment.endsWith("[]")) {
            return this.resolveJavaArrayObject(rootType, fragment);
        }
        int slash = fragment.indexOf(47);
        if (slash != -1) {
            if (slash == 0) {
                return null;
            }
            String containerFragment = fragment.substring(0, slash);
            EObject container = this.resolveJavaObject(rootType, containerFragment);
            if (container != null) {
                String parameterName = fragment.substring(slash + 1);
                if (container instanceof JvmTypeParameterDeclarator) {
                    JvmTypeParameterDeclarator executable = (JvmTypeParameterDeclarator)container;
                    for (JvmTypeParameter parameter : executable.getTypeParameters()) {
                        if (!parameter.getName().equals(parameterName)) continue;
                        return parameter;
                    }
                }
            }
        } else {
            if (rootType.getIdentifier().equals(fragment)) {
                return rootType;
            }
            if (!fragment.startsWith(rootType.getIdentifier())) {
                return null;
            }
            int rootNameLength = rootType.getIdentifier().length();
            char sep = fragment.charAt(rootNameLength);
            Iterator iter = Splitter.on((char)sep).split((CharSequence)fragment.substring(rootNameLength + 1)).iterator();
            JvmDeclaredType current = (JvmDeclaredType)rootType;
            while (iter.hasNext()) {
                String segment = (String)iter.next();
                Iterator<JvmDeclaredType> members = current.findAllNestedTypesByName(segment).iterator();
                if (members.hasNext()) {
                    current = members.next();
                    continue;
                }
                throw new UnknownNestedTypeException("Couldn't resolve nested type for " + rootType.getIdentifier() + " and fragment " + fragment);
            }
            return current;
        }
        return null;
    }

    public EObject resolveJavaArrayObject(JvmType rootType, String fragment) throws UnknownNestedTypeException {
        JvmComponentType component = (JvmComponentType)this.resolveJavaObject(rootType, fragment.substring(0, fragment.length() - 2));
        if (component == null) {
            return null;
        }
        return component.getArrayType();
    }

    public static class UnknownNestedTypeException
    extends RuntimeException {
        public UnknownNestedTypeException() {
        }

        public UnknownNestedTypeException(String message) {
            super(message);
        }
    }

    public static class ShadowedTypeException
    extends RuntimeException {
        public ShadowedTypeException() {
        }

        public ShadowedTypeException(String message) {
            super(message);
        }
    }
}

