/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.wizards;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IGrammarSource;
import org.eclipse.tm4e.core.registry.Registry;
import org.eclipse.tm4e.registry.GrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.widgets.GrammarInfoWidget;
import org.eclipse.tm4e.ui.internal.wizards.AbstractWizardPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

final class SelectGrammarWizardPage
extends AbstractWizardPage {
    private static final String PAGE_NAME = SelectGrammarWizardPage.class.getName();
    private static final String[] TEXTMATE_GRAMMAR_FILE_FILTERS = new String[]{"*.tmLanguage", "*.json", "*.YAML-tmLanguage", "*.yaml", "*.yml"};
    private Text grammarFileText = (Text)NullSafetyHelper.lazyNonNull();
    private GrammarInfoWidget grammarInfoWidget = (GrammarInfoWidget)((Object)NullSafetyHelper.lazyNonNull());

    protected SelectGrammarWizardPage() {
        super(PAGE_NAME);
        super.setTitle(TMUIMessages.SelectGrammarWizardPage_title);
        super.setDescription(TMUIMessages.SelectGrammarWizardPage_description);
    }

    @Override
    protected void createBody(Composite ancestor) {
        final Composite parent = new Composite(ancestor, 0);
        parent.setFont(parent.getFont());
        parent.setLayoutData((Object)new GridData(768));
        parent.setLayout((Layout)new GridLayout(2, false));
        this.grammarFileText = this.createText(parent, TMUIMessages.SelectGrammarWizardPage_file_label);
        this.grammarFileText.addListener(24, (Listener)this);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        Button browseFileSystemButton = new Button(buttons, 0);
        browseFileSystemButton.setText(TMUIMessages.Button_browse_FileSystem);
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell());
                dialog.setFilterExtensions(TEXTMATE_GRAMMAR_FILE_FILTERS);
                dialog.setFilterPath(SelectGrammarWizardPage.this.grammarFileText.getText());
                String result = dialog.open();
                if (result != null && !result.isEmpty()) {
                    SelectGrammarWizardPage.this.grammarFileText.setText(result);
                }
            }
        });
        Button browseWorkspaceButton = new Button(buttons, 0);
        browseWorkspaceButton.setText(TMUIMessages.Button_browse_Workspace);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - void declaration
             */
            public void widgetSelected(@Nullable SelectionEvent e) {
                Object object;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("TextMate grammar selection");
                dialog.setMessage("Select a TextMate grammar file:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.addFilter(new ViewerFilter(){

                    private boolean isGrammarFile(IFile file) {
                        Object ext = file.getFileExtension();
                        if (ext == null) {
                            return false;
                        }
                        ext = "*." + ((String)ext).toLowerCase();
                        String[] stringArray = TEXTMATE_GRAMMAR_FILE_FILTERS;
                        int n = TEXTMATE_GRAMMAR_FILE_FILTERS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pattern = stringArray[n2];
                            if (pattern.equals(ext)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    private boolean containsGrammarFile(IContainer container) {
                        try {
                            IResource[] iResourceArray = container.members();
                            int n = iResourceArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) {
                                    return false;
                                }
                                IResource member = iResourceArray[n2];
                                IResource iResource = member;
                                if (iResource instanceof IFile) {
                                    void file;
                                    IFile cfr_ignored_0 = (IFile)iResource;
                                    IFile cfr_ignored_1 = (IFile)iResource;
                                    if (this.isGrammarFile((IFile)file)) {
                                        return true;
                                    }
                                } else {
                                    IResource iResource2 = member;
                                    if (iResource2 instanceof IContainer) {
                                        void subContainer;
                                        IContainer cfr_ignored_2 = (IContainer)iResource2;
                                        IContainer cfr_ignored_3 = (IContainer)iResource2;
                                        if (this.containsGrammarFile((IContainer)subContainer)) {
                                            return true;
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NonNullByDefault(value={})
                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        Object object = element;
                        if (object instanceof IContainer) {
                            void container;
                            IContainer iContainer = (IContainer)object;
                            IContainer cfr_ignored_0 = (IContainer)object;
                            return this.containsGrammarFile((IContainer)container);
                        }
                        Object object2 = element;
                        if (object2 instanceof IFile) {
                            void file;
                            IFile iFile = (IFile)object2;
                            IFile cfr_ignored_1 = (IFile)object2;
                            return this.isGrammarFile((IFile)file);
                        }
                        return true;
                    }
                });
                if (dialog.open() == 0 && (object = dialog.getFirstResult()) instanceof IFile) {
                    void file;
                    IFile iFile = (IFile)object;
                    IFile cfr_ignored_0 = (IFile)object;
                    SelectGrammarWizardPage.this.grammarFileText.setText(file.getLocation().toOSString());
                }
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.grammarInfoWidget = new GrammarInfoWidget(parent, 0);
        this.grammarInfoWidget.setLayoutData(data);
    }

    private Text createText(Composite parent, String s) {
        Label label = new Label(parent, 0);
        label.setText(s);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    @Override
    protected void initializeDefaultValues() {
        this.setPageComplete(false);
    }

    @Override
    protected @Nullable IStatus validatePage(Event event) {
        this.grammarInfoWidget.refresh(null);
        String path = this.grammarFileText.getText();
        if (path.isEmpty()) {
            return new Status(4, "org.eclipse.tm4e.ui", TMUIMessages.SelectGrammarWizardPage_file_error_required);
        }
        Registry registry = new Registry();
        try {
            IGrammar grammar = registry.addGrammar(IGrammarSource.fromFile((Path)Paths.get(path, new String[0])));
            this.grammarInfoWidget.refresh(grammar);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.tm4e.ui", NLS.bind((String)TMUIMessages.SelectGrammarWizardPage_file_error_load, (Object)e.getMessage()), (Throwable)e);
        }
        return null;
    }

    IGrammarDefinition getGrammarDefinition() {
        return new GrammarDefinition(this.grammarInfoWidget.getScopeNameText().getText(), this.grammarFileText.getText());
    }
}

