/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.jcodings.specific.UTF8Encoding;

public abstract class OnigString {
    public final String content;
    public final int bytesCount;
    final byte[] bytesUTF8;

    public static OnigString of(String str) {
        byte[] bytesUtf8 = str.getBytes(StandardCharsets.UTF_8);
        if (bytesUtf8.length == str.length()) {
            return new SingleByteString(str, bytesUtf8);
        }
        return new MultiByteString(str, bytesUtf8);
    }

    private OnigString(String content, byte[] bytesUTF8) {
        this.content = content;
        this.bytesUTF8 = bytesUTF8;
        this.bytesCount = bytesUTF8.length;
    }

    protected final String throwOutOfBoundsException(String indexName, int index, int minIndex, int maxIndex) {
        throw new ArrayIndexOutOfBoundsException(indexName + " index " + index + " is out of range " + minIndex + ".." + maxIndex + " of " + String.valueOf(this));
    }

    abstract int getByteIndexOfChar(int var1);

    abstract int getCharIndexOfByte(int var1);

    public String toString() {
        return this.getClass().getSimpleName() + "[string=\"" + this.content + "\"]";
    }

    static final class MultiByteString
    extends OnigString {
        private int @Nullable [] byteToCharOffsets;
        private final int lastCharIndex;

        private MultiByteString(String str, byte[] bytesUTF8) {
            super(str, bytesUTF8);
            this.lastCharIndex = str.length() - 1;
        }

        @Override
        int getByteIndexOfChar(int charIndex) {
            if (charIndex == this.lastCharIndex + 1) {
                return this.bytesCount;
            }
            if (charIndex < 0 || charIndex > this.lastCharIndex) {
                this.throwOutOfBoundsException("Char", charIndex, 0, this.lastCharIndex);
            }
            if (charIndex == 0) {
                return 0;
            }
            int[] byteToCharOffsets = this.getByteToCharOffsets();
            int byteIndex = Arrays.binarySearch(byteToCharOffsets, charIndex);
            while (byteIndex > 0 && byteToCharOffsets[byteIndex - 1] == charIndex) {
                --byteIndex;
            }
            return byteIndex;
        }

        private int[] getByteToCharOffsets() {
            int[] offsets = this.byteToCharOffsets;
            if (offsets == null) {
                offsets = new int[this.bytesCount];
                int charIndex = 0;
                int byteIndex = 0;
                int maxByteIndex = this.bytesCount - 1;
                while (byteIndex <= maxByteIndex) {
                    int charLenInBytes = UTF8Encoding.INSTANCE.length(this.bytesUTF8, byteIndex, this.bytesCount);
                    int l = byteIndex + charLenInBytes;
                    while (byteIndex < l) {
                        offsets[byteIndex] = charIndex;
                        ++byteIndex;
                    }
                    ++charIndex;
                }
                this.byteToCharOffsets = offsets;
            }
            return offsets;
        }

        @Override
        int getCharIndexOfByte(int byteIndex) {
            if (byteIndex == this.bytesCount) {
                return this.lastCharIndex + 1;
            }
            if (byteIndex < 0 || byteIndex >= this.bytesCount) {
                this.throwOutOfBoundsException("Byte", byteIndex, 0, this.bytesCount - 1);
            }
            if (byteIndex == 0) {
                return 0;
            }
            return this.getByteToCharOffsets()[byteIndex];
        }
    }

    static final class SingleByteString
    extends OnigString {
        private SingleByteString(String str, byte[] bytesUTF8) {
            super(str, bytesUTF8);
        }

        @Override
        int getByteIndexOfChar(int charIndex) {
            if (charIndex == this.bytesCount) {
                return charIndex;
            }
            if (charIndex < 0 || charIndex >= this.bytesCount) {
                this.throwOutOfBoundsException("Char", charIndex, 0, this.bytesCount - 1);
            }
            return charIndex;
        }

        @Override
        int getCharIndexOfByte(int byteIndex) {
            if (byteIndex == this.bytesCount) {
                return byteIndex;
            }
            if (byteIndex < 0 || byteIndex >= this.bytesCount) {
                this.throwOutOfBoundsException("Byte", byteIndex, 0, this.bytesCount - 1);
            }
            return byteIndex;
        }
    }
}

