/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.tm4e.core.internal.utils.ScopeNames;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.ui.themes.ColorManager;
import org.eclipse.tm4e.ui.themes.ITokenProvider;

public abstract class AbstractTokenProvider
implements ITokenProvider {
    private final Map<IStyle, IToken> getJFaceTextTokenReturnValueCache = new HashMap<IStyle, IToken>();
    private final Map<String, IToken> getTokenReturnValueCache = new ConcurrentHashMap<String, IToken>();

    @Override
    public IToken getToken(String textMateTokenType) {
        if (textMateTokenType.isEmpty()) {
            return DEFAULT_TOKEN;
        }
        return this.getTokenReturnValueCache.computeIfAbsent(ScopeNames.withoutContributor((String)textMateTokenType), this::getTokenUncached);
    }

    protected IToken getTokenUncached(String textMateTokenType) {
        IStyle style = this.getBestStyle(textMateTokenType);
        if (style == null) {
            return DEFAULT_TOKEN;
        }
        return this.getJFaceTextToken(style);
    }

    protected IToken getJFaceTextToken(IStyle style) {
        return this.getJFaceTextTokenReturnValueCache.computeIfAbsent(style, this::getJFaceTextTokenUncached);
    }

    private IToken getJFaceTextTokenUncached(IStyle style) {
        @Nullable RGB styleFGColor = style.getColor();
        @Nullable RGB styleBGColor = style.getBackgroundColor();
        ColorManager colors = ColorManager.getInstance();
        return new Token((Object)new TextAttribute(styleFGColor == null ? null : colors.getColor(styleFGColor), styleBGColor == null ? null : colors.getColor(styleBGColor), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0) | (style.isUnderline() ? 0x40000000 : 0) | (style.isStrikeThrough() ? 0x20000000 : 0)));
    }

    protected abstract @Nullable IStyle getBestStyle(String var1);
}

