/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.text;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.ClassHelper;
import org.eclipse.tm4e.ui.model.ITMDocumentModel;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.ITokenProvider;

class Colorizer {
    private static final TextAttribute DEFAULT_TEXT_ATTRIBUTE = new TextAttribute(null);
    private final ITokenProvider theme;
    private final ITextViewer viewer;
    private final Set<ITMPresentationReconcilerListener> listeners;
    private boolean isViewerStyleColorsInitialized;
    private boolean isViewerHighlightColorInitialized;

    Colorizer(ITextViewer viewer, ITokenProvider theme, Set<ITMPresentationReconcilerListener> listeners) {
        this.viewer = viewer;
        this.theme = theme;
        this.listeners = listeners;
        this.applyThemeToViewer();
    }

    /*
     * WARNING - void declaration
     */
    void colorize(ModelTokensChangedEvent event) {
        IDocument doc = this.viewer.getDocument();
        if (doc == null) {
            return;
        }
        ITMModel iTMModel = event.model;
        if (iTMModel instanceof ITMDocumentModel) {
            ITMDocumentModel iTMDocumentModel = (ITMDocumentModel)iTMModel;
            ITMDocumentModel cfr_ignored_0 = (ITMDocumentModel)iTMModel;
            for (Range range : event.ranges) {
                try {
                    void docModel;
                    int length = doc.getLineOffset(range.toLineNumber - 1) + doc.getLineLength(range.toLineNumber - 1) - doc.getLineOffset(range.fromLineNumber - 1);
                    Region region = new Region(doc.getLineOffset(range.fromLineNumber - 1), length);
                    this.colorize((IRegion)region, (ITMDocumentModel)docModel);
                }
                catch (BadLocationException ex) {
                    TMUIPlugin.logError((Exception)((Object)ex));
                }
            }
        }
    }

    void colorize(IRegion damageRegion, ITMDocumentModel tmModel) throws BadLocationException {
        block12: {
            this.applyThemeToViewerIfNeeded();
            IDocument doc = tmModel.getDocument();
            int fromLineIndex = doc.getLineOfOffset(damageRegion.getOffset());
            int toLineIndex = doc.getLineOfOffset(damageRegion.getOffset() + damageRegion.getLength());
            if (TMUIPlugin.isLogTraceEnabled()) {
                TMUIPlugin.logTrace("Colorize lines from " + (fromLineIndex + 1) + " to " + (toLineIndex + 1));
            }
            TextPresentation presentation = new TextPresentation(damageRegion, 1000);
            Exception error = null;
            ITokenProvider theme = this.theme;
            try {
                try {
                    int lastStart = presentation.getExtent().getOffset();
                    int length = 0;
                    boolean firstToken = true;
                    IToken lastToken = Token.UNDEFINED;
                    TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
                    List tokens = null;
                    int lineIndex = fromLineIndex;
                    while (lineIndex <= toLineIndex) {
                        block14: {
                            block13: {
                                tokens = tmModel.getLineTokens(lineIndex);
                                if (tokens != null) break block13;
                                if (TMUIPlugin.isLogTraceEnabled()) {
                                    TMUIPlugin.logTrace("TextMate tokens not yet available for line " + lineIndex);
                                }
                                break block14;
                            }
                            int startLineOffset = doc.getLineOffset(lineIndex);
                            int i = 0;
                            while (i < tokens.size()) {
                                block17: {
                                    IToken token;
                                    int tokenStartIndex;
                                    TMToken nextToken;
                                    TMToken currentToken;
                                    block18: {
                                        block15: {
                                            block16: {
                                                currentToken = (TMToken)tokens.get(i);
                                                nextToken = i + 1 < tokens.size() ? (TMToken)tokens.get(i + 1) : null;
                                                tokenStartIndex = currentToken.startIndex;
                                                if (!this.isTokenBeforeRegion(currentToken, startLineOffset, damageRegion)) break block15;
                                                if (nextToken == null) break block16;
                                                if (this.isTokenBeforeRegion(nextToken, startLineOffset, damageRegion)) break block17;
                                                tokenStartIndex = damageRegion.getOffset() - startLineOffset;
                                                break block18;
                                            }
                                            tokenStartIndex = damageRegion.getOffset() - startLineOffset;
                                            token = theme == null ? ITokenProvider.DEFAULT_TOKEN : theme.getToken(currentToken.type);
                                            lastAttribute = this.getTokenTextAttribute(token);
                                            length += this.getTokenLength(tokenStartIndex, nextToken, lineIndex, doc);
                                            firstToken = false;
                                            break block17;
                                        }
                                        if (this.isTokenAfterRegion(currentToken, startLineOffset, damageRegion)) break;
                                    }
                                    token = theme == null ? ITokenProvider.DEFAULT_TOKEN : theme.getToken(currentToken.type);
                                    TextAttribute attribute = this.getTokenTextAttribute(token);
                                    if (lastAttribute.equals((Object)attribute)) {
                                        length += this.getTokenLength(tokenStartIndex, nextToken, lineIndex, doc);
                                        firstToken = false;
                                    } else {
                                        if (!firstToken) {
                                            this.addStyleRange(presentation, lastStart, length, lastAttribute);
                                        }
                                        firstToken = false;
                                        lastToken = token;
                                        lastAttribute = attribute;
                                        lastStart = tokenStartIndex + startLineOffset;
                                        length = this.getTokenLength(tokenStartIndex, nextToken, lineIndex, doc);
                                    }
                                }
                                ++i;
                            }
                        }
                        ++lineIndex;
                    }
                    length = Math.min(length, damageRegion.getOffset() + damageRegion.getLength() - lastStart);
                    this.addStyleRange(presentation, lastStart, length, lastAttribute);
                    this.viewer.changeTextPresentation(presentation, false);
                }
                catch (Exception ex) {
                    error = ex;
                    TMUIPlugin.logError(ex);
                    Exception err = error;
                    this.listeners.forEach(l -> l.onColorized(presentation, err));
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Exception err = error;
                this.listeners.forEach(l -> l.onColorized(presentation, err));
                throw throwable;
            }
            Exception err = error;
            this.listeners.forEach(l -> l.onColorized(presentation, err));
        }
    }

    private void addStyleRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        int style = attr.getStyle();
        int fontStyle = style & 3;
        StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
        styleRange.strikeout = (style & 0x20000000) != 0;
        styleRange.underline = (style & 0x40000000) != 0;
        styleRange.font = attr.getFont();
        presentation.addStyleRange(styleRange);
    }

    private void applyThemeToViewer() {
        this.isViewerStyleColorsInitialized = false;
        this.isViewerHighlightColorInitialized = false;
        this.applyThemeToViewerIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    private void applyThemeToViewerIfNeeded() {
        ITokenProvider iTokenProvider;
        if (!this.isViewerStyleColorsInitialized && (iTokenProvider = this.theme) instanceof ITheme) {
            void theTheme;
            ITheme iTheme = (ITheme)iTokenProvider;
            ITheme cfr_ignored_0 = (ITheme)iTokenProvider;
            StyledText styledText = this.viewer.getTextWidget();
            theTheme.initializeViewerColors(styledText);
            this.isViewerStyleColorsInitialized = true;
        }
        if (!this.isViewerHighlightColorInitialized) {
            try {
                PaintManager paintManager = (PaintManager)ClassHelper.getFieldValue(this.viewer, "fPaintManager", TextViewer.class);
                if (paintManager == null) {
                    return;
                }
                List painters = (List)ClassHelper.getFieldValue(paintManager, "fPainters", PaintManager.class);
                if (painters == null) {
                    return;
                }
                for (IPainter painter : painters) {
                    IPainter iPainter = painter;
                    if (!(iPainter instanceof CursorLinePainter)) continue;
                    CursorLinePainter cfr_ignored_1 = (CursorLinePainter)iPainter;
                    CursorLinePainter cfr_ignored_2 = (CursorLinePainter)iPainter;
                    Color background = this.theme.getEditorCurrentLineHighlight();
                    if (background != null) {
                        void cursorLinePainter;
                        cursorLinePainter.setHighlightColor(background);
                    }
                    this.isViewerHighlightColorInitialized = true;
                }
            }
            catch (Exception ex) {
                TMUIPlugin.logError(ex);
            }
        }
    }

    private boolean isTokenAfterRegion(TMToken token, int startLineOffset, IRegion damage) {
        return token.startIndex + startLineOffset >= damage.getOffset() + damage.getLength();
    }

    private boolean isTokenBeforeRegion(TMToken token, int startLineOffset, IRegion damage) {
        return token.startIndex + startLineOffset < damage.getOffset();
    }

    private int getTokenLength(int tokenStartIndex, @Nullable TMToken nextToken, int line, IDocument doc) throws BadLocationException {
        return nextToken == null ? doc.getLineLength(line) - tokenStartIndex : nextToken.startIndex - tokenStartIndex;
    }

    /*
     * WARNING - void declaration
     */
    private TextAttribute getTokenTextAttribute(IToken token) {
        TextAttribute textAttribute;
        Object object = token.getData();
        if (object instanceof TextAttribute) {
            void textAttr;
            TextAttribute textAttribute2 = (TextAttribute)object;
            TextAttribute cfr_ignored_0 = (TextAttribute)object;
            textAttribute = textAttr;
        } else {
            textAttribute = DEFAULT_TEXT_ATTRIBUTE;
        }
        return textAttribute;
    }

    ITextViewer getTextViewer() {
        return this.viewer;
    }
}

