/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.internal.grammar.AttributedScopeStack;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class StateStack
implements IStateStack {
    public static final StateStack NULL = new StateStack(null, RuleId.NO_RULE, 0, 0, false, null, null, null);
    private int _enterPos;
    private int _anchorPos;
    private final int depth;
    private final @Nullable StateStack parent;
    private final RuleId ruleId;
    final boolean beginRuleCapturedEOL;
    final @Nullable String endRule;
    final @Nullable AttributedScopeStack nameScopesList;
    final @Nullable AttributedScopeStack contentNameScopesList;

    StateStack(@Nullable StateStack parent, RuleId ruleId, int enterPos, int anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, @Nullable AttributedScopeStack nameScopesList, @Nullable AttributedScopeStack contentNameScopesList) {
        this.parent = parent;
        this.ruleId = ruleId;
        this.depth = this.parent != null ? this.parent.depth + 1 : 1;
        this._enterPos = enterPos;
        this._anchorPos = anchorPos;
        this.beginRuleCapturedEOL = beginRuleCapturedEOL;
        this.endRule = endRule;
        this.nameScopesList = nameScopesList;
        this.contentNameScopesList = contentNameScopesList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (object instanceof StateStack) {
            void otherState;
            StateStack stateStack = (StateStack)object;
            StateStack cfr_ignored_0 = (StateStack)object;
            return StateStack._equals(this, (StateStack)otherState);
        }
        return false;
    }

    private static boolean _equals(StateStack a, StateStack b) {
        if (a == b) {
            return true;
        }
        if (!StateStack._structuralEquals(a, b)) {
            return false;
        }
        return AttributedScopeStack.equals(a.contentNameScopesList, b.contentNameScopesList);
    }

    private static boolean _structuralEquals(@Nullable StateStack a, @Nullable StateStack b) {
        while (a != b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.depth != b.depth || !Objects.equals(a.ruleId, b.ruleId) || !Objects.equals(a.endRule, b.endRule)) {
                return false;
            }
            a = a.parent;
            b = b.parent;
        }
        return true;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int hashCode() {
        int result = 31 + Objects.hashCode(this.contentNameScopesList);
        result = 31 * result + Objects.hashCode(this.endRule);
        result = 31 * result + Objects.hashCode(this.parent);
        result = 31 * result + Objects.hashCode(this.ruleId);
        return 31 * result + this.depth;
    }

    void reset() {
        StateStack el = this;
        while (el != null) {
            el._enterPos = -1;
            el._anchorPos = -1;
            el = el.parent;
        }
    }

    @Nullable StateStack pop() {
        return this.parent;
    }

    StateStack safePop() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    StateStack push(RuleId ruleId, int enterPos, int anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, @Nullable AttributedScopeStack nameScopesList, @Nullable AttributedScopeStack contentNameScopesList) {
        return new StateStack(this, ruleId, enterPos, anchorPos, beginRuleCapturedEOL, endRule, nameScopesList, contentNameScopesList);
    }

    int getEnterPos() {
        return this._enterPos;
    }

    int getAnchorPos() {
        return this._anchorPos;
    }

    Rule getRule(IRuleRegistry grammar) {
        return grammar.getRule(this.ruleId);
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>();
        this._writeString(r);
        return "[" + String.join((CharSequence)", ", r) + "]";
    }

    private void _writeString(List<String> res) {
        if (this.parent != null) {
            this.parent._writeString(res);
        }
        res.add("(" + String.valueOf(this.ruleId) + ", " + String.valueOf(this.nameScopesList) + ", " + String.valueOf(this.contentNameScopesList) + ")");
    }

    StateStack withContentNameScopesList(@Nullable AttributedScopeStack contentNameScopesList) {
        if (Objects.equals(this.contentNameScopesList, contentNameScopesList)) {
            return this;
        }
        return NullSafetyHelper.castNonNull(this.parent).push(this.ruleId, this._enterPos, this._anchorPos, this.beginRuleCapturedEOL, this.endRule, this.nameScopesList, contentNameScopesList);
    }

    StateStack withEndRule(String endRule) {
        if (this.endRule != null && this.endRule.equals(endRule)) {
            return this;
        }
        return new StateStack(this.parent, this.ruleId, this._enterPos, this._anchorPos, this.beginRuleCapturedEOL, endRule, this.nameScopesList, this.contentNameScopesList);
    }

    boolean hasSameRuleAs(StateStack other) {
        StateStack el = this;
        while (el != null && el._enterPos == other._enterPos) {
            if (el.ruleId == other.ruleId) {
                return true;
            }
            el = el.parent;
        }
        return false;
    }

    Frame toStateStackFrame() {
        AttributedScopeStack nameScopesList = this.nameScopesList;
        AttributedScopeStack contentNameScopesList = this.contentNameScopesList;
        StateStack parent = this.parent;
        return new Frame(this.ruleId, null, null, this.beginRuleCapturedEOL, this.endRule, nameScopesList != null ? nameScopesList.getExtensionIfDefined(parent != null ? parent.nameScopesList : null) : Collections.emptyList(), contentNameScopesList != null ? contentNameScopesList.getExtensionIfDefined(this.nameScopesList) : Collections.emptyList());
    }

    public static StateStack pushFrame(@Nullable StateStack self, Frame frame) {
        AttributedScopeStack namesScopeList = AttributedScopeStack.fromExtension(self == null ? null : self.nameScopesList, frame.nameScopesList);
        Integer enterPos = frame.enterPos;
        Integer anchorPos = frame.anchorPos;
        return new StateStack(self, frame.ruleId, enterPos == null ? -1 : enterPos, anchorPos == null ? -1 : anchorPos, frame.beginRuleCapturedEOL, frame.endRule, namesScopeList, AttributedScopeStack.fromExtension(namesScopeList, frame.contentNameScopesList));
    }

    @NonNullByDefault(value={})
    record Frame(RuleId ruleId, @Nullable Integer enterPos, @Nullable Integer anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, List<AttributedScopeStack.Frame> nameScopesList, List<AttributedScopeStack.Frame> contentNameScopesList) {
    }
}

