/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class PreferenceSettingStore
implements ISettingsStore {
    private final String fPrefix;
    private final Preferences fPreferences;

    public PreferenceSettingStore(Preferences preferences, String prefix) {
        this.fPreferences = preferences;
        this.fPrefix = prefix;
    }

    public String get(String key) {
        return this.fPreferences.getString(this.makeKey(key));
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        return value;
    }

    public void put(String key, String value) {
        this.fPreferences.setValue(this.makeKey(key), value);
    }

    private String makeKey(String key) {
        return String.valueOf(this.fPrefix) + key;
    }
}

