/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.tests.core.IRSETestLogCollectorDelegate;
import org.eclipse.rse.tests.internal.RSEDefaultTestLogCollectorDelegate;
import org.eclipse.rse.tests.internal.testsubsystem.TestSubSystemAdapterFactory;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystem;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemConfiguration;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNode;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.osgi.framework.BundleContext;

public class RSETestsPlugin
extends SystemBasePlugin {
    private static RSETestsPlugin plugin;
    private ResourceBundle resourceBundle;
    private final List logCollectorDelegates = new ArrayList();
    private final IRSETestLogCollectorDelegate defaultLogCollectorDelegate = new RSEDefaultTestLogCollectorDelegate();

    public RSETestsPlugin() {
        plugin = this;
    }

    public static RSETestsPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle != null) {
            return this.resourceBundle;
        }
        this.resourceBundle = ResourceBundle.getBundle("org.eclipse.rse.tests.RSETestsResources");
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        assert (key != null);
        ResourceBundle bundle = RSETestsPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('!') + key + '!';
    }

    public static String getResourceString(String key, Object argument) {
        assert (argument != null);
        return RSETestsPlugin.getResourceString(key, new Object[]{argument});
    }

    public static String getResourceString(String key, Object[] arguments) {
        assert (arguments != null);
        String resourceString = RSETestsPlugin.getResourceString(key);
        if (!resourceString.startsWith("!")) {
            return MessageFormat.format(resourceString, arguments);
        }
        return resourceString;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.addDelegate(this.defaultLogCollectorDelegate);
        IAdapterManager manager = Platform.getAdapterManager();
        TestSubSystemAdapterFactory subSystemAdapterFactory = new TestSubSystemAdapterFactory();
        manager.registerAdapters((IAdapterFactory)subSystemAdapterFactory, ITestSubSystem.class);
        manager.registerAdapters((IAdapterFactory)subSystemAdapterFactory, ITestSubSystemNode.class);
        manager.registerAdapters((IAdapterFactory)subSystemAdapterFactory, ITestSubSystemConfiguration.class);
    }

    public void stop(BundleContext context) throws Exception {
        this.removeDelegate(this.defaultLogCollectorDelegate);
        super.stop(context);
    }

    public static boolean isTestCaseEnabled(String testId) {
        assert (testId != null);
        String value = System.getProperty(testId);
        if (value != null) {
            return Boolean.getBoolean(value);
        }
        value = RSETestsPlugin.getResourceString(testId);
        if (value != null && !value.startsWith("!")) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public synchronized void addDelegate(IRSETestLogCollectorDelegate delegate) {
        assert (delegate != null);
        if (delegate != null && !this.logCollectorDelegates.contains(delegate)) {
            this.logCollectorDelegates.add(delegate);
        }
    }

    public synchronized void removeDelegate(IRSETestLogCollectorDelegate delegate) {
        assert (delegate != null);
        if (delegate != null) {
            this.logCollectorDelegates.remove(delegate);
        }
    }

    public synchronized IRSETestLogCollectorDelegate[] getTestLogCollectorDelegates() {
        return this.logCollectorDelegates.toArray(new IRSETestLogCollectorDelegate[this.logCollectorDelegates.size()]);
    }

    protected void initializeImageRegistry() {
        String path = RSETestsPlugin.getIconPath();
        this.putImageInRegistry("ICON_ID_BRANCH", String.valueOf(path) + "branch.gif");
        this.putImageInRegistry("ICON_ID_LEAF", String.valueOf(path) + "leaf.gif");
    }
}

