/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.AbstractRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;

public class RSESystemType
extends AbstractRSESystemType {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_ICONLIVE = "iconLive";
    private static final String ATTR_ENABLEOFFLINE = "enableOffline";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_SUBSYSTEMCONFIGURATIONS = "subsystemConfigurationIds";
    private String[] subsystemConfigurationIds;

    public RSESystemType(IConfigurationElement element) {
        String enableOffline;
        String iconLive;
        this.id = element.getAttribute(ATTR_ID);
        this.name = element.getAttribute(ATTR_NAME);
        if (this.id == null) {
            RSECorePlugin.getDefault().getLogger().logWarning("RSE: System Type \"" + this.name + "\" does not define an ID");
            this.id = this.name;
        }
        this.label = element.getAttribute(ATTR_LABEL);
        this.description = element.getAttribute(ATTR_DESCRIPTION);
        this.loadProperties(element);
        String icon = element.getAttribute(ATTR_ICON);
        if (icon != null) {
            this.properties.put(ATTR_ICON, icon);
        }
        if ((iconLive = element.getAttribute(ATTR_ICONLIVE)) != null) {
            this.properties.put(ATTR_ICONLIVE, iconLive);
        }
        if ((enableOffline = element.getAttribute(ATTR_ENABLEOFFLINE)) != null) {
            this.properties.put(ATTR_ENABLEOFFLINE, enableOffline);
        }
        this.definingBundle = Platform.getBundle((String)element.getContributor().getName());
        LinkedList<String> subsystemConfigs = new LinkedList<String>();
        String attribute = element.getAttribute(ATTR_SUBSYSTEMCONFIGURATIONS);
        if (attribute != null) {
            String[] splitted = attribute.split(";");
            int i = 0;
            while (i < splitted.length) {
                subsystemConfigs.add(splitted[i].trim());
                ++i;
            }
        }
        this.subsystemConfigurationIds = subsystemConfigs.toArray(new String[subsystemConfigs.size()]);
    }

    private void loadProperties(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        this.properties = new HashMap(children.length);
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String key = child.getAttribute(ATTR_NAME);
            String value = child.getAttribute(ATTR_VALUE);
            if (key != null && value != null) {
                this.properties.put(key, value);
            }
            ++i;
        }
    }

    public String[] getSubsystemConfigurationIds() {
        return this.subsystemConfigurationIds;
    }
}

