/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html;

import java.io.IOException;
import java.io.Reader;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.NodePage;
import org.jacoco.report.internal.html.ReportPage;
import org.jacoco.report.internal.html.SourceHighlighter;

public class SourceFilePage
extends NodePage {
    private Reader sourceReader;
    private final String packageName;
    private final ISourceNode source;

    public SourceFilePage(ISourceFileCoverage sourceFileNode, ReportPage parent, ReportOutputFolder folder, IHTMLReportContext context) {
        super(sourceFileNode, parent, folder, context);
        this.packageName = sourceFileNode.getPackageName();
        this.source = sourceFileNode;
    }

    public IReportVisitor visitChild(ICoverageNode node) {
        throw new AssertionError((Object)"Source don't have child nodes.");
    }

    public void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
        this.sourceReader = sourceFileLocator.getSourceFile(this.packageName, this.getNode().getName());
        if (this.sourceReader != null) {
            super.visitEnd(sourceFileLocator);
        }
    }

    protected void content(HTMLElement body) throws IOException {
        SourceHighlighter hl = new SourceHighlighter(this.context.getLocale());
        hl.render(body, this.source, this.sourceReader);
        this.sourceReader.close();
    }

    protected void headExtra(HTMLElement head) throws IOException {
        super.headExtra(head);
        head.link("stylesheet", this.context.getResources().getLink(this.folder, "prettify.css"), "text/css");
        head.script("text/javascript", this.context.getResources().getLink(this.folder, "prettify.js"));
    }

    protected String getOnload() {
        return "prettyPrint()";
    }

    protected String getFileName() {
        return this.getNode().getName() + ".html";
    }

    public boolean exists() {
        return this.sourceReader != null;
    }
}

