/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseTestRunner
implements TestListener {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private static final String SUITE_METHODNAME = "suite";
    private TestResult fTestResult;
    private String fTestPluginName;
    private Test fSuite;
    private static Vector<JUnitResultFormatter> fgFromCmdLine = new Vector();
    private Vector<JUnitResultFormatter> formatters = new Vector();
    private boolean fHaltOnError = false;
    private boolean fHaltOnFailure = false;
    private JUnitTest fJunitTest;
    private PrintStream fSystemError;
    private PrintStream fSystemOut;
    private Exception fException;
    private int fRetCode = 0;

    public static void main(String[] args) throws IOException {
        System.exit(EclipseTestRunner.run(args));
    }

    public static int run(String[] args) throws IOException {
        String className = null;
        String classesNames = null;
        String testPluginName = null;
        String testPluginsNames = null;
        String formatterString = null;
        boolean haltError = false;
        boolean haltFail = false;
        Properties props = new Properties();
        int startArgs = 0;
        if (args.length > 0 && !args[0].startsWith("-")) {
            className = args[0];
            ++startArgs;
        }
        int i = startArgs;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("-classname")) {
                if (i < args.length - 1) {
                    className = args[i + 1];
                }
                ++i;
            } else if (args[i].toLowerCase().equals("-classesnames")) {
                if (i < args.length - 1) {
                    classesNames = args[i + 1];
                }
                ++i;
            } else if (args[i].toLowerCase().equals("-testpluginname")) {
                if (i < args.length - 1) {
                    testPluginName = args[i + 1];
                }
                ++i;
            } else if (args[i].toLowerCase().equals("-testpluginsnames")) {
                if (i < args.length - 1) {
                    testPluginsNames = args[i + 1];
                }
                ++i;
            } else if (args[i].startsWith("haltOnError=")) {
                haltError = Project.toBoolean((String)args[i].substring(12));
            } else if (args[i].startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean((String)args[i].substring(14));
            } else if (args[i].startsWith("formatter=")) {
                formatterString = args[i].substring(10);
            } else if (args[i].startsWith("propsfile=")) {
                FileInputStream in = new FileInputStream(args[i].substring(10));
                props.load(in);
                in.close();
            } else {
                if (args[i].equals("-testlistener")) {
                    System.err.println("The -testlistener option is no longer supported\nuse the formatter= option instead");
                    return 2;
                }
                if (args[i].equals("-timeout")) {
                    if (i < args.length - 1) {
                        EclipseTestRunner.startStackDumpTimoutTimer(args[i + 1]);
                    }
                    ++i;
                }
            }
            ++i;
        }
        Properties p = System.getProperties();
        Enumeration _enum = ((Hashtable)p).keys();
        while (_enum.hasMoreElements()) {
            Object key = _enum.nextElement();
            props.put(key, ((Hashtable)p).get(key));
        }
        if (testPluginsNames != null && classesNames != null) {
            String[] testPlugins = testPluginsNames.split(",");
            String[] suiteClasses = classesNames.split(",");
            try {
                EclipseTestRunner.createAndStoreFormatter(formatterString, suiteClasses);
            }
            catch (BuildException be) {
                System.err.println(be.getMessage());
                return 2;
            }
            int returnCode = 0;
            int j = 0;
            String[] stringArray = suiteClasses;
            int n = suiteClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String oneClassName = stringArray[n2];
                JUnitTest t = new JUnitTest(oneClassName);
                t.setProperties((Hashtable)props);
                EclipseTestRunner runner = new EclipseTestRunner(t, testPlugins[j], haltError, haltFail);
                EclipseTestRunner.transferFormatters(runner, j);
                runner.run();
                ++j;
                if (runner.getRetCode() != 0) {
                    returnCode = runner.getRetCode();
                }
                ++n2;
            }
            return returnCode;
        }
        try {
            EclipseTestRunner.createAndStoreFormatter(formatterString);
        }
        catch (BuildException be) {
            System.err.println(be.getMessage());
            return 2;
        }
        if (className == null) {
            throw new IllegalArgumentException("Test class name not specified");
        }
        JUnitTest t = new JUnitTest(className);
        t.setProperties((Hashtable)props);
        EclipseTestRunner runner = new EclipseTestRunner(t, testPluginName, haltError, haltFail);
        EclipseTestRunner.transferFormatters(runner);
        runner.run();
        return runner.getRetCode();
    }

    private static void startStackDumpTimoutTimer(final String timeoutArg) {
        try {
            int delay = 30000;
            int timeout = Integer.parseInt(timeoutArg) - delay;
            if (timeout > 0) {
                new Timer("EclipseTestRunnerTimer", true).schedule(new TimerTask(){

                    public void run() {
                        this.dump();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.dump();
                    }

                    private void dump() {
                        System.err.println("EclipseTestRunner almost reached timeout '" + timeoutArg + "'.");
                        System.err.println("totalMemory: " + Runtime.getRuntime().totalMemory());
                        System.err.println("freeMemory (before GC): " + Runtime.getRuntime().freeMemory());
                        System.gc();
                        System.err.println("freeMemory (after GC):  " + Runtime.getRuntime().freeMemory());
                        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").format(new Date());
                        System.err.println("Thread dump at " + time + ":");
                        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
                        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                            String name = entry.getKey().getName();
                            StackTraceElement[] stack = entry.getValue();
                            Exception exception = new Exception(name);
                            exception.setStackTrace(stack);
                            exception.printStackTrace();
                        }
                        final Display display = Display.getDefault();
                        display.syncExec(new Runnable(){

                            public void run() {
                                Shell[] shells;
                                Control focusControl = display.getFocusControl();
                                if (focusControl != null) {
                                    System.err.println("FocusControl: ");
                                    StringBuilder indent = new StringBuilder("  ");
                                    do {
                                        System.err.println(String.valueOf(indent.toString()) + focusControl);
                                        focusControl = focusControl.getParent();
                                        indent.append("  ");
                                    } while (focusControl != null);
                                }
                                if ((shells = display.getShells()).length > 0) {
                                    System.err.println("Shells: ");
                                    int i = 0;
                                    while (i < shells.length) {
                                        Shell shell = shells[i];
                                        System.err.println(String.valueOf(shell.isVisible() ? "  visible: " : "  invisible: ") + shell);
                                        ++i;
                                    }
                                }
                            }
                        });
                    }
                }, timeout);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public EclipseTestRunner(JUnitTest test, String testPluginName, boolean haltOnError, boolean haltOnFailure) {
        this.fJunitTest = test;
        this.fTestPluginName = testPluginName;
        this.fHaltOnError = haltOnError;
        this.fHaltOnFailure = haltOnFailure;
        try {
            this.fSuite = this.getTest(test.getName());
        }
        catch (Exception e) {
            this.fRetCode = 2;
            this.fException = e;
        }
    }

    protected Test getTest(String suiteClassName) throws TestFailedException {
        if (suiteClassName.length() <= 0) {
            this.clearStatus();
            return null;
        }
        Class<?> testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (ClassNotFoundException e) {
            String clazz;
            if (e.getCause() != null) {
                this.runFailed(e.getCause());
            }
            if ((clazz = e.getMessage()) == null) {
                clazz = suiteClassName;
            }
            this.runFailed("Class not found \"" + clazz + "\"");
            return null;
        }
        catch (Exception e) {
            this.runFailed(e);
            return null;
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.clearStatus();
            Class<?> jUnit4TestAdapterClass = null;
            try {
                jUnit4TestAdapterClass = this.loadSuiteClass("junit.framework.JUnit4TestAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {}
            if (jUnit4TestAdapterClass != null) {
                try {
                    Constructor<?> jUnit4TestAdapterCtor = jUnit4TestAdapterClass.getConstructor(Class.class);
                    return (Test)jUnit4TestAdapterCtor.newInstance(testClass);
                }
                catch (Exception e1) {
                    this.runFailed(new InvocationTargetException(e1, "Failed to create a JUnit4TestAdapter for \"" + suiteClassName + "\":"));
                    return null;
                }
            }
            return new TestSuite(testClass);
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            this.runFailed("suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException e) {
            this.runFailed("Failed to invoke suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed("Failed to invoke suite():" + e.toString());
            return null;
        }
        this.clearStatus();
        return test;
    }

    protected void runFailed(String message) throws TestFailedException {
        System.err.println(message);
        throw new TestFailedException(message);
    }

    protected void runFailed(Throwable e) throws TestFailedException {
        e.printStackTrace();
        throw new TestFailedException(e);
    }

    protected void clearStatus() {
    }

    protected Class<?> loadSuiteClass(String suiteClassName) throws ClassNotFoundException {
        if (this.fTestPluginName == null) {
            return Class.forName(suiteClassName);
        }
        Bundle bundle = Platform.getBundle((String)this.fTestPluginName);
        if (bundle == null) {
            throw new ClassNotFoundException(suiteClassName, new Exception("Could not find plugin \"" + this.fTestPluginName + "\""));
        }
        Dictionary headers = bundle.getHeaders();
        String hostHeader = (String)headers.get("Fragment-Host");
        if (hostHeader != null) {
            Bundle host;
            ManifestElement[] hostElement = null;
            try {
                hostElement = ManifestElement.parseHeader((String)"Fragment-Host", (String)hostHeader);
            }
            catch (BundleException e) {
                throw new RuntimeException("Could not find host for fragment:" + this.fTestPluginName, e);
            }
            bundle = host = Platform.getBundle((String)hostElement[0].getValue());
        }
        return bundle.loadClass(suiteClassName);
    }

    public void run() {
        this.fTestResult = new TestResult();
        this.fTestResult.addListener((TestListener)this);
        int i = 0;
        while (i < this.formatters.size()) {
            this.fTestResult.addListener((TestListener)this.formatters.elementAt(i));
            ++i;
        }
        long start = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.fException != null) {
            int i2 = 0;
            while (i2 < this.formatters.size()) {
                this.formatters.elementAt(i2).addError(null, (Throwable)this.fException);
                ++i2;
            }
            this.fJunitTest.setCounts(1L, 0L, 1L);
            this.fJunitTest.setRunTime(0L);
        } else {
            ByteArrayOutputStream errStrm = new ByteArrayOutputStream();
            this.fSystemError = new PrintStream(errStrm);
            ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
            this.fSystemOut = new PrintStream(outStrm);
            try {
                this.fSuite.run(this.fTestResult);
            }
            finally {
                this.fSystemError.close();
                this.fSystemError = null;
                this.fSystemOut.close();
                this.fSystemOut = null;
                this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                this.fJunitTest.setCounts((long)this.fTestResult.runCount(), (long)this.fTestResult.failureCount(), (long)this.fTestResult.errorCount());
                this.fJunitTest.setRunTime(System.currentTimeMillis() - start);
            }
        }
        this.fireEndTestSuite();
        if (this.fRetCode != 0 || this.fTestResult.errorCount() != 0) {
            this.fRetCode = 2;
        } else if (this.fTestResult.failureCount() != 0) {
            this.fRetCode = 1;
        }
    }

    public int getRetCode() {
        return this.fRetCode;
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
        if (this.fHaltOnFailure) {
            this.fTestResult.stop();
        }
    }

    public void addError(Test test, Throwable t) {
        if (this.fHaltOnError) {
            this.fTestResult.stop();
        }
    }

    private void fireStartTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            this.formatters.elementAt(i).startTestSuite(this.fJunitTest);
            ++i;
        }
    }

    private void fireEndTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            this.formatters.elementAt(i).endTestSuite(this.fJunitTest);
            ++i;
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        String formatterClassName = null;
        File formatterFile = null;
        int pos = line.indexOf(44);
        if (pos == -1) {
            formatterClassName = line;
        } else {
            formatterClassName = line.substring(0, pos);
            formatterFile = new File(line.substring(pos + 1));
        }
        fgFromCmdLine.addElement(EclipseTestRunner.createFormatter(formatterClassName, formatterFile));
    }

    private static void createAndStoreFormatter(String line, String ... suiteClassesNames) throws BuildException {
        String formatterClassName = null;
        File formatterFile = null;
        int pos = line.indexOf(44);
        formatterClassName = pos == -1 ? line : line.substring(0, pos);
        File outputDirectory = new File(line.substring(pos + 1));
        outputDirectory.mkdir();
        String[] stringArray = suiteClassesNames;
        int n = suiteClassesNames.length;
        int n2 = 0;
        while (n2 < n) {
            String suiteClassName = stringArray[n2];
            String pathname = "TEST-" + suiteClassName + ".xml";
            if (outputDirectory != null && outputDirectory.exists()) {
                pathname = String.valueOf(outputDirectory.getAbsolutePath()) + "/" + pathname;
            }
            formatterFile = new File(pathname);
            fgFromCmdLine.addElement(EclipseTestRunner.createFormatter(formatterClassName, formatterFile));
            ++n2;
        }
    }

    private static void transferFormatters(EclipseTestRunner runner, int j) {
        runner.addFormatter(fgFromCmdLine.elementAt(j));
    }

    private static void transferFormatters(EclipseTestRunner runner) {
        int i = 0;
        while (i < fgFromCmdLine.size()) {
            runner.addFormatter(fgFromCmdLine.elementAt(i));
            ++i;
        }
    }

    private static JUnitResultFormatter createFormatter(String classname, File outfile) throws BuildException {
        OutputStream out = System.out;
        if (classname == null) {
            throw new BuildException("you must specify type or classname");
        }
        Class<?> f = null;
        try {
            f = EclipseTestRunner.class.getClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        Object o = null;
        try {
            o = f.newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        if (!(o instanceof JUnitResultFormatter)) {
            throw new BuildException(String.valueOf(classname) + " is not a JUnitResultFormatter");
        }
        JUnitResultFormatter r = o;
        if (outfile != null) {
            try {
                out = new FileOutputStream(outfile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        r.setOutput(out);
        return r;
    }

    private void sendOutAndErr(String out, String err) {
        int i = 0;
        while (i < this.formatters.size()) {
            JUnitResultFormatter formatter = this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
            ++i;
        }
    }

    protected void handleOutput(String line) {
        if (this.fSystemOut != null) {
            this.fSystemOut.println(line);
        }
    }

    protected void handleErrorOutput(String line) {
        if (this.fSystemError != null) {
            this.fSystemError.println(line);
        }
    }

    class TestFailedException
    extends Exception {
        private static final long serialVersionUID = 6009335074727417445L;

        TestFailedException(String message) {
            super(message);
        }

        TestFailedException(Throwable e) {
            super(e);
        }
    }
}

