/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.registries;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.tests.core.RSECoreTestCase;

public class SubSystemInterfacesTest
extends RSECoreTestCase {
    public void testSubSystemFinding() {
        if (this.isTestDisabled()) {
            return;
        }
        try {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            SubSystemInterfacesTest.assertNotNull((String)"system registry not found", (Object)registry);
            ISystemProfileManager profileManager = registry.getSystemProfileManager();
            ISystemProfile profile = profileManager.createSystemProfile("profile1", true);
            IRSESystemType systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.unix");
            IHost host = registry.createHost(profile.getName(), systemType, "host1", "localhost", "host1", true);
            ISubSystem[] subsystems = registry.getSubSystems(host);
            int n = subsystems.length;
            subsystems = registry.getSubsystems(host, ISubSystem.class);
            SubSystemInterfacesTest.assertEquals((int)n, (int)subsystems.length);
            subsystems = registry.getSubsystems(host, IRemoteFileSubSystem.class);
            SubSystemInterfacesTest.assertEquals((int)1, (int)subsystems.length);
            subsystems = registry.getSubsystems(host, IRemoteProcessSubSystem.class);
            SubSystemInterfacesTest.assertEquals((int)1, (int)subsystems.length);
            subsystems = registry.getSubsystems(host, IRemoteCmdSubSystem.class);
            SubSystemInterfacesTest.assertEquals((int)1, (int)subsystems.length);
            registry.deleteSystemProfile(profile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

