/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.connection;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RSEConnectionTestCase
extends RSEBaseConnectionTestCase {
    public RSEConnectionTestCase(String name) {
        super(name);
    }

    public void testConnectionCaseInSensitive() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile prof = RSECorePlugin.getTheSystemProfileManager().getDefaultPrivateSystemProfile();
        ISystemProfile testprof = RSECorePlugin.getTheSystemProfileManager().cloneSystemProfile(prof, "testConnectionCaseInSensitive");
        IHost h1 = sr.createLocalHost(testprof, "TestConn", "mober");
        RSEConnectionTestCase.assertNotNull((Object)h1);
        RSEConnectionTestCase.assertEquals((String)h1.getAliasName(), (String)"TestConn");
        IHost h2 = sr.getHost(testprof, "testCONN");
        RSEConnectionTestCase.assertNotNull((Object)h2);
        RSEConnectionTestCase.assertEquals((Object)h1, (Object)h2);
        sr.deleteSystemProfile(testprof);
    }

    public void testBug255023() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        Job j = new Job("testBug255023"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                    ISystemProfile prof = sr.createSystemProfile("Foo", true);
                    IRSESystemType st = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.ssh");
                    IHost h1 = sr.createHost("Foo", st, "vxsim0", "localhost", "vxsim0");
                    IHost h2 = sr.createHost("Foo", st, "vxsim1", "localhost", "vxsim1");
                    IHost h3 = sr.createHost("Foo", st, "vxsim2", "localhost", "vxsim2");
                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)sr, 82, null));
                    Thread.sleep(10000L);
                    sr.deleteHost(h1);
                    sr.deleteHost(h2);
                    sr.deleteHost(h3);
                    sr.createHost("Foo", st, "vxsim1", "localhost", "vxsim1");
                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)sr, 82, null));
                    Thread.sleep(10000L);
                    sr.deleteSystemProfile(prof);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        while (j.getState() != 0) {
            this.flushEventQueue();
        }
    }

    public void testConnectionCreation() {
        if (this.isTestDisabled()) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("profile_name", "TestProfile");
        properties.setProperty("name", "TestHost1");
        properties.setProperty("address", "localhost");
        properties.setProperty("system_type_id", "org.eclipse.rse.systemtype.unix");
        properties.setProperty("userid", "userid");
        properties.setProperty("password", "password");
        IRSEConnectionProperties props = this.getConnectionManager().loadConnectionProperties(properties, false);
        IHost connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
        props.setProperty("name", "TestHost2");
        connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
        props.setProperty("name", "TestHost3");
        connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
        props.setProperty("name", "TestHost4");
        connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
        props.setProperty("name", "TestHost5");
        connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
        props.setProperty("name", "TestHost6");
        connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
        props.setProperty("name", "vxsim_128.11.75.12/4_Cores");
        connection = this.getConnectionManager().findOrCreateConnection(props);
        RSEConnectionTestCase.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)connection);
    }

    public void testConnectionRemoval() {
        if (this.isTestDisabled()) {
            return;
        }
        String profileName = "TestProfile";
        this.getConnectionManager().removeConnection(profileName, "TestHost1");
        this.getConnectionManager().removeConnection(profileName, "TestHost2");
        this.getConnectionManager().removeConnection(profileName, "TestHost3");
        this.getConnectionManager().removeConnection(profileName, "TestHost4");
        this.getConnectionManager().removeConnection(profileName, "TestHost5");
        this.getConnectionManager().removeConnection(profileName, "TestHost6");
        this.getConnectionManager().removeConnection(profileName, "vxsim_128.11.75.12/4_Cores");
    }

    public void testConnect() {
        IHost connection = this.getLocalSystemConnection();
        if (this.isTestDisabled()) {
            return;
        }
        Exception exception = null;
        String cause = null;
        FileServiceSubSystem subsystem = null;
        try {
            subsystem = this.getConnectionManager().getFileSubSystem(connection, "local.files");
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        RSEConnectionTestCase.assertNull((String)("Failed to get local.files subsystem! Possible cause: " + cause), (Object)exception);
        RSEConnectionTestCase.assertNotNull((String)"No local.files subystem", (Object)subsystem);
        RSEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.rse.preferences.alert.ssl", false);
        RSEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.rse.preferences.alert.nonssl", false);
        exception = null;
        cause = null;
        try {
            subsystem.connect(false, null);
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        RSEConnectionTestCase.assertNull((String)("Failed to connect local.files subsystem! Possible cause: " + cause), (Object)exception);
        RSEConnectionTestCase.assertTrue((String)"local.files subsystem is not connected!", (boolean)subsystem.isConnected());
        exception = null;
        cause = null;
        try {
            subsystem.disconnect();
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        RSEConnectionTestCase.assertNull((String)("Failed to discconnect local.files subsystem! Possible cause: " + cause), (Object)exception);
        RSEConnectionTestCase.assertTrue((String)"local.files subsystem is not connected but is expected to!", (boolean)subsystem.isConnected());
    }

    public void testResolveFilterString() {
        Object[] objects;
        String cause;
        Exception exception;
        block16: {
            IHost connection = this.getLocalSystemConnection();
            if (this.isTestDisabled()) {
                return;
            }
            exception = null;
            cause = null;
            FileServiceSubSystem subsystem = null;
            try {
                subsystem = this.getConnectionManager().getFileSubSystem(connection, "local.files");
            }
            catch (Exception e) {
                exception = e;
                cause = e.getLocalizedMessage();
            }
            RSEConnectionTestCase.assertNull((String)("Failed to get local.files subsystem! Possible cause: " + cause), (Object)exception);
            RSEConnectionTestCase.assertNotNull((String)"No local.files subystem", (Object)subsystem);
            exception = null;
            cause = null;
            try {
                subsystem.connect(false, null);
            }
            catch (Exception e) {
                exception = e;
                cause = e.getLocalizedMessage();
            }
            RSEConnectionTestCase.assertNull((String)("Failed to connect local.files subsystem! Possible cause: " + cause), (Object)exception);
            RSEConnectionTestCase.assertTrue((String)"local.files subsystem is not connected!", (boolean)subsystem.isConnected());
            exception = null;
            cause = null;
            objects = null;
            try {
                try {
                    objects = subsystem.resolveFilterString("/bin/*", null);
                }
                catch (Exception e) {
                    exception = e;
                    cause = e.getLocalizedMessage();
                    try {
                        subsystem.disconnect();
                    }
                    catch (Exception exception2) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    subsystem.disconnect();
                }
                catch (Exception exception3) {}
                throw throwable;
            }
            try {
                subsystem.disconnect();
            }
            catch (Exception exception4) {}
        }
        RSEConnectionTestCase.assertNull((String)("Failed to resolve filter string for local.files subsystem! Possible cause: " + cause), (Object)exception);
        RSEConnectionTestCase.assertNotNull((String)"Unexpected return value null for resolveFilterString!", (Object)objects);
    }
}

