/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.views;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.terminals.ui.TerminalServiceHelper;
import org.eclipse.rse.internal.terminals.ui.views.RSETerminalConnector;
import org.eclipse.rse.internal.terminals.ui.views.TerminalViewer;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCut;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionSelectAll;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class TerminalViewTab
extends Composite {
    public static String DATA_KEY_CONTROL = "$_control_$";
    private final CTabFolder tabFolder = new CTabFolder((Composite)this, 0);
    private IPropertyChangeListener propertyChangeListener;
    private Menu menu;
    private boolean fMenuAboutToShow;
    private TerminalActionCopy fActionEditCopy;
    private TerminalActionCut fActionEditCut;
    private TerminalActionPaste fActionEditPaste;
    private TerminalActionClearAll fActionEditClearAll;
    private TerminalActionSelectAll fActionEditSelectAll;
    static /* synthetic */ Class class$0;

    public TerminalViewTab(Composite parent, TerminalViewer viewer) {
        super(parent, 0);
        this.tabFolder.setLayout((Layout)new FillLayout());
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.setLayout((Layout)new FillLayout());
        this.tabFolder.setBackground(parent.getBackground());
        this.tabFolder.setSimple(false);
        this.tabFolder.setUnselectedImageVisible(false);
        this.tabFolder.setUnselectedCloseVisible(false);
        this.tabFolder.setMinimizeVisible(false);
        this.tabFolder.setMaximizeVisible(false);
        this.setupActions();
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
            mgr.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (!this.tabFolder.isDisposed()) {
            this.tabFolder.dispose();
        }
        super.dispose();
    }

    public CTabFolder getFolder() {
        return this.tabFolder;
    }

    public void remove(Object root) {
    }

    public CTabItem getSelectedTab() {
        if (this.tabFolder.getItemCount() > 0) {
            int index = this.tabFolder.getSelectionIndex();
            CTabItem item = this.tabFolder.getItem(index);
            return item;
        }
        return null;
    }

    public void showCurrentPage() {
        this.tabFolder.setFocus();
    }

    public void showPageFor(Object root) {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            if (item.getData() == root) {
                this.tabFolder.setSelection(item);
            }
            ++i;
        }
    }

    public void showPageFor(String tabName) {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            if (item.getText().equals(tabName)) {
                this.tabFolder.setSelection(item);
                return;
            }
            ++i;
        }
    }

    public void disposePageFor(String tabName) {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            if (item.getText().equals(tabName)) {
                item.dispose();
                return;
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.tabFolder != null) {
            CTabItem[] items = this.tabFolder.getItems();
            int i = 0;
            while (i < items.length) {
                Object control = items[i].getData(DATA_KEY_CONTROL);
                if (control instanceof ITerminalViewControl) {
                    this.updateTheme((ITerminalViewControl)control);
                }
                ++i;
            }
        }
    }

    public void updateTheme(ITerminalViewControl control) {
        if (control != null) {
            IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
            FontRegistry fr = mgr.getCurrentTheme().getFontRegistry();
            Font font = fr.hasValueFor("terminal.views.view.font.definition") ? fr.get("terminal.views.view.font.definition") : (fr.hasValueFor("REMOTE_COMMANDS_VIEW_FONT") ? fr.get("REMOTE_COMMANDS_VIEW_FONT") : fr.get("org.eclipse.jface.textfont"));
            control.setFont(font);
            if (this.propertyChangeListener == null) {
                final TerminalViewTab myself = this;
                this.propertyChangeListener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        myself.propertyChange(event);
                    }
                };
                mgr.addPropertyChangeListener(this.propertyChangeListener);
            }
        }
    }

    public CTabItem createTabItem(IAdaptable root, final String initialWorkingDirCmd) {
        final CTabItem item = new CTabItem(this.tabFolder, 64);
        this.setTabTitle(root, item);
        item.setData((Object)root);
        Composite c = new Composite((Composite)this.tabFolder, 0);
        c.setLayout((Layout)new FillLayout());
        this.tabFolder.getParent().layout(true);
        if (root instanceof IHost) {
            final IHost host = (IHost)root;
            RSETerminalConnector connector = new RSETerminalConnector(host);
            ITerminalViewControl terminalControl = TerminalViewControlFactory.makeControl((ITerminalListener)new ITerminalListener(){

                public void setState(TerminalState state) {
                    if (state == TerminalState.CLOSED || state == TerminalState.CONNECTED) {
                        Display.getDefault().asyncExec(new Runnable(this, item, host, state, initialWorkingDirCmd){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ CTabItem val$item;
                            private final /* synthetic */ IHost val$host;
                            private final /* synthetic */ TerminalState val$state;
                            private final /* synthetic */ String val$initialWorkingDirCmd;
                            {
                                this.this$1 = var1_1;
                                this.val$item = cTabItem;
                                this.val$host = iHost;
                                this.val$state = terminalState;
                                this.val$initialWorkingDirCmd = string;
                            }

                            public void run() {
                                Object data;
                                if (!this.val$item.isDisposed()) {
                                    ITerminalServiceSubSystem terminalServiceSubSystem = TerminalServiceHelper.getTerminalSubSystem(this.val$host);
                                    if (this.val$state == TerminalState.CONNECTED) {
                                        TerminalServiceHelper.updateTerminalShellForTerminalElement(this.val$item);
                                    }
                                    TerminalViewTab.access$7(2.access$0(this.this$1), (IAdaptable)this.val$host, this.val$item);
                                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)terminalServiceSubSystem, 82, (Object)terminalServiceSubSystem));
                                }
                                if (this.val$state == TerminalState.CONNECTED && this.val$initialWorkingDirCmd != null && (data = this.val$item.getData(DATA_KEY_CONTROL)) instanceof ITerminalViewControl) {
                                    ((ITerminalViewControl)data).pasteString(this.val$initialWorkingDirCmd);
                                }
                            }
                        });
                    }
                }

                public void setTerminalTitle(String title) {
                }

                static /* synthetic */ TerminalViewTab access$0(2 var0) {
                    return var0.TerminalViewTab.this;
                }
            }, (Composite)c, (ITerminalConnector[])new ITerminalConnector[]{connector});
            try {
                terminalControl.setEncoding(host.getDefaultEncoding(true));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            terminalControl.setConnector((ITerminalConnector)connector);
            item.setData(DATA_KEY_CONTROL, (Object)terminalControl);
            this.updateTheme(terminalControl);
            terminalControl.connectTerminal();
        }
        item.setControl((Control)c);
        this.tabFolder.setSelection(item);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object source = e.getSource();
                if (source instanceof CTabItem) {
                    CTabItem currentItem = (CTabItem)source;
                    Object data = currentItem.getData(DATA_KEY_CONTROL);
                    if (data instanceof ITerminalViewControl) {
                        ((ITerminalViewControl)data).disposeTerminal();
                    }
                    if ((data = currentItem.getData()) instanceof IHost) {
                        TerminalServiceHelper.removeTerminalElementFromHost(currentItem, (IHost)data);
                    }
                }
            }
        });
        this.setupContextMenus();
        return item;
    }

    protected void setupActions() {
        this.fActionEditCopy = new TerminalActionCopy(){

            protected ITerminalViewControl getTarget() {
                return TerminalViewTab.this.getCurrentTerminalViewControl();
            }
        };
        this.fActionEditCut = new TerminalActionCut(){

            protected ITerminalViewControl getTarget() {
                return TerminalViewTab.this.getCurrentTerminalViewControl();
            }
        };
        this.fActionEditPaste = new TerminalActionPaste(){

            protected ITerminalViewControl getTarget() {
                return TerminalViewTab.this.getCurrentTerminalViewControl();
            }
        };
        this.fActionEditClearAll = new TerminalActionClearAll(){

            protected ITerminalViewControl getTarget() {
                return TerminalViewTab.this.getCurrentTerminalViewControl();
            }
        };
        this.fActionEditSelectAll = new TerminalActionSelectAll(){

            protected ITerminalViewControl getTarget() {
                return TerminalViewTab.this.getCurrentTerminalViewControl();
            }
        };
    }

    protected void setupContextMenus() {
        ITerminalViewControl terminalViewControl = this.getCurrentTerminalViewControl();
        if (terminalViewControl == null) {
            return;
        }
        if (this.menu == null) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            this.menu = menuMgr.createContextMenu((Control)this.tabFolder);
            this.loadContextMenus((IMenuManager)menuMgr);
            TerminalContextMenuHandler contextMenuHandler = new TerminalContextMenuHandler();
            menuMgr.addMenuListener((IMenuListener)contextMenuHandler);
            this.menu.addMenuListener((MenuListener)contextMenuHandler);
        }
        Control ctlText = terminalViewControl.getControl();
        ctlText.setMenu(this.menu);
    }

    protected void loadContextMenus(IMenuManager menuMgr) {
        menuMgr.add((IAction)this.fActionEditCopy);
        menuMgr.add((IAction)this.fActionEditPaste);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fActionEditClearAll);
        menuMgr.add((IAction)this.fActionEditSelectAll);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IContributionItem)new Separator("Additions"));
    }

    private void setTabTitle(IAdaptable root, CTabItem titem) {
        ISystemViewElementAdapter va;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((va = (ISystemViewElementAdapter)root.getAdapter((Class)clazz)) != null) {
            this.updateWithUniqueTitle(va.getName((Object)root), titem);
            this.setTabImage(root, titem);
        }
    }

    private void setTabImage(IAdaptable root, CTabItem titem) {
        ISystemViewElementAdapter va;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((va = (ISystemViewElementAdapter)root.getAdapter((Class)clazz)) != null) {
            ITerminalServiceSubSystem terminalServiceSubSystem;
            TerminalElement element;
            if (root instanceof IHost && (element = (terminalServiceSubSystem = TerminalServiceHelper.getTerminalSubSystem((IHost)root)).getChild(titem.getText())) != null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                va = (ISystemViewElementAdapter)element.getAdapter((Class)clazz2);
                titem.setImage(va.getImageDescriptor((Object)element).createImage());
                return;
            }
            titem.setImage(va.getImageDescriptor((Object)root).createImage());
        }
    }

    private void updateWithUniqueTitle(String title, CTabItem currentItem) {
        CTabItem[] items = this.tabFolder.getItems();
        int increment = 1;
        String temp = title;
        int i = 0;
        while (i < items.length) {
            String name;
            if (items[i] != currentItem && (name = items[i].getText()) != null && name.equals(temp)) {
                temp = String.valueOf(title) + " " + increment++;
            }
            ++i;
        }
        currentItem.setText(temp);
    }

    private ITerminalViewControl getCurrentTerminalViewControl() {
        Object data;
        CTabItem item;
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && (item = this.tabFolder.getSelection()) != null && !item.isDisposed() && (data = item.getData(DATA_KEY_CONTROL)) instanceof ITerminalViewControl) {
            return (ITerminalViewControl)data;
        }
        return null;
    }

    static /* synthetic */ void access$7(TerminalViewTab terminalViewTab, IAdaptable iAdaptable, CTabItem cTabItem) {
        terminalViewTab.setTabImage(iAdaptable, cTabItem);
    }

    protected class TerminalContextMenuHandler
    implements MenuListener,
    IMenuListener {
        protected TerminalContextMenuHandler() {
        }

        public void menuHidden(MenuEvent event) {
            TerminalViewTab.this.fMenuAboutToShow = false;
            TerminalViewTab.this.fActionEditCopy.updateAction(TerminalViewTab.this.fMenuAboutToShow);
        }

        public void menuShown(MenuEvent e) {
        }

        public void menuAboutToShow(IMenuManager menuMgr) {
            TerminalViewTab.this.fMenuAboutToShow = true;
            TerminalViewTab.this.fActionEditCopy.updateAction(TerminalViewTab.this.fMenuAboutToShow);
            TerminalViewTab.this.fActionEditCut.updateAction(TerminalViewTab.this.fMenuAboutToShow);
            TerminalViewTab.this.fActionEditSelectAll.updateAction(TerminalViewTab.this.fMenuAboutToShow);
            TerminalViewTab.this.fActionEditPaste.updateAction(TerminalViewTab.this.fMenuAboutToShow);
            TerminalViewTab.this.fActionEditClearAll.updateAction(TerminalViewTab.this.fMenuAboutToShow);
        }
    }
}

