/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.GenerateToStringOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringGenerationSettingsCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeGenerationUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionUtility;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerateToStringHandler {
    public static final String METHODNAME_TOSTRING = "toString";
    public static final String DEFAULT_TEMPLATE = "${object.className} [${member.name()}=${member.value}, ${otherMembers}]";

    public static CheckToStringResponse checkToStringStatus(CodeActionParams params) {
        return GenerateToStringHandler.checkToStringStatus(params, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckToStringResponse checkToStringStatus(CodeActionParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params, monitor);
        return GenerateToStringHandler.checkToStringStatus(type, monitor);
    }

    public static CheckToStringResponse checkToStringStatus(IType type) {
        return GenerateToStringHandler.checkToStringStatus(type, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckToStringResponse checkToStringStatus(IType type, IProgressMonitor monitor) {
        CheckToStringResponse response = new CheckToStringResponse();
        if (type == null) {
            return response;
        }
        try {
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return response;
            }
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                response.type = type.getTypeQualifiedName();
                response.fields = JdtDomModels.getDeclaredFields(typeBinding, false);
                response.exists = CodeActionUtility.hasMethod(type, METHODNAME_TOSTRING, new Class[0]);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to check toString status", e);
        }
        return response;
    }

    public static WorkspaceEdit generateToString(GenerateToStringParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params.context, monitor);
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        Range range = params.context.getRange();
        ASTNode declarationNode = null;
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
        if (astRoot != null && range != null) {
            ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)DiagnosticsHelper.getStartOffset(type.getCompilationUnit(), range), (int)DiagnosticsHelper.getLength(type.getCompilationUnit(), range));
            declarationNode = SourceAssistProcessor.getTypeDeclarationNode(node);
        }
        IJavaElement insertPosition = declarationNode != null ? CodeGenerationUtils.findInsertElement(type, null) : CodeGenerationUtils.findInsertElement(type, range);
        TextEdit edit = GenerateToStringHandler.generateToString(type, params.fields, insertPosition, monitor);
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateToString(IType type, JdtDomModels.LspVariableBinding[] fields, IJavaElement insertPosition, IProgressMonitor monitor) {
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        ToStringGenerationSettingsCore settings = new ToStringGenerationSettingsCore();
        settings.overrideAnnotation = true;
        settings.createComments = preferences.isCodeGenerationTemplateGenerateComments();
        settings.useBlocks = preferences.isCodeGenerationTemplateUseBlocks();
        settings.stringFormatTemplate = StringUtils.isBlank((CharSequence)preferences.getGenerateToStringTemplate()) ? DEFAULT_TEMPLATE : preferences.getGenerateToStringTemplate();
        settings.toStringStyle = GenerateToStringHandler.getToStringStyle(preferences.getGenerateToStringCodeStyle());
        settings.skipNulls = preferences.isGenerateToStringSkipNullValues();
        settings.customArrayToString = preferences.isGenerateToStringListArrayContents();
        settings.limitElements = preferences.getGenerateToStringLimitElements() > 0;
        settings.limitValue = Math.max(preferences.getGenerateToStringLimitElements(), 0);
        settings.customBuilderSettings = new ToStringGenerationSettingsCore.CustomBuilderSettings();
        if (type.getCompilationUnit().getJavaProject() != null) {
            String version = type.getCompilationUnit().getJavaProject().getOption("org.eclipse.jdt.core.compiler.source", true);
            settings.is50orHigher = !JavaModelUtil.isVersionLessThan((String)version, (String)"1.5");
            settings.is60orHigher = !JavaModelUtil.isVersionLessThan((String)version, (String)"1.6");
        }
        return GenerateToStringHandler.generateToString(type, fields, settings, insertPosition, monitor);
    }

    public static TextEdit generateToString(IType type, JdtDomModels.LspVariableBinding[] fields, ToStringGenerationSettingsCore settings, IJavaElement insertPosition, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        block5: {
            if (type == null) {
                return null;
            }
            astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot != null) break block5;
            return null;
        }
        try {
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                Object[] selectedFields = JdtDomModels.convertToVariableBindings(typeBinding, fields);
                GenerateToStringOperation operation = GenerateToStringOperation.createOperation((ITypeBinding)typeBinding, (Object[])selectedFields, (CompilationUnit)astRoot, (IJavaElement)insertPosition, (ToStringGenerationSettingsCore)settings, (boolean)false, (boolean)false);
                operation.run(null);
                return operation.getResultingEdit();
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to generate toString()", e);
        }
        return null;
    }

    private static int getToStringStyle(String codeStyle) {
        if (StringUtils.isBlank((CharSequence)codeStyle)) {
            return 0;
        }
        switch (codeStyle) {
            case "STRING_CONCATENATION": {
                return 0;
            }
            case "STRING_BUILDER": {
                return 1;
            }
            case "STRING_BUILDER_CHAINED": {
                return 2;
            }
            case "STRING_FORMAT": {
                return 3;
            }
        }
        return 0;
    }

    public static class CheckToStringResponse {
        public String type;
        public JdtDomModels.LspVariableBinding[] fields;
        public boolean exists;
    }

    public static class GenerateToStringParams {
        public CodeActionParams context;
        public JdtDomModels.LspVariableBinding[] fields;
    }
}

