/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.ClasspathChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeletePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoablePackageDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.text.edits.TextEdit;

class DeleteChangeCreator {
    private DeleteChangeCreator() {
    }

    static Change createDeleteChange(TextChangeManager manager, IResource[] resources, IJavaElement[] javaElements, String changeName, List<IResource> packageDeletes) throws CoreException {
        DynamicValidationStateChange result = packageDeletes.size() > 0 ? new UndoablePackageDeleteChange(changeName, packageDeletes) : new DynamicValidationStateChange(changeName);
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (!ReorgUtilsCore.isInsideCompilationUnit(element)) {
                result.add(DeleteChangeCreator.createDeleteChange(element));
            }
            ++n2;
        }
        iJavaElementArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            IJavaElement resource = iJavaElementArray[n2];
            result.add(DeleteChangeCreator.createDeleteChange((IResource)resource));
            ++n2;
        }
        Map<ICompilationUnit, List<IJavaElement>> grouped = ReorgUtilsCore.groupByCompilationUnit(DeleteChangeCreator.getElementsSmallerThanCu(javaElements));
        if (!grouped.isEmpty()) {
            Assert.isNotNull((Object)manager);
            for (Map.Entry<ICompilationUnit, List<IJavaElement>> entry : grouped.entrySet()) {
                ICompilationUnit cu = entry.getKey();
                result.add(DeleteChangeCreator.createDeleteChange(cu, entry.getValue(), manager));
            }
        }
        return result;
    }

    private static Change createDeleteChange(IResource resource) {
        Assert.isTrue((!(resource instanceof IWorkspaceRoot) ? 1 : 0) != 0);
        Assert.isTrue((!(resource instanceof IProject) ? 1 : 0) != 0);
        return new DeleteResourceChange(resource.getFullPath(), true);
    }

    private static Change createDeleteChange(ICompilationUnit cu, List<IJavaElement> javaElements, TextChangeManager manager) throws CoreException {
        CompilationUnit cuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)cu, false, null);
        CompilationUnitRewrite rewriter = new CompilationUnitRewrite(cu, cuNode);
        IJavaElement[] elements = javaElements.toArray(new IJavaElement[javaElements.size()]);
        ASTNodeDeleteUtil.markAsDeleted(elements, rewriter, null);
        return DeleteChangeCreator.addTextEditFromRewrite(manager, cu, rewriter.getASTRewrite());
    }

    private static TextChange addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(cu);
            TextEdit resultingEdits = rewrite.rewriteAST(buffer.getDocument(), cu.getOptions(true));
            TextChange textChange = manager.get(cu);
            if (textChange instanceof TextFileChange) {
                TextFileChange tfc = (TextFileChange)textChange;
                tfc.setSaveMode(1);
            }
            String message = RefactoringCoreMessages.DeleteChangeCreator_1;
            TextChangeCompatibility.addTextEdit(textChange, message, resultingEdits);
            TextChange textChange2 = textChange;
            return textChange2;
        }
        finally {
            RefactoringFileBuffers.release(cu);
        }
    }

    private static List<IJavaElement> getElementsSmallerThanCu(IJavaElement[] javaElements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (ReorgUtilsCore.isInsideCompilationUnit(element)) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    private static Change createDeleteChange(IJavaElement javaElement) throws JavaModelException {
        Assert.isTrue((!ReorgUtilsCore.isInsideCompilationUnit(javaElement) ? 1 : 0) != 0);
        switch (javaElement.getElementType()) {
            case 3: {
                return DeleteChangeCreator.createPackageFragmentRootDeleteChange((IPackageFragmentRoot)javaElement);
            }
            case 4: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((IPackageFragment)javaElement));
            }
            case 5: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((ICompilationUnit)javaElement));
            }
            case 6: {
                Assert.isTrue((boolean)(((IClassFile)javaElement).getResource() instanceof IFile));
                return DeleteChangeCreator.createDeleteChange(((IClassFile)javaElement).getResource());
            }
            case 1: 
            case 2: {
                Assert.isTrue((boolean)false);
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return new NullChange();
    }

    private static Change createSourceManipulationDeleteChange(ISourceManipulation element) {
        IResource resource;
        if ((element instanceof ICompilationUnit || element instanceof IPackageFragment) && (resource = element instanceof ICompilationUnit ? ReorgUtilsCore.getResource((IJavaElement)((ICompilationUnit)element)) : ((IPackageFragment)element).getResource()) != null && resource.isLinked()) {
            return DeleteChangeCreator.createDeleteChange(resource);
        }
        return new DeleteSourceManipulationChange(element, true);
    }

    private static Change createPackageFragmentRootDeleteChange(IPackageFragmentRoot root) throws JavaModelException {
        IResource resource = root.getResource();
        if (resource != null && resource.isLinked()) {
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.DeleteRefactoring_delete_package_fragment_root);
            ClasspathChange change = ClasspathChange.removeEntryChange(root.getJavaProject(), root.getRawClasspathEntry());
            if (change != null) {
                composite.add((Change)change);
            }
            Assert.isTrue((!Checks.isClasspathDelete(root) ? 1 : 0) != 0);
            composite.add(DeleteChangeCreator.createDeleteChange(resource));
            return composite;
        }
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        return new DeletePackageFragmentRootChange(root, true, null);
    }
}

