/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.util.Arrays;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.model.ModelMessages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestRunHandler
extends DefaultHandler {
    private int fId;
    private TestRunSession fTestRunSession;
    private TestSuiteElement fTestSuite;
    private TestCaseElement fTestCase;
    private Stack<Boolean> fNotRun = new Stack();
    private StringBuffer fFailureBuffer;
    private boolean fInExpected;
    private boolean fInActual;
    private StringBuffer fExpectedBuffer;
    private StringBuffer fActualBuffer;
    private Locator fLocator;
    private TestElement.Status fStatus;
    private IProgressMonitor fMonitor;
    private int fLastReportedLine;

    public TestRunHandler() {
    }

    public TestRunHandler(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    public TestRunHandler(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int line;
        if (this.fLocator != null && this.fMonitor != null && (line = this.fLocator.getLineNumber()) - 20 >= this.fLastReportedLine) {
            line -= line % 20;
            this.fLastReportedLine = line;
            this.fMonitor.subTask(NLS.bind((String)ModelMessages.TestRunHandler_lines_read, (Object)line));
        }
        if (Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        switch (qName) {
            case "testrun": {
                if (this.fTestRunSession == null) {
                    String excludeTags;
                    IJavaModel javaModel;
                    String name = attributes.getValue("name");
                    String project = attributes.getValue("project");
                    IJavaProject javaProject = null;
                    if (project != null && !(javaProject = (javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot())).getJavaProject(project)).exists()) {
                        javaProject = null;
                    }
                    this.fTestRunSession = new TestRunSession(name, javaProject);
                    String includeTags = attributes.getValue("include_tags");
                    if (includeTags != null && includeTags.trim().length() > 0) {
                        this.fTestRunSession.setIncludeTags(includeTags);
                    }
                    if ((excludeTags = attributes.getValue("exclude_tags")) != null && excludeTags.trim().length() > 0) {
                        this.fTestRunSession.setExcludeTags(excludeTags);
                    }
                } else {
                    this.fTestRunSession.reset();
                }
                this.fTestSuite = this.fTestRunSession.getTestRoot();
                break;
            }
            case "testsuite": {
                String[] paramTypes;
                String pack;
                String name = attributes.getValue("name");
                if (this.fTestRunSession == null) {
                    this.fTestRunSession = new TestRunSession(name, null);
                    this.fTestSuite = this.fTestRunSession.getTestRoot();
                }
                String suiteName = (pack = attributes.getValue("package")) == null ? name : pack + "." + name;
                String displayName = attributes.getValue("displayname");
                String paramTypesStr = attributes.getValue("parameters");
                if (paramTypesStr != null && !paramTypesStr.trim().isEmpty()) {
                    paramTypes = paramTypesStr.split(",");
                    Arrays.parallelSetAll(paramTypes, i -> paramTypes[i].trim());
                } else {
                    paramTypes = null;
                }
                String uniqueId = attributes.getValue("uniqueid");
                if (uniqueId != null && uniqueId.trim().isEmpty()) {
                    uniqueId = null;
                }
                this.fTestSuite = (TestSuiteElement)this.fTestRunSession.createTestElement(this.fTestSuite, this.getNextId(), suiteName, true, 0, false, displayName, paramTypes, uniqueId);
                this.readTime(this.fTestSuite, attributes);
                this.fNotRun.push(Boolean.valueOf(attributes.getValue("incomplete")));
                break;
            }
            case "testcase": {
                String[] paramTypes;
                String name = attributes.getValue("name");
                String classname = attributes.getValue("classname");
                String testName = name + "(" + classname + ")";
                boolean isDynamicTest = Boolean.parseBoolean(attributes.getValue("dynamicTest"));
                String displayName = attributes.getValue("displayname");
                String paramTypesStr = attributes.getValue("parameters");
                if (paramTypesStr != null && !paramTypesStr.trim().isEmpty()) {
                    paramTypes = paramTypesStr.split(",");
                    Arrays.parallelSetAll(paramTypes, i -> paramTypes[i].trim());
                } else {
                    paramTypes = null;
                }
                String uniqueId = attributes.getValue("uniqueid");
                if (uniqueId != null && uniqueId.trim().isEmpty()) {
                    uniqueId = null;
                }
                this.fTestCase = (TestCaseElement)this.fTestRunSession.createTestElement(this.fTestSuite, this.getNextId(), testName, false, 0, isDynamicTest, displayName, paramTypes, uniqueId);
                this.fNotRun.push(Boolean.parseBoolean(attributes.getValue("incomplete")));
                this.fTestCase.setIgnored(Boolean.parseBoolean(attributes.getValue("ignored")));
                this.readTime(this.fTestCase, attributes);
                break;
            }
            case "error": {
                this.fStatus = TestElement.Status.ERROR;
                this.fFailureBuffer = new StringBuffer();
                break;
            }
            case "failure": {
                this.fStatus = TestElement.Status.FAILURE;
                this.fFailureBuffer = new StringBuffer();
                break;
            }
            case "expected": {
                this.fInExpected = true;
                this.fExpectedBuffer = new StringBuffer();
                break;
            }
            case "actual": {
                this.fInActual = true;
                this.fActualBuffer = new StringBuffer();
                break;
            }
            case "skipped": {
                this.fStatus = TestElement.Status.OK;
                this.fFailureBuffer = new StringBuffer();
                String message = attributes.getValue("message");
                if (message == null) break;
                this.fFailureBuffer.append(message).append('\n');
                break;
            }
            default: {
                throw new SAXParseException("unknown node '" + qName + "'", this.fLocator);
            }
            case "testsuites": 
            case "property": 
            case "properties": 
            case "system-err": 
            case "system-out": 
        }
    }

    private void readTime(TestElement testElement, Attributes attributes) {
        String timeString = attributes.getValue("time");
        if (timeString != null) {
            try {
                testElement.setElapsedTimeInSeconds(Double.parseDouble(timeString));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fInExpected) {
            this.fExpectedBuffer.append(ch, start, length);
        } else if (this.fInActual) {
            this.fActualBuffer.append(ch, start, length);
        } else if (this.fFailureBuffer != null) {
            this.fFailureBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName) {
            case "testsuite": {
                this.handleTestElementEnd(this.fTestSuite);
                this.fTestSuite = this.fTestSuite.getParent();
                break;
            }
            case "testcase": {
                this.handleTestElementEnd(this.fTestCase);
                this.fTestCase = null;
                break;
            }
            case "failure": 
            case "error": {
                TestElement testElement = this.fTestCase;
                if (testElement == null) {
                    testElement = this.fTestSuite;
                }
                this.handleFailure(testElement);
                break;
            }
            case "expected": {
                this.fInExpected = false;
                if (this.fFailureBuffer == null) break;
                this.fFailureBuffer.setLength(0);
                break;
            }
            case "actual": {
                this.fInActual = false;
                if (this.fFailureBuffer == null) break;
                this.fFailureBuffer.setLength(0);
                break;
            }
            case "skipped": {
                TestElement testElement = this.fTestCase;
                if (testElement == null) {
                    testElement = this.fTestSuite;
                }
                if (this.fFailureBuffer != null && this.fFailureBuffer.length() > 0) {
                    this.handleFailure(testElement);
                    testElement.setAssumptionFailed(true);
                    break;
                }
                if (this.fTestCase != null) {
                    this.fTestCase.setIgnored(true);
                    break;
                }
                testElement.setAssumptionFailed(true);
                break;
            }
            default: {
                this.handleUnknownNode(qName);
            }
            case "testsuites": 
            case "testrun": 
            case "property": 
            case "properties": 
            case "system-err": 
            case "system-out": 
        }
    }

    private void handleTestElementEnd(TestElement testElement) {
        boolean completed = this.fNotRun.pop() != Boolean.TRUE;
        this.fTestRunSession.registerTestEnded(testElement, completed);
    }

    private void handleFailure(TestElement testElement) {
        if (this.fFailureBuffer != null) {
            this.fTestRunSession.registerTestFailureStatus(testElement, this.fStatus, this.fFailureBuffer.toString(), this.toString(this.fExpectedBuffer), this.toString(this.fActualBuffer));
            this.fFailureBuffer = null;
            this.fExpectedBuffer = null;
            this.fActualBuffer = null;
            this.fStatus = null;
        }
    }

    private String toString(StringBuffer buffer) {
        return buffer != null ? buffer.toString() : null;
    }

    private void handleUnknownNode(String qName) throws SAXException {
        StringBuilder msg = new StringBuilder("unknown node '").append(qName).append("'");
        if (this.fLocator != null) {
            msg.append(" at line ").append(this.fLocator.getLineNumber()).append(", column ").append(this.fLocator.getColumnNumber());
        }
        throw new SAXException(msg.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    private String getNextId() {
        return Integer.toString(this.fId++);
    }

    public TestRunSession getTestRunSession() {
        return this.fTestRunSession;
    }
}

