/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocLocations;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocSnippetStringEvaluator;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccess;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocContentAccessUtility;
import org.eclipse.jdt.core.manipulation.internal.javadoc.IJavadocContentFactory;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavaDocMessages;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavadocLookup;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.viewsupport.CoreJavaElementLinks;
import org.eclipse.text.html.HTMLBuilder;

public class CoreJavadocAccessImpl
implements IJavadocContentFactory.IJavadocAccess {
    protected static final String BLOCK_TAG_START = "<dl>";
    protected static final String BLOCK_TAG_END = "</dl>";
    protected static final String BlOCK_TAG_TITLE_START = "<dt>";
    protected static final String BlOCK_TAG_TITLE_END = "</dt>";
    protected static final String BlOCK_TAG_ENTRY_START = "<dd>";
    protected static final String BlOCK_TAG_ENTRY_END = "</dd>";
    protected static final String PARAM_NAME_START = "<b>";
    protected static final String PARAM_NAME_END = "</b> ";
    protected final IJavaElement fElement;
    protected final CoreJavaDocSnippetStringEvaluator fSnippetStringEvaluator;
    protected final IMethod fMethod;
    protected final Javadoc fJavadoc;
    protected final String fSource;
    protected final JavadocLookup fJavadocLookup;
    protected StringBuffer fBuf;
    protected int fLiteralContent;
    protected StringBuffer fMainDescription;
    protected StringBuffer fReturnDescription;
    protected StringBuffer[] fTypeParamDescriptions;
    protected StringBuffer[] fParamDescriptions;
    protected HashMap<String, StringBuffer> fExceptionDescriptions;
    protected int fPreCounter;
    protected int fInPreCodeCounter = -1;

    public CoreJavadocAccessImpl(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
        Assert.isNotNull((Object)element);
        Assert.isTrue((element instanceof IMethod || element instanceof ILocalVariable || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fSnippetStringEvaluator = this.createSnippetEvaluator(this.fElement);
        this.fMethod = (IMethod)(element instanceof ILocalVariable || element instanceof ITypeParameter ? element.getParent() : element);
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = lookup;
    }

    public CoreJavadocAccessImpl(IJavaElement element, Javadoc javadoc, String source) {
        Assert.isNotNull((Object)element);
        Assert.isTrue((element instanceof IMember || element instanceof IPackageFragment || element instanceof ILocalVariable || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fSnippetStringEvaluator = this.createSnippetEvaluator(this.fElement);
        this.fMethod = null;
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = JavadocLookup.NONE;
    }

    protected CoreJavaDocSnippetStringEvaluator createSnippetEvaluator(IJavaElement element) {
        return new CoreJavaDocSnippetStringEvaluator(this.fElement);
    }

    @Override
    public String toHTML() {
        this.fBuf = new StringBuffer();
        this.fLiteralContent = 0;
        try {
            IField field;
            IJavaElement iJavaElement;
            if (this.fElement instanceof ILocalVariable || this.fElement instanceof ITypeParameter || (iJavaElement = this.fElement) instanceof IField && (field = (IField)iJavaElement).isRecordComponent()) {
                this.parameterToHTML();
            } else {
                this.elementToHTML();
            }
        }
        catch (JavaModelException field) {
            // empty catch block
        }
        String result = this.fBuf.toString();
        this.fBuf = null;
        return result;
    }

    protected void parameterToHTML() {
        List<String> typeParameterNames;
        int i;
        String elementName = this.fElement.getElementName();
        List tags = this.fJavadoc.tags();
        for (TagElement tag : tags) {
            String firstText;
            List fragments;
            int size;
            String tagName = tag.getTagName();
            if (!"@param".equals(tagName) || (size = (fragments = tag.fragments()).size()) <= 0) continue;
            Object first = fragments.get(0);
            if (first instanceof SimpleName) {
                String name = ((SimpleName)first).getIdentifier();
                if (!elementName.equals(name)) continue;
                this.handleContentElements(fragments.subList(1, size));
                return;
            }
            if (size <= 2 || !(this.fElement instanceof ITypeParameter) || !(first instanceof TextElement) || !"<".equals(firstText = ((TextElement)first).getText())) continue;
            Object second = fragments.get(1);
            Object third = fragments.get(2);
            if (!(second instanceof SimpleName) || !(third instanceof TextElement)) continue;
            String name = ((SimpleName)second).getIdentifier();
            String thirdText = ((TextElement)third).getText();
            if (!elementName.equals(name) || !">".equals(thirdText)) continue;
            this.handleContentElements(fragments.subList(3, size));
            return;
        }
        if (this.fElement instanceof ILocalVariable) {
            List<String> parameterNames = this.initParameterNames();
            int i2 = parameterNames.indexOf(elementName);
            if (i2 != -1) {
                CharSequence inheritedParamDescription = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i2);
                this.handleInherited(inheritedParamDescription);
            }
        } else if (this.fElement instanceof ITypeParameter && (i = (typeParameterNames = this.initTypeParameterNames()).indexOf(elementName)) != -1) {
            CharSequence inheritedTypeParamDescription = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
            this.handleInherited(inheritedTypeParamDescription);
        }
    }

    protected void elementToHTML() {
        boolean hasExceptions;
        List<String> typeParameterNames = this.initTypeParameterNames();
        List<String> parameterNames = this.initParameterNames();
        List<String> exceptionNames = this.initExceptionNames();
        TagElement deprecatedTag = null;
        TagElement start = null;
        ArrayList<TagElement> typeParameters = new ArrayList<TagElement>();
        ArrayList<TagElement> parameters = new ArrayList<TagElement>();
        TagElement returnTag = null;
        ArrayList<TagElement> exceptions = new ArrayList<TagElement>();
        ArrayList<TagElement> provides = new ArrayList<TagElement>();
        ArrayList<TagElement> uses = new ArrayList<TagElement>();
        ArrayList<TagElement> versions = new ArrayList<TagElement>();
        ArrayList<TagElement> authors = new ArrayList<TagElement>();
        ArrayList<TagElement> sees = new ArrayList<TagElement>();
        ArrayList<TagElement> since = new ArrayList<TagElement>();
        ArrayList<TagElement> rest = new ArrayList<TagElement>();
        ArrayList<TagElement> apinote = new ArrayList<TagElement>(1);
        ArrayList<TagElement> implspec = new ArrayList<TagElement>(1);
        ArrayList<TagElement> implnote = new ArrayList<TagElement>(1);
        ArrayList<TagElement> hidden = new ArrayList<TagElement>(1);
        List tags = this.fJavadoc.tags();
        block33: for (TagElement tag : tags) {
            String tagName = tag.getTagName();
            if (tagName == null) {
                start = tag;
                continue;
            }
            switch (tagName) {
                case "@param": {
                    String firstText;
                    List fragments = tag.fragments();
                    int size = fragments.size();
                    if (size <= 0) break;
                    Object first = fragments.get(0);
                    if (first instanceof SimpleName) {
                        String name = ((SimpleName)first).getIdentifier();
                        int paramIndex = parameterNames.indexOf(name);
                        if (paramIndex != -1) {
                            parameterNames.set(paramIndex, null);
                        }
                        parameters.add(tag);
                        break;
                    }
                    if (size <= 2 || !(first instanceof TextElement) || !"<".equals(firstText = ((TextElement)first).getText())) continue block33;
                    Object second = fragments.get(1);
                    Object third = fragments.get(2);
                    if (!(second instanceof SimpleName) || !(third instanceof TextElement)) continue block33;
                    String name = ((SimpleName)second).getIdentifier();
                    String thirdText = ((TextElement)third).getText();
                    if (!">".equals(thirdText)) break;
                    int paramIndex = typeParameterNames.indexOf(name);
                    if (paramIndex != -1) {
                        typeParameterNames.set(paramIndex, null);
                    }
                    typeParameters.add(tag);
                    break;
                }
                case "@throws": 
                case "@exception": {
                    String name;
                    int exceptionIndex;
                    Object first;
                    exceptions.add(tag);
                    List fragments2 = tag.fragments();
                    if (fragments2.size() <= 0 || !((first = fragments2.get(0)) instanceof Name) || (exceptionIndex = exceptionNames.indexOf(name = ASTNodes.getSimpleNameIdentifier((Name)first))) == -1) continue block33;
                    exceptionNames.set(exceptionIndex, null);
                    break;
                }
                case "@provides": {
                    provides.add(tag);
                    break;
                }
                case "@uses": {
                    uses.add(tag);
                    break;
                }
                case "@since": {
                    since.add(tag);
                    break;
                }
                case "@version": {
                    versions.add(tag);
                    break;
                }
                case "@author": {
                    authors.add(tag);
                    break;
                }
                case "@see": {
                    sees.add(tag);
                    break;
                }
                case "@deprecated": {
                    if (deprecatedTag != null) break;
                    deprecatedTag = tag;
                    break;
                }
                case "@apiNote": {
                    apinote.add(tag);
                    break;
                }
                case "@implSpec": {
                    implspec.add(tag);
                    break;
                }
                case "@implNote": {
                    implnote.add(tag);
                    break;
                }
                case "@hidden": {
                    hidden.add(tag);
                    break;
                }
                default: {
                    rest.add(tag);
                }
                case "@return": 
            }
        }
        ArrayList<TagElement> returnTags = new ArrayList<TagElement>();
        this.findTags("@return", returnTags, tags);
        if (!returnTags.isEmpty()) {
            returnTag = (TagElement)returnTags.get(0);
        }
        if (deprecatedTag != null) {
            this.handleDeprecatedTag(deprecatedTag);
        }
        if (start != null) {
            this.handleContentElements(start.fragments());
        } else if (this.fMethod != null) {
            CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
            this.handleInherited(inherited);
        }
        CharSequence[] typeParameterDescriptions = new CharSequence[typeParameterNames.size()];
        boolean hasInheritedTypeParameters = this.inheritTypeParameterDescriptions(typeParameterNames, typeParameterDescriptions);
        boolean hasTypeParameters = typeParameters.size() > 0 || hasInheritedTypeParameters;
        CharSequence[] parameterDescriptions = new CharSequence[parameterNames.size()];
        boolean hasInheritedParameters = this.inheritParameterDescriptions(parameterNames, parameterDescriptions);
        boolean hasParameters = parameters.size() > 0 || hasInheritedParameters;
        CharSequence returnDescription = null;
        if (returnTag == null && this.needsReturnTag()) {
            returnDescription = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
        }
        boolean hasReturnTag = returnTag != null || returnDescription != null;
        CharSequence[] exceptionDescriptions = new CharSequence[exceptionNames.size()];
        boolean hasInheritedExceptions = this.inheritExceptionDescriptions(exceptionNames, exceptionDescriptions);
        boolean bl = hasExceptions = exceptions.size() > 0 || hasInheritedExceptions;
        if (hasParameters || hasTypeParameters || hasReturnTag || hasExceptions || versions.size() > 0 || authors.size() > 0 || since.size() > 0 || sees.size() > 0 || apinote.size() > 0 || implnote.size() > 0 || implspec.size() > 0 || uses.size() > 0 || provides.size() > 0 || hidden.size() > 0 || rest.size() > 0 || this.fBuf.length() > 0 && (parameterDescriptions.length > 0 || exceptionDescriptions.length > 0)) {
            this.handleSuperMethodReferences();
            this.fBuf.append(this.getBlockTagStart());
            this.handleParameterTags(typeParameters, typeParameterNames, typeParameterDescriptions, true);
            this.handleParameterTags(parameters, parameterNames, parameterDescriptions, false);
            this.handleReturnTag(returnTag, returnDescription);
            this.handleExceptionTags(exceptions, exceptionNames, exceptionDescriptions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_since_section, since);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_version_section, versions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_author_section, authors);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_see_section, sees);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_api_note, apinote);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_impl_spec, implspec);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_impl_note, implnote);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_uses, uses);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_provides, provides);
            if (hidden.size() > 0) {
                this.handleBlockTagsHidden();
            }
            this.handleBlockTags(rest);
            this.fBuf.append(this.getBlockTagEnd());
        } else if (this.fBuf.length() > 0) {
            this.handleSuperMethodReferences();
        }
    }

    protected List<TagElement> findTags(String tagName, List<TagElement> found, List<? extends ASTNode> tags) {
        for (ASTNode aSTNode : tags) {
            if (!(aSTNode instanceof TagElement)) continue;
            TagElement tag = (TagElement)aSTNode;
            if (tagName.equals(tag.getTagName())) {
                found.add(tag);
            }
            this.findTags(tagName, found, tag.fragments());
        }
        return found;
    }

    protected void handleBlockTagsHidden() {
        String replaceAll = this.fBuf.toString().replaceAll(this.getBlockTagStart(), "<dl hidden>");
        replaceAll = replaceAll.replaceAll(this.getBlockTagTitleStart(), "<dt hidden>");
        replaceAll = replaceAll.replaceAll(this.getBlockTagEntryStart(), "<dd hidden>");
        replaceAll = replaceAll.replaceAll(this.getParamNameStart(), "<b hidden>");
        this.fBuf.setLength(0);
        this.fBuf.append(replaceAll);
    }

    protected void handleDeprecatedTag(TagElement tag) {
        this.fBuf.append("<p><b>");
        this.fBuf.append(JavaDocMessages.JavaDoc2HTMLTextReader_deprecated_section);
        this.fBuf.append("</b> <i>");
        this.handleContentElements(tag.fragments());
        this.fBuf.append("</i><p>");
    }

    protected void handleSuperMethodReferences() {
        if (this.fMethod != null) {
            try {
                StringBuffer superMethodReferences = this.createSuperMethodReferences(this.fMethod);
                if (superMethodReferences != null) {
                    this.fBuf.append(superMethodReferences);
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
    }

    protected StringBuffer createSuperMethodReferences(IMethod method) throws JavaModelException {
        CoreJavadocAccess.SuperclassReferenceMethodData data = CoreJavadocAccess.getSuperclassReferenceMethodData(method);
        if (data == null) {
            return null;
        }
        return this.createSuperMethodReferencesHTML(data.superInterfaceMethods(), data.superClassMethod());
    }

    protected StringBuffer createSuperMethodReferencesHTML(ArrayList<IMethod> superInterfaceMethods, IMethod superClassMethod) {
        return CoreJavadocAccess.createSuperMethodReferencesHTMLStaticImpl(superInterfaceMethods, superClassMethod);
    }

    protected List<String> initTypeParameterNames() {
        if (this.fMethod != null) {
            try {
                ArrayList<String> typeParameterNames = new ArrayList<String>();
                ITypeParameter[] iTypeParameterArray = this.fMethod.getTypeParameters();
                int n = iTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter typeParameter = iTypeParameterArray[n2];
                    typeParameterNames.add(typeParameter.getElementName());
                    ++n2;
                }
                return typeParameterNames;
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    protected List<String> initParameterNames() {
        if (this.fMethod != null) {
            try {
                return new ArrayList<String>(Arrays.asList(this.fMethod.getParameterNames()));
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    protected List<String> initExceptionNames() {
        if (this.fMethod != null) {
            try {
                ArrayList<String> exceptionNames = new ArrayList<String>();
                String[] stringArray = this.fMethod.getExceptionTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String exceptionType = stringArray[n2];
                    exceptionNames.add(Signature.getSimpleName((String)Signature.toString((String)exceptionType)));
                    ++n2;
                }
                return exceptionNames;
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return Collections.emptyList();
    }

    protected boolean needsReturnTag() {
        if (this.fMethod == null) {
            return false;
        }
        try {
            return !"V".equals(this.fMethod.getReturnType());
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
            return false;
        }
    }

    protected boolean inheritTypeParameterDescriptions(List<String> typeParameterNames, CharSequence[] typeParameterDescriptions) {
        boolean hasInheritedTypeParameters = false;
        int i = 0;
        while (i < typeParameterNames.size()) {
            String name = typeParameterNames.get(i);
            if (name != null) {
                typeParameterDescriptions[i] = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
                if (typeParameterDescriptions[i] != null) {
                    hasInheritedTypeParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedTypeParameters;
    }

    protected boolean inheritParameterDescriptions(List<String> parameterNames, CharSequence[] parameterDescriptions) {
        boolean hasInheritedParameters = false;
        int i = 0;
        while (i < parameterNames.size()) {
            String name = parameterNames.get(i);
            if (name != null) {
                parameterDescriptions[i] = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                if (parameterDescriptions[i] != null) {
                    hasInheritedParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedParameters;
    }

    protected boolean inheritExceptionDescriptions(List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        boolean hasInheritedExceptions = false;
        int i = 0;
        while (i < exceptionNames.size()) {
            String name = exceptionNames.get(i);
            if (name != null) {
                exceptionDescriptions[i] = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                if (exceptionDescriptions[i] != null) {
                    hasInheritedExceptions = true;
                }
            }
            ++i;
        }
        return hasInheritedExceptions;
    }

    @Override
    public CharSequence getMainDescription() {
        if (this.fMainDescription == null) {
            this.fBuf = this.fMainDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String tagName = tag.getTagName();
                if (tagName != null) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fMainDescription.length() > 0 ? this.fMainDescription : null;
    }

    @Override
    public CharSequence getReturnDescription() {
        if (this.fReturnDescription == null) {
            this.fBuf = this.fReturnDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            ArrayList<TagElement> returnTags = new ArrayList<TagElement>();
            this.findTags("@return", returnTags, tags);
            if (!returnTags.isEmpty()) {
                TagElement returnTag = (TagElement)returnTags.get(0);
                this.handleContentElements(returnTag.fragments());
            }
            this.fBuf = null;
        }
        return this.fReturnDescription.length() > 0 ? this.fReturnDescription : null;
    }

    @Override
    public CharSequence getInheritedTypeParamDescription(int typeParamIndex) {
        if (this.fMethod != null) {
            StringBuffer description;
            List<String> typeParameterNames = this.initTypeParameterNames();
            if (this.fTypeParamDescriptions == null) {
                this.fTypeParamDescriptions = new StringBuffer[typeParameterNames.size()];
            } else {
                description = this.fTypeParamDescriptions[typeParamIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fTypeParamDescriptions[typeParamIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String typeParamName = typeParameterNames.get(typeParamIndex);
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String name;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 2) continue;
                Object first = fragments.get(0);
                Object second = fragments.get(1);
                Object third = fragments.get(2);
                if (!(first instanceof TextElement) || !(second instanceof SimpleName) || !(third instanceof TextElement)) continue;
                String firstText = ((TextElement)first).getText();
                String thirdText = ((TextElement)third).getText();
                if (!"<".equals(firstText) || !">".equals(thirdText) || !(name = ((SimpleName)second).getIdentifier()).equals(typeParamName)) continue;
                this.handleContentElements(fragments.subList(3, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    @Override
    public CharSequence getInheritedParamDescription(int paramIndex) throws JavaModelException {
        if (this.fMethod != null) {
            StringBuffer description;
            String[] parameterNames = this.fMethod.getParameterNames();
            if (this.fParamDescriptions == null) {
                this.fParamDescriptions = new StringBuffer[parameterNames.length];
            } else {
                description = this.fParamDescriptions[paramIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fParamDescriptions[paramIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String paramName = parameterNames[paramIndex];
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String name;
                Object first;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((first = fragments.get(0)) instanceof SimpleName) || !(name = ((SimpleName)first).getIdentifier()).equals(paramName)) continue;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    @Override
    public CharSequence getExceptionDescription(String simpleName) {
        if (this.fMethod != null) {
            StringBuffer description;
            if (this.fExceptionDescriptions == null) {
                this.fExceptionDescriptions = new HashMap();
            } else {
                description = this.fExceptionDescriptions.get(simpleName);
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            description = new StringBuffer();
            this.fExceptionDescriptions.put(simpleName, description);
            this.fBuf = description;
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String name;
                Object first;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@throws".equals(tagName) && !"@exception".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((first = fragments.get(0)) instanceof Name) || !(name = ASTNodes.getSimpleNameIdentifier((Name)first)).equals(simpleName)) continue;
                if (fragments.size() <= 1) break;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    protected void handleContentElements(List<? extends ASTNode> nodes) {
        this.handleContentElements(nodes, false, null);
    }

    protected void handleContentElements(List<? extends ASTNode> nodes, boolean skipLeadingWhiteSpace) {
        this.handleContentElements(nodes, skipLeadingWhiteSpace, null);
    }

    protected void handleContentElements(List<? extends ASTNode> nodes, boolean skipLeadingWhitespace, TagElement tagElement) {
        ASTNode previousNode = null;
        for (ASTNode aSTNode : nodes) {
            if (previousNode != null) {
                int childStart;
                int previousEnd = previousNode.getStartPosition() + previousNode.getLength();
                if (previousEnd > (childStart = aSTNode.getStartPosition())) {
                    if ((aSTNode.getFlags() & 1) == 0) {
                        Exception exception = new Exception("Illegal ASTNode positions: previousEnd=" + previousEnd + ", childStart=" + childStart + ", element=" + this.fElement.getHandleIdentifier() + ", Javadoc:\n" + this.fSource);
                        JavaManipulationPlugin.log(exception);
                    }
                } else if (previousEnd != childStart) {
                    textWithStars = this.fSource.substring(previousEnd, childStart);
                    text = this.removeDocLineIntros(textWithStars);
                    this.fBuf.append(text);
                }
            } else if (tagElement != null && this.fPreCounter >= 1) {
                int childStart = aSTNode.getStartPosition();
                int previousEnd = tagElement.getStartPosition() + tagElement.getTagName().length() + 1;
                textWithStars = this.fSource.substring(previousEnd, childStart);
                text = this.removeDocLineIntros(textWithStars);
                this.fBuf.append(text);
            }
            previousNode = aSTNode;
            if (aSTNode instanceof TextElement) {
                TextElement te = (TextElement)aSTNode;
                this.handleInLineTextElement(te, skipLeadingWhitespace, tagElement, previousNode);
                continue;
            }
            if (aSTNode instanceof TagElement) {
                this.handleInlineTagElement((TagElement)aSTNode);
                continue;
            }
            int start = aSTNode.getStartPosition();
            String text = this.fSource.substring(start, start + aSTNode.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
    }

    protected void handleInLineTextElement(TextElement te, boolean skipLeadingWhitespace, TagElement tagElement, ASTNode previousNode) {
        String text = te.getText();
        if (skipLeadingWhitespace) {
            text = text.replaceFirst("^\\s", "");
        }
        text = text.replaceAll("(\r\n?|\n)([ \t]*\\*)", "$1");
        text = this.handlePreCounter(tagElement, text);
        this.handleInLineText(text, previousNode);
    }

    protected String handlePreCounter(TagElement tagElement, String text) {
        if (tagElement == null && text.equals("<pre>")) {
            ++this.fPreCounter;
        } else if (tagElement == null && text.equals("</pre>")) {
            --this.fPreCounter;
            if (this.fPreCounter == this.fInPreCodeCounter) {
                this.fInPreCodeCounter = -1;
            }
        } else if (tagElement == null && this.fPreCounter > 0 && text.matches("}\\s*</pre>")) {
            --this.fPreCounter;
            if (this.fPreCounter == this.fInPreCodeCounter) {
                text = "</code></pre>";
                int lastCodeEnd = this.fBuf.lastIndexOf("</code>");
                if (lastCodeEnd >= 0) {
                    this.fBuf.replace(lastCodeEnd, lastCodeEnd + 7, "");
                }
                this.fInPreCodeCounter = -1;
            }
        }
        return text;
    }

    protected void handleInLineText(String text, ASTNode previousNode) {
        this.handleText(text);
    }

    protected String removeDocLineIntros(String textWithStars) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithStars.replaceAll(lineBreakGroup + noBreakSpace + "*\\*", "$1");
    }

    protected void handleText(String text) {
        if (this.fLiteralContent == 0) {
            this.handleUnicode(this.fBuf, text);
        } else {
            text = this.appendEscaped(text);
            this.handleUnicode(this.fBuf, text);
        }
    }

    protected void handleUnicode(StringBuffer buf, String text) {
        int nextToCopy = 0;
        int length = text.length();
        boolean seenBackSlash = false;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '\\': {
                    seenBackSlash = true;
                    break;
                }
                case 'u': {
                    if (!seenBackSlash) break;
                    seenBackSlash = false;
                    if (i + 4 >= length) break;
                    char ch1 = text.charAt(i + 1);
                    char ch2 = text.charAt(i + 2);
                    char ch3 = text.charAt(i + 3);
                    char ch4 = text.charAt(i + 4);
                    if (Character.digit(ch1, 16) == -1 || Character.digit(ch2, 16) == -1 || Character.digit(ch3, 16) == -1 || Character.digit(ch4, 16) == -1) break;
                    rep = "&#x" + ch1 + ch2 + ch3 + ch4 + ";";
                    break;
                }
                default: {
                    seenBackSlash = false;
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i - 1));
                }
                buf.append(rep);
                nextToCopy = (i += 4) + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
    }

    protected String appendEscaped(String text) {
        int nextToCopy = 0;
        int length = text.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i));
                }
                buf.append(rep);
                nextToCopy = i + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
        return buf.toString();
    }

    protected void handleInlineTagElement(TagElement node) {
        String name = node.getTagName();
        if ("@value".equals(name) && this.handleValueTag(node)) {
            return;
        }
        boolean isLink = "@link".equals(name);
        boolean isLinkplain = "@linkplain".equals(name);
        boolean isCode = "@code".equals(name);
        boolean isLiteral = "@literal".equals(name);
        boolean isSummary = "@summary".equals(name);
        boolean isIndex = "@index".equals(name);
        boolean isSnippet = "@snippet".equals(name);
        boolean isReturn = "@return".equals(name);
        if (isLiteral || isCode || isSummary || isIndex) {
            ++this.fLiteralContent;
        }
        if (isCode || isLink && this.addCodeTagOnLink()) {
            if (isCode && this.fPreCounter > 0 && this.fBuf.lastIndexOf("<pre>") == this.fBuf.length() - 5) {
                this.fInPreCodeCounter = this.fPreCounter - 1;
            }
            this.fBuf.append("<code>");
        }
        if (isReturn) {
            this.fBuf.append(JavaDocMessages.JavadocContentAccess2_returns_pre);
        }
        if (isLink || isLinkplain) {
            this.handleLink(node.fragments());
        } else if (isSummary) {
            this.handleSummary(node.fragments());
        } else if (isIndex) {
            this.handleIndex(node.fragments());
        } else if (isCode || isLiteral) {
            this.handleContentElements(node.fragments(), true, node);
        } else if (isReturn) {
            this.handleContentElements(node.fragments(), false, node);
        } else if (isSnippet) {
            this.handleSnippet(node);
        } else if (!this.handleInheritDoc(node) && !this.handleDocRoot(node)) {
            int start = node.getStartPosition();
            String text = this.fSource.substring(start, start + node.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
        if (isReturn) {
            this.fBuf.append(JavaDocMessages.JavadocContentAccess2_returns_post);
        }
        if (isCode || isLink && this.addCodeTagOnLink()) {
            this.fBuf.append("</code>");
        }
        if (isSnippet) {
            this.fBuf.append("</code></pre>");
        }
        if (isLiteral || isCode) {
            --this.fLiteralContent;
        }
    }

    protected boolean addCodeTagOnLink() {
        return true;
    }

    protected boolean handleValueTag(TagElement node) {
        block10: {
            List fragments;
            block9: {
                fragments = node.fragments();
                if (this.fElement instanceof IMember) break block9;
                return false;
            }
            try {
                String[][] qualifierTypes;
                IType type;
                Object first;
                if (fragments.isEmpty()) {
                    if (this.fElement instanceof IField && JdtFlags.isStatic((IMember)((IField)this.fElement)) && JdtFlags.isFinal((IMember)((IField)this.fElement))) {
                        IField field = (IField)this.fElement;
                        return this.handleConstantValue(field, false);
                    }
                    break block10;
                }
                if (fragments.size() != 1 || !((first = fragments.get(0)) instanceof MemberRef)) break block10;
                MemberRef memberRef = (MemberRef)first;
                IType iType = type = this.fElement instanceof IType ? (IType)this.fElement : ((IMember)this.fElement).getDeclaringType();
                if (memberRef.getQualifier() != null && (qualifierTypes = type.resolveType(memberRef.getQualifier().getFullyQualifiedName())) != null && qualifierTypes.length == 1) {
                    type = type.getJavaProject().findType(String.join((CharSequence)".", qualifierTypes[0]), null);
                }
                SimpleName name = memberRef.getName();
                while (type != null) {
                    IField field = type.getField(name.getIdentifier());
                    if (field != null && field.exists()) {
                        if (JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field)) {
                            return this.handleConstantValue(field, true);
                        }
                        break;
                    }
                    type = type.getDeclaringType();
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return false;
    }

    protected boolean handleConstantValue(IField field, boolean link) throws JavaModelException {
        Object constant;
        IVariableBinding variableBinding;
        Object constantValue;
        IBinding binding;
        ASTNode nameNode;
        CompilationUnit cuNode;
        String text = null;
        ISourceRange nameRange = field.getNameRange();
        if (SourceRange.isAvailable((ISourceRange)nameRange) && (cuNode = SharedASTProviderCore.getAST(field.getTypeRoot(), SharedASTProviderCore.WAIT_ACTIVE_ONLY, null)) != null && (nameNode = NodeFinder.perform((ASTNode)cuNode, (ISourceRange)nameRange)) instanceof SimpleName && (binding = ((SimpleName)nameNode).resolveBinding()) instanceof IVariableBinding && (constantValue = (variableBinding = (IVariableBinding)binding).getConstantValue()) != null) {
            text = constantValue instanceof String ? ASTNodes.getEscapedStringLiteral((String)constantValue) : constantValue.toString();
        }
        if (text == null && (constant = field.getConstant()) != null) {
            text = constant.toString();
        }
        if (text != null) {
            text = HTMLBuilder.convertToHTMLContentWithWhitespace(text);
            if (link) {
                try {
                    String uri = this.createLinkURI("eclipse-javadoc", (IJavaElement)field, null, null, null);
                    this.fBuf.append(CoreJavaElementLinks.createLink(uri, text));
                }
                catch (URISyntaxException e) {
                    JavaManipulationPlugin.log(e);
                    return false;
                }
            } else {
                this.handleText(text);
            }
            return true;
        }
        return false;
    }

    protected boolean handleDocRoot(TagElement node) {
        if (!"@docRoot".equals(node.getTagName())) {
            return false;
        }
        try {
            String url = null;
            if (this.fElement instanceof IMember && ((IMember)this.fElement).isBinary()) {
                URL javadocBaseLocation = CoreJavaDocLocations.getJavadocBaseLocation(this.fElement);
                if (javadocBaseLocation != null) {
                    url = javadocBaseLocation.toExternalForm();
                }
            } else {
                IPath location;
                IResource resource;
                IPackageFragmentRoot srcRoot = JavaModelUtil.getPackageFragmentRoot(this.fElement);
                if (srcRoot != null && (resource = srcRoot.getResource()) != null && (location = resource.getLocation()) != null) {
                    url = location.toFile().toURI().toASCIIString();
                }
            }
            if (url != null) {
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                this.fBuf.append(url);
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    protected boolean handleInheritDoc(TagElement node) {
        block30: {
            if (!"@inheritDoc".equals(node.getTagName())) {
                return false;
            }
            if (this.fMethod != null) break block30;
            return false;
        }
        try {
            TagElement blockTag = (TagElement)node.getParent();
            String blockTagName = blockTag.getTagName();
            if (blockTagName == null) {
                CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
                return this.handleInherited(inherited);
            }
            switch (blockTagName) {
                case "@param": {
                    List fragments = blockTag.fragments();
                    int size = fragments.size();
                    if (size > 0) {
                        String firstText;
                        Object first = fragments.get(0);
                        if (first instanceof SimpleName) {
                            String name = ((SimpleName)first).getIdentifier();
                            String[] parameterNames = this.fMethod.getParameterNames();
                            int i = 0;
                            while (i < parameterNames.length) {
                                if (name.equals(parameterNames[i])) {
                                    CharSequence inherited = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                                    return this.handleInherited(inherited);
                                }
                                ++i;
                            }
                        } else if (size > 2 && first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                            String thirdText;
                            Object second = fragments.get(1);
                            Object third = fragments.get(2);
                            if (second instanceof SimpleName && third instanceof TextElement && ">".equals(thirdText = ((TextElement)third).getText())) {
                                String name = ((SimpleName)second).getIdentifier();
                                ITypeParameter[] typeParameters = this.fMethod.getTypeParameters();
                                int i = 0;
                                while (i < typeParameters.length) {
                                    ITypeParameter typeParameter = typeParameters[i];
                                    if (name.equals(typeParameter.getElementName())) {
                                        CharSequence inherited = this.getInheritedTypeParamDescription(i);
                                        return this.handleInherited(inherited);
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    break;
                }
                case "@return": {
                    CharSequence inherited = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
                    return this.handleInherited(inherited);
                }
                case "@throws": 
                case "@exception": {
                    Object first;
                    List fragments = blockTag.fragments();
                    if (fragments.size() > 0 && (first = fragments.get(0)) instanceof Name) {
                        String name = ASTNodes.getSimpleNameIdentifier((Name)first);
                        CharSequence inherited = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                        return this.handleInherited(inherited);
                    }
                    break;
                }
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
        return false;
    }

    protected boolean handleInherited(CharSequence inherited) {
        if (inherited == null) {
            return false;
        }
        this.fBuf.append(inherited);
        return true;
    }

    protected void handleBlockTags(String title, List<TagElement> tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.handleBlockTagTitle(title);
        for (TagElement tag : tags) {
            this.handleSingleTag(tag);
        }
    }

    protected void handleSingleTag(TagElement tag) {
        this.fBuf.append(this.getBlockTagEntryStart());
        if ("@see".equals(tag.getTagName())) {
            this.handleSeeTag(tag);
        } else {
            this.handleContentElements(tag.fragments());
        }
        this.fBuf.append(this.getBlockTagEntryEnd());
    }

    protected void handleReturnTag(TagElement tag, CharSequence returnDescription) {
        if (tag == null && returnDescription == null) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_returns_section);
        this.handleReturnTagBody(tag, returnDescription);
    }

    protected void handleReturnTagBody(TagElement tag, CharSequence returnDescription) {
        this.fBuf.append(this.getBlockTagEntryStart());
        if (tag != null) {
            this.handleContentElements(tag.fragments());
        } else {
            this.fBuf.append(returnDescription);
        }
        this.fBuf.append(this.getBlockTagEntryEnd());
    }

    protected void handleBlockTags(List<TagElement> tags) {
        for (TagElement tag : tags) {
            this.handleBlockTagTitle(tag.getTagName());
            this.handleBlockTagBody(tag);
        }
    }

    protected void handleBlockTagBody(TagElement tag) {
        this.fBuf.append(this.getBlockTagEntryStart());
        this.handleContentElements(tag.fragments());
        this.fBuf.append(this.getBlockTagEntryEnd());
    }

    protected void handleBlockTagTitle(String title) {
        this.fBuf.append(this.getBlockTagTitleStart());
        this.fBuf.append(title);
        this.fBuf.append(this.getBlockTagTitleEnd());
    }

    protected void handleSeeTag(TagElement tag) {
        this.handleLink(tag.fragments());
    }

    protected void handleExceptionTags(List<TagElement> tags, List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        if (tags.isEmpty() && this.containsOnlyNull(exceptionNames)) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_throws_section);
        this.handleExceptionTagsBody(tags, exceptionNames, exceptionDescriptions);
    }

    protected void handleExceptionTagsBody(List<TagElement> tags, List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        for (TagElement tag : tags) {
            this.fBuf.append(this.getBlockTagEntryStart());
            this.handleThrowsTag(tag);
            this.fBuf.append(this.getBlockTagEntryEnd());
        }
        int i = 0;
        while (i < exceptionDescriptions.length) {
            CharSequence description = exceptionDescriptions[i];
            String name = exceptionNames.get(i);
            if (name != null) {
                this.handleSingleException(name, description);
            }
            ++i;
        }
    }

    protected void handleSingleException(String name, CharSequence description) {
        this.fBuf.append(this.getBlockTagEntryStart());
        this.handleLink(Collections.singletonList(this.fJavadoc.getAST().newSimpleName(name)));
        if (description != null) {
            this.fBuf.append(JavaElementLabelsCore.CONCAT_STRING);
            this.fBuf.append(description);
        }
        this.fBuf.append(this.getBlockTagEntryEnd());
    }

    protected void handleThrowsTag(TagElement tag) {
        List fragments = tag.fragments();
        int size = fragments.size();
        if (size > 0) {
            this.handleLink(fragments.subList(0, 1));
            if (size > 1) {
                this.fBuf.append(JavaElementLabelsCore.CONCAT_STRING);
                this.handleContentElements(fragments.subList(1, size));
            }
        }
    }

    protected void handleSingleParameterTag(TagElement tag) {
        this.fBuf.append(this.getBlockTagEntryStart());
        this.handleParamTag(tag);
        this.fBuf.append(this.getBlockTagEntryEnd());
    }

    protected void handleParameterTags(List<TagElement> tags, List<String> parameterNames, CharSequence[] parameterDescriptions, boolean isTypeParameters) {
        if (tags.isEmpty() && this.containsOnlyNull(parameterNames)) {
            return;
        }
        String tagTitle = isTypeParameters ? JavaDocMessages.JavaDoc2HTMLTextReader_type_parameters_section : JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section;
        this.handleBlockTagTitle(tagTitle);
        for (TagElement tag : tags) {
            this.handleSingleParameterTag(tag);
        }
        int i = 0;
        while (i < parameterDescriptions.length) {
            CharSequence description = parameterDescriptions[i];
            String name = parameterNames.get(i);
            if (name != null) {
                this.handleSingleParameterDescription(name, description, isTypeParameters);
            }
            ++i;
        }
    }

    protected void handleSingleParameterDescription(String name, CharSequence description, boolean isTypeParameters) {
        this.fBuf.append(this.getBlockTagEntryStart());
        this.fBuf.append(this.getParamNameStart());
        if (isTypeParameters) {
            this.fBuf.append("&lt;");
        }
        this.fBuf.append(name);
        if (isTypeParameters) {
            this.fBuf.append("&gt;");
        }
        this.fBuf.append(this.getParamNameEnd());
        if (description != null) {
            this.fBuf.append(description);
        }
        this.fBuf.append(this.getBlockTagEntryEnd());
    }

    protected void handleParamTag(TagElement tag) {
        List fragments = tag.fragments();
        int i = 0;
        int size = fragments.size();
        if (size > 0) {
            String firstText;
            Object first = fragments.get(0);
            this.fBuf.append(this.getParamNameStart());
            if (first instanceof SimpleName) {
                String name = ((SimpleName)first).getIdentifier();
                this.fBuf.append(name);
                ++i;
            } else if (first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                Object second;
                this.fBuf.append("&lt;");
                ++i;
                if (size > 1 && (second = fragments.get(1)) instanceof SimpleName) {
                    Object third;
                    String thirdText;
                    String name = ((SimpleName)second).getIdentifier();
                    this.fBuf.append(name);
                    ++i;
                    if (size > 2 && ">".equals(thirdText = ((TextElement)(third = fragments.get(2))).getText())) {
                        this.fBuf.append("&gt;");
                        ++i;
                    }
                }
            }
            this.fBuf.append(this.getParamNameEnd());
            this.handleContentElements(fragments.subList(i, fragments.size()));
        }
    }

    protected void handleSummary(List<? extends ASTNode> fragments) {
        ASTNode first;
        int fs = fragments.size();
        if (fs > 0 && (first = fragments.get(0)) instanceof TextElement) {
            TextElement memberRef = (TextElement)first;
            this.fBuf.append(this.getBlockTagTitleStart() + "Summary: " + memberRef.getText() + this.getBlockTagTitleEnd());
            return;
        }
    }

    protected void handleSnippet(TagElement node) {
        if (node != null) {
            Object val = node.getProperty("IsSnippetValid");
            Object valError = node.getProperty("SnippetError");
            if (val instanceof Boolean && ((Boolean)val).booleanValue() && valError == null) {
                int fs = node.fragments().size();
                if (fs > 0) {
                    this.fBuf.append("<pre>");
                    Object valID = node.getProperty("SnippetID");
                    if (valID instanceof String && !valID.toString().isBlank()) {
                        this.fBuf.append("<code id=" + valID.toString() + ">");
                    } else {
                        this.fBuf.append("<code>");
                    }
                    this.fBuf.append(this.getBlockTagEntryStart());
                    this.fSnippetStringEvaluator.AddTagElementString(node, this.fBuf);
                    this.fBuf.append(this.getBlockTagEntryEnd());
                }
            } else {
                this.handleInvalidSnippet(node);
            }
        }
    }

    protected void handleInvalidSnippet(TagElement node) {
        this.fBuf.append("<pre><code>\n");
        this.fBuf.append("<mark>invalid @Snippet</mark>");
        Object val = node.getProperty("SnippetError");
        if (val instanceof String) {
            this.fBuf.append("<br><p>" + String.valueOf(val) + "</p>");
        }
    }

    protected void handleIndex(List<? extends ASTNode> fragments) {
        ASTNode first;
        int fs = fragments.size();
        if (fs > 0 && (first = fragments.get(0)) instanceof TextElement) {
            TextElement memberRef = (TextElement)first;
            this.fBuf.append(memberRef.getText());
            return;
        }
    }

    protected void handleLink(List<? extends ASTNode> fragments) {
        int fs = fragments.size();
        if (fs > 0) {
            ASTNode first = fragments.get(0);
            String refTypeName = null;
            String refMemberName = null;
            String[] refMethodParamTypes = null;
            String[] refMethodParamNames = null;
            if (first instanceof Name) {
                Name name = (Name)first;
                refTypeName = name.getFullyQualifiedName();
            } else if (first instanceof MemberRef) {
                MemberRef memberRef = (MemberRef)first;
                qualifier = memberRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = memberRef.getName().getIdentifier();
            } else if (first instanceof MethodRef) {
                MethodRef methodRef = (MethodRef)first;
                qualifier = methodRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = methodRef.getName().getIdentifier();
                List params = methodRef.parameters();
                int ps = params.size();
                refMethodParamTypes = new String[ps];
                refMethodParamNames = new String[ps];
                int i = 0;
                while (i < ps) {
                    MethodRefParameter param = (MethodRefParameter)params.get(i);
                    refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                    SimpleName paramName = param.getName();
                    if (paramName != null) {
                        refMethodParamNames[i] = paramName.getIdentifier();
                    }
                    ++i;
                }
            }
            if (refTypeName != null) {
                this.fBuf.append("<a href='");
                try {
                    String scheme = "eclipse-javadoc";
                    String uri = this.createLinkURI(scheme, this.fElement, refTypeName, refMemberName, refMethodParamTypes);
                    this.fBuf.append(uri);
                }
                catch (URISyntaxException e) {
                    JavaManipulationPlugin.log(e);
                }
                this.fBuf.append("'>");
                if (!(fs <= 1 || fs == 2 && CoreJavadocContentAccessUtility.isWhitespaceTextElement(fragments.get(1)))) {
                    this.handleContentElements(fragments.subList(1, fs), true);
                } else {
                    this.fBuf.append(refTypeName);
                    if (refMemberName != null) {
                        if (refTypeName.length() > 0) {
                            this.fBuf.append('.');
                        }
                        this.fBuf.append(refMemberName);
                        if (refMethodParamTypes != null && refMethodParamNames != null) {
                            this.fBuf.append('(');
                            int i = 0;
                            while (i < refMethodParamTypes.length) {
                                String pType = refMethodParamTypes[i];
                                this.fBuf.append(pType);
                                String pName = refMethodParamNames[i];
                                if (pName != null) {
                                    this.fBuf.append(' ').append(pName);
                                }
                                if (i < refMethodParamTypes.length - 1) {
                                    this.fBuf.append(", ");
                                }
                                ++i;
                            }
                            this.fBuf.append(')');
                        }
                    }
                }
                this.fBuf.append("</a>");
            } else {
                this.handleContentElements(fragments);
            }
        }
    }

    protected String createLinkURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
        return CoreJavaElementLinks.createURI(scheme, this.fElement, refTypeName, refMemberName, refParameterTypes);
    }

    protected boolean containsOnlyNull(List<String> parameterNames) {
        for (String string : parameterNames) {
            if (string == null) continue;
            return false;
        }
        return true;
    }

    protected String getBlockTagStart() {
        return BLOCK_TAG_START;
    }

    protected String getBlockTagEnd() {
        return BLOCK_TAG_END;
    }

    protected String getBlockTagTitleStart() {
        return BlOCK_TAG_TITLE_START;
    }

    protected String getBlockTagTitleEnd() {
        return BlOCK_TAG_TITLE_END;
    }

    protected String getBlockTagEntryStart() {
        return BlOCK_TAG_ENTRY_START;
    }

    protected String getBlockTagEntryEnd() {
        return BlOCK_TAG_ENTRY_END;
    }

    protected String getParamNameStart() {
        return PARAM_NAME_START;
    }

    protected String getParamNameEnd() {
        return PARAM_NAME_END;
    }
}

