/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;

public class JsonUtils {
    private JsonUtils() {
    }

    public static <T> T toModel(Object object, Class<T> clazz) {
        return JsonUtils.toModel(new Gson(), object, clazz);
    }

    private static <T> T toModel(Gson gson, Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class can not be null");
        }
        if (object instanceof JsonElement) {
            JsonElement json = (JsonElement)object;
            return (T)gson.fromJson(json, clazz);
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object instanceof String) {
            String json = (String)object;
            return (T)gson.fromJson(json, clazz);
        }
        return null;
    }
}

