/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.model.actions;

import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.GradleSourceSets;
import com.microsoft.java.bs.gradle.model.impl.DefaultBuildTargetDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSet;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;

public class GetSourceSetsAction
implements BuildAction<GradleSourceSets> {
    public GradleSourceSets execute(BuildController buildController) {
        Collection<GradleBuild> builds = this.fetchIncludedBuilds(buildController);
        List<GradleSourceSet> sourceSets = this.fetchModels(buildController, builds);
        return new DefaultGradleSourceSets(sourceSets);
    }

    private Collection<GradleBuild> fetchIncludedBuilds(BuildController buildController) {
        HashMap<String, GradleBuild> builds = new HashMap<String, GradleBuild>();
        GradleBuild build = buildController.getBuildModel();
        String rootProjectName = build.getRootProject().getName();
        this.fetchIncludedBuilds(build, builds, rootProjectName);
        return builds.values();
    }

    private void fetchIncludedBuilds(GradleBuild build, Map<String, GradleBuild> builds, String rootProjectName) {
        DomainObjectSet moreBuilds;
        if (builds.containsKey(rootProjectName)) {
            return;
        }
        builds.put(rootProjectName, build);
        try {
            moreBuilds = build.getEditableBuilds();
        }
        catch (Exception e1) {
            try {
                moreBuilds = build.getIncludedBuilds();
            }
            catch (Exception e2) {
                moreBuilds = null;
            }
        }
        if (moreBuilds != null) {
            for (GradleBuild includedBuild : moreBuilds) {
                String includedBuildName = includedBuild.getRootProject().getName();
                this.fetchIncludedBuilds(includedBuild, builds, includedBuildName);
            }
        }
    }

    private List<GradleSourceSet> fetchModels(BuildController buildController, Collection<GradleBuild> builds) {
        ArrayList<GetSourceSetAction> projectActions = new ArrayList<GetSourceSetAction>();
        for (GradleBuild build : builds) {
            for (BasicGradleProject project : build.getProjects()) {
                projectActions.add(new GetSourceSetAction(project));
            }
        }
        List<GradleSourceSet> sourceSets = buildController.run(projectActions).stream().flatMap(ss -> ss.getGradleSourceSets().stream()).map(DefaultGradleSourceSet::new).collect(Collectors.toList());
        this.populateInterProjectInfo(sourceSets);
        return sourceSets;
    }

    private void populateInterProjectInfo(List<GradleSourceSet> sourceSets) {
        HashMap<File, List> archivesToSourceOutput = new HashMap<File, List>();
        HashMap<File, GradleSourceSet> outputsToSourceSet = new HashMap<File, GradleSourceSet>();
        for (GradleSourceSet sourceSet : sourceSets) {
            if (sourceSet.getSourceOutputDirs() != null) {
                for (File file : sourceSet.getSourceOutputDirs()) {
                    outputsToSourceSet.put(file, sourceSet);
                }
            }
            if (sourceSet.getResourceOutputDirs() != null) {
                for (File file : sourceSet.getResourceOutputDirs()) {
                    outputsToSourceSet.put(file, sourceSet);
                }
            }
            if (sourceSet.getArchiveOutputFiles() == null) continue;
            for (Map.Entry entry : sourceSet.getArchiveOutputFiles().entrySet()) {
                outputsToSourceSet.put((File)entry.getKey(), sourceSet);
                archivesToSourceOutput.computeIfAbsent((File)entry.getKey(), f -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        for (GradleSourceSet sourceSet : sourceSets) {
            HashSet<BuildTargetDependency> dependencies = new HashSet<BuildTargetDependency>();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : sourceSet.getCompileClasspath()) {
                List sourceOutputDir;
                GradleSourceSet otherSourceSet = (GradleSourceSet)outputsToSourceSet.get(file);
                if (otherSourceSet != null) {
                    dependencies.add(new DefaultBuildTargetDependency(otherSourceSet));
                }
                if ((sourceOutputDir = (List)archivesToSourceOutput.get(file)) == null) {
                    arrayList.add(file);
                    continue;
                }
                arrayList.addAll(sourceOutputDir);
            }
            if (!(sourceSet instanceof DefaultGradleSourceSet)) continue;
            ((DefaultGradleSourceSet)sourceSet).setBuildTargetDependencies(dependencies);
            ((DefaultGradleSourceSet)sourceSet).setCompileClasspath(arrayList);
        }
    }

    static class GetSourceSetAction
    implements BuildAction<GradleSourceSets> {
        private final BasicGradleProject project;

        public GetSourceSetAction(BasicGradleProject project) {
            this.project = project;
        }

        public GradleSourceSets execute(BuildController controller) {
            return (GradleSourceSets)controller.getModel((Model)this.project, GradleSourceSets.class);
        }
    }
}

