/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class NavigateToDeclarationHandler {
    private final PreferenceManager preferenceManager;

    public NavigateToDeclarationHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends Location> declaration(TextDocumentPositionParams position, IProgressMonitor monitor) {
        List list;
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ITypeRoot unit = null;
        try {
            boolean returnCompilationUnit = this.preferenceManager == null ? false : this.preferenceManager.isClientSupportsClassFileContent() && this.preferenceManager.getPreferences().isIncludeDecompiledSources();
            unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri(), returnCompilationUnit, monitor);
            Location location = null;
            if (unit != null && !monitor.isCanceled()) {
                location = this.computeDeclarationNavigation(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
            }
            list = location == null || monitor.isCanceled() ? Collections.emptyList() : Arrays.asList(location);
        }
        catch (Throwable throwable) {
            JDTUtils.discardClassFileWorkingCopy(unit);
            throw throwable;
        }
        JDTUtils.discardClassFileWorkingCopy(unit);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Location computeDeclarationNavigation(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        try {
            IJavaElement element = JDTUtils.findElementAtSelection(unit, line, column, this.preferenceManager, monitor);
            if (monitor.isCanceled()) return null;
            if (element == null) return null;
            if (element.getElementType() != 9) {
                return null;
            }
            IMethod method = (IMethod)element;
            MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester((IType)method.getDeclaringType());
            IMethod methodDeclaration = tester.findDeclaringMethod(method, false);
            if (methodDeclaration == null) {
                return null;
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)methodDeclaration.getAncestor(5);
            IClassFile cf = (IClassFile)methodDeclaration.getAncestor(6);
            if (compilationUnit != null || cf != null && cf.getSourceRange() != null) {
                if (compilationUnit == null) return JDTUtils.toLocation((IJavaElement)methodDeclaration);
                if (compilationUnit.getResource() == null) return JDTUtils.toLocation((IJavaElement)methodDeclaration);
                if (compilationUnit.getResource().exists()) return JDTUtils.toLocation((IJavaElement)methodDeclaration);
                String fqn = compilationUnit.findPrimaryType().getFullyQualifiedName();
                IType type = compilationUnit.getJavaProject().findType(fqn);
                if (type.getClassFile() == null) return null;
                String uriString = JDTUtils.toUri((IClassFile)type.getClassFile());
                Location location = JDTUtils.toLocation(element);
                location.setUri(uriString);
                return location;
            }
            if (!(methodDeclaration instanceof IMember)) return null;
            IMember member = (IMember)methodDeclaration;
            if (member.getClassFile() == null) return null;
            List<Location> locations = JDTUtils.searchDecompiledSources(element, cf, true, true, (IProgressMonitor)new NullProgressMonitor());
            if (locations.isEmpty()) return JDTUtils.toLocation(member.getClassFile());
            return locations.get(0);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem computing declaration for" + unit.getElementName(), e);
        }
        return null;
    }
}

