/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class MarkerInfo
implements IMarkerSetElement,
Cloneable,
IStringPoolParticipant {
    private final MarkerAttributeMap attributes;
    protected final long creationTime;
    protected final long id;
    protected volatile String type;

    protected static Object checkValidAttribute(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String valueString = (String)value;
            if (valueString.length() < 21000) {
                return value;
            }
            byte[] bytes = valueString.getBytes(StandardCharsets.UTF_8);
            if (bytes.length > 65535) {
                String msg = "Marker property value is too long: " + valueString.substring(0, 10000);
                Assert.isTrue(false, msg);
            }
            return value;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        if (value instanceof Integer) {
            return (int)((Integer)value);
        }
        throw new IllegalArgumentException(NLS.bind(Messages.resources_wrongMarkerAttributeValueType, value.getClass().getName()));
    }

    public MarkerInfo(String type, long id) {
        this(null, false, type, id);
    }

    public MarkerInfo(MarkerAttributeMap map, long creationTime, String type, long id) {
        this.attributes = map;
        this.id = id;
        this.creationTime = creationTime;
        this.type = type;
    }

    public MarkerInfo(MarkerInfo markerInfo) {
        this(new MarkerAttributeMap(markerInfo.attributes), markerInfo.creationTime, markerInfo.type, markerInfo.id);
    }

    public MarkerInfo(Map<String, ? extends Object> attributes, boolean validate, long creationTime, String type, long id) {
        this(attributes == null ? new MarkerAttributeMap() : new MarkerAttributeMap(attributes, validate), creationTime, type, id);
    }

    public MarkerInfo(Map<String, ? extends Object> attributes, boolean validate, String type, long id) {
        this(attributes, validate, System.currentTimeMillis(), type, id);
    }

    public Object clone() {
        return new MarkerInfo(this);
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes.toMap();
    }

    public MarkerAttributeMap getAttributes(boolean makeCopy) {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return makeCopy ? new MarkerAttributeMap(this.attributes) : this.attributes;
    }

    public Object[] getAttributes(String[] attributeNames) {
        Object[] result = new Object[attributeNames.length];
        int i = 0;
        while (i < attributeNames.length) {
            result[i] = this.getAttribute(attributeNames[i]);
            ++i;
        }
        return result;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setAttribute(String attributeName, Object value, boolean validate) {
        if (validate) {
            value = MarkerInfo.checkValidAttribute(value);
        }
        if (value == null) {
            this.attributes.remove(attributeName);
        } else {
            this.attributes.put(attributeName, value);
        }
    }

    public void setAttributes(Map<String, ? extends Object> map, boolean validate) {
        this.attributes.setAttributes(map, validate);
    }

    public void addAttributes(String[] attributeNames, Object[] values, boolean validate) {
        Assert.isTrue(attributeNames.length == values.length);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < attributeNames.length) {
            map.put(attributeNames[i], values[i]);
            ++i;
        }
        this.attributes.putAll(map, validate);
    }

    @Override
    public void shareStrings(StringPool set) {
        this.type = set.add(this.type);
        this.attributes.shareStrings(set);
    }
}

