/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.model.actions;

import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.GradleSourceSets;
import com.microsoft.java.bs.gradle.model.GradleSourceSetsMetadata;
import com.microsoft.java.bs.gradle.model.impl.DefaultBuildTargetDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSet;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;

public class GetSourceSetsAction
implements BuildAction<GradleSourceSets> {
    public GradleSourceSets execute(BuildController buildController) {
        HashSet<String> traversedProjects = new HashSet<String>();
        HashMap<GradleSourceSet, List<File>> sourceSetToClasspath = new HashMap<GradleSourceSet, List<File>>();
        HashMap<File, GradleSourceSet> outputsToSourceSet = new HashMap<File, GradleSourceSet>();
        GradleBuild buildModel = buildController.getBuildModel();
        String rootProjectName = buildModel.getRootProject().getName();
        this.fetchModels(buildController, buildModel, traversedProjects, sourceSetToClasspath, outputsToSourceSet, rootProjectName);
        ArrayList<GradleSourceSet> sourceSets = new ArrayList<GradleSourceSet>();
        for (Map.Entry entry : sourceSetToClasspath.entrySet()) {
            HashSet<BuildTargetDependency> dependencies = new HashSet<BuildTargetDependency>();
            for (File file : (List)entry.getValue()) {
                GradleSourceSet otherSourceSet = (GradleSourceSet)outputsToSourceSet.get(file);
                if (otherSourceSet == null || Objects.equals(entry.getKey(), otherSourceSet)) continue;
                dependencies.add(new DefaultBuildTargetDependency(otherSourceSet));
            }
            DefaultGradleSourceSet sourceSet = new DefaultGradleSourceSet((GradleSourceSet)entry.getKey());
            sourceSet.setBuildTargetDependencies(dependencies);
            sourceSets.add(sourceSet);
        }
        return new DefaultGradleSourceSets(sourceSets);
    }

    private void fetchModels(BuildController buildController, GradleBuild build, Set<String> traversedProjects, Map<GradleSourceSet, List<File>> sourceSetToClasspath, Map<File, GradleSourceSet> outputsToSourceSet, String buildName) {
        if (traversedProjects.contains(buildName)) {
            return;
        }
        GradleSourceSetsMetadata sourceSets = (GradleSourceSetsMetadata)buildController.findModel((Model)build.getRootProject(), GradleSourceSetsMetadata.class);
        traversedProjects.add(buildName);
        sourceSetToClasspath.putAll(sourceSets.getGradleSourceSetsToClasspath());
        outputsToSourceSet.putAll(sourceSets.getOutputsToSourceSet());
        for (GradleBuild includedBuild : build.getIncludedBuilds()) {
            String includedBuildName = includedBuild.getRootProject().getName();
            this.fetchModels(buildController, includedBuild, traversedProjects, sourceSetToClasspath, outputsToSourceSet, includedBuildName);
        }
    }
}

