/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.function.Function;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.search.matching.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;

class PatternLocatorVisitor
extends ASTVisitor {
    private final PatternLocator patternLocator;
    private final MatchingNodeSet nodeSet;
    private MatchLocator locator;

    public PatternLocatorVisitor(PatternLocator patternLocator, MatchingNodeSet nodeSet, MatchLocator locator) {
        super(true);
        this.patternLocator = patternLocator;
        this.nodeSet = nodeSet;
        this.locator = locator;
    }

    private <T extends ASTNode> boolean defaultVisitImplementation(T node, Function<T, Integer> levelFunc) {
        return this.defaultVisitImplementationWithFunc(node, levelFunc, DOMASTNodeUtils::getBinding);
    }

    private <T extends ASTNode> boolean defaultVisitImplementationWithFunc(T node, Function<T, Integer> levelFunc, Function<T, IBinding> bindingFunc) {
        int level = levelFunc.apply(node);
        if ((level & 0xF) == 2 && (this.nodeSet.mustResolve || this.patternLocator.mustResolve)) {
            level = this.patternLocator.resolveLevel(node, bindingFunc.apply(node), this.locator);
        }
        this.nodeSet.addMatch(node, level);
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(TypeParameter node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(MethodInvocation node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    private boolean visitAbstractTypeDeclaration(AbstractTypeDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        return this.visitAbstractTypeDeclaration(node);
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        return this.visitAbstractTypeDeclaration(node);
    }

    @Override
    public boolean visit(RecordDeclaration node) {
        return this.visitAbstractTypeDeclaration(node);
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    private boolean visitType(Type node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(SimpleType type) {
        this.visitType(type);
        Name n = type.getName();
        if (n instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)n;
            Name qualifier = qn.getQualifier();
            if (qualifier instanceof SimpleName) {
                SimpleName sn1 = (SimpleName)qualifier;
                this.visit(sn1);
            } else if (qualifier instanceof QualifiedName) {
                QualifiedName qn1 = (QualifiedName)qualifier;
                this.visit(qn1);
            }
        }
        return false;
    }

    @Override
    public boolean visit(QualifiedType type) {
        return this.visitType(type);
    }

    @Override
    public boolean visit(NameQualifiedType type) {
        return this.visitType(type);
    }

    @Override
    public boolean visit(ParameterizedType node) {
        return this.visitType(node);
    }

    @Override
    public boolean visit(IntersectionType node) {
        return this.visitType(node);
    }

    @Override
    public boolean visit(UnionType node) {
        return this.visitType(node);
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(CreationReference node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(SimpleName node) {
        if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY || node.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY || node.getLocationInParent() == TypeDeclaration.NAME_PROPERTY || node.getLocationInParent() == EnumDeclaration.NAME_PROPERTY || node.getLocationInParent() == MethodDeclaration.NAME_PROPERTY) {
            return false;
        }
        int level = this.patternLocator.match(node, this.nodeSet, this.locator);
        if ((level & 0xF) == 2 && (this.nodeSet.mustResolve || this.patternLocator.mustResolve)) {
            IBinding b = node.resolveBinding();
            level = this.patternLocator.resolveLevel(node, b, this.locator);
        }
        this.nodeSet.addMatch(node, level);
        return level == 0;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        return this.defaultVisitImplementation(node, x -> this.patternLocator.match(node, this.nodeSet, this.locator));
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        int level = this.patternLocator.match(node, this.nodeSet, this.locator);
        if ((level & 0xF) == 2 && (this.nodeSet.mustResolve || this.patternLocator.mustResolve)) {
            int l1 = this.patternLocator.resolveLevel(node, node.resolveVariable(), this.locator);
            int l2 = this.patternLocator.resolveLevel(node, node.resolveConstructorBinding(), this.locator);
            level = Math.max(l1, l2);
        }
        this.nodeSet.addMatch(node, level);
        return true;
    }

    @Override
    public boolean visit(QualifiedName node) {
        if (node.getLocationInParent() == SimpleType.NAME_PROPERTY) {
            return false;
        }
        int level = this.patternLocator.match(node, this.nodeSet, this.locator);
        if ((level & 0xF) == 2 && (this.nodeSet.mustResolve || this.patternLocator.mustResolve)) {
            level = this.patternLocator.resolveLevel(node, node.resolveBinding(), this.locator);
        }
        this.nodeSet.addMatch(node, level);
        return (level & 0xF) == 0;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        return true;
    }
}

